/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.template;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import org.itsnat.core.ItsNatDOMException;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.ItsNatServletRequest;
import org.itsnat.core.ItsNatServletResponse;
import org.itsnat.impl.core.MarkupContainerImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.itsnat.impl.core.domutil.NamespaceUtil;
import org.itsnat.impl.core.markup.parse.XercesDOMParserWrapperImpl;
import org.itsnat.impl.core.markup.render.DOMRenderImpl;
import org.itsnat.impl.core.servlet.ItsNatServletImpl;
import org.itsnat.impl.core.template.CachedSubtreeDefaultImpl;
import org.itsnat.impl.core.template.CachedSubtreeImpl;
import org.itsnat.impl.core.template.CachedTextNodeImpl;
import org.itsnat.impl.core.template.ItsNatDocFragmentTemplateImpl;
import org.itsnat.impl.core.template.ItsNatDocFragmentTemplateVersionImpl;
import org.itsnat.impl.core.template.ItsNatStfulDocumentTemplateAttachedServerImpl;
import org.itsnat.impl.core.template.ItsNatStfulDocumentTemplateVersionImpl;
import org.itsnat.impl.core.template.MarkupSourceImpl;
import org.itsnat.impl.core.template.MarkupSourceStringMarkupImpl;
import org.itsnat.impl.core.template.MarkupTemplateImpl;
import org.itsnat.impl.core.template.MarkupTemplateVersionDelegateImpl;
import org.itsnat.impl.core.util.HasUniqueId;
import org.itsnat.impl.core.util.MapUniqueId;
import org.itsnat.impl.core.util.UniqueId;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public abstract class MarkupTemplateVersionImpl
extends MarkupContainerImpl
implements HasUniqueId {
    protected MarkupTemplateImpl markupTemplate;
    protected Document templateDoc;
    protected long timeStamp;
    protected MarkupTemplateVersionDelegateImpl templateDelegate;
    protected MapUniqueId<CachedSubtreeImpl> elementCacheMap;
    protected LinkedList<ItsNatDocFragmentTemplateVersionImpl> fragments = new LinkedList();

    public MarkupTemplateVersionImpl(MarkupTemplateImpl markupTemplate, InputSource source, long timeStamp, ItsNatServletRequest request, ItsNatServletResponse response) {
        super(markupTemplate.getItsNatServletImpl().getUniqueIdGenerator());
        this.markupTemplate = markupTemplate;
        this.timeStamp = timeStamp;
        this.templateDelegate = this.createMarkupTemplateVersionDelegate();
        this.templateDoc = this.parseDocumentOrFragment(source, markupTemplate.getMarkupParser(), false);
        Element rootElem = this.templateDoc.getDocumentElement();
        this.processCommentsIncludesInTree(rootElem, request, response);
    }

    public static void writeObject(MarkupTemplateVersionImpl templateVersion, ObjectOutputStream out) throws IOException {
        MarkupTemplateImpl.writeObject(templateVersion.getMarkupTemplate(), out);
    }

    public static String[] readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        return MarkupTemplateImpl.readObject(in);
    }

    public static MarkupTemplateVersionImpl getNewestMarkupTemplateVersion(ItsNatServletImpl itsNatServlet, String[] templateId, MarkupSourceStringMarkupImpl source, ItsNatServletRequest request, ItsNatServletResponse response) {
        MarkupTemplateImpl template = MarkupTemplateImpl.getMarkupTemplate(itsNatServlet, templateId);
        if (template instanceof ItsNatStfulDocumentTemplateAttachedServerImpl) {
            ItsNatStfulDocumentTemplateVersionImpl templateVersion = ((ItsNatStfulDocumentTemplateAttachedServerImpl)template).getNewestItsNatStfulDocumentTemplateVersion(source, request, response);
            templateVersion.cleanDOMPattern();
            return templateVersion;
        }
        if (source != null) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        return template.getNewestMarkupTemplateVersion(request, response);
    }

    public MarkupTemplateImpl getMarkupTemplate() {
        return this.markupTemplate;
    }

    public void setMarkupTemplate(MarkupTemplateImpl markupTemplate) {
        this.markupTemplate = markupTemplate;
    }

    protected void doCacheAndNormalizeDocument() {
        if (this.isOnLoadCacheStaticNodes()) {
            this.doCacheDocument();
        }
        this.templateDelegate.normalizeDocument(this.getDocument());
    }

    public DOMRenderImpl createNodeDOMRender(Document doc, boolean nodeOnlyRender) {
        return DOMRenderImpl.createDOMRender(doc, this.getMIME(), this.getEncoding(), nodeOnlyRender);
    }

    public Document parseDocumentOrFragment(String code, XercesDOMParserWrapperImpl parser, boolean isFragment) {
        StringReader reader = new StringReader(code);
        return this.parseDocumentOrFragment(new InputSource(reader), parser, isFragment);
    }

    public Document parseDocumentOrFragment(InputSource input, XercesDOMParserWrapperImpl parser, boolean isFragment) {
        String encoding = this.getEncoding();
        input.setEncoding(encoding);
        return parser.parse(input);
    }

    public boolean isDocFragment() {
        return this.markupTemplate.isDocFragment();
    }

    @Override
    public String getIdGenPrefix() {
        return "mt";
    }

    @Override
    public ItsNatServletImpl getItsNatServlet() {
        return this.markupTemplate.getItsNatServletImpl();
    }

    public boolean isOnLoadCacheStaticNodes() {
        return this.markupTemplate.isOnLoadCacheStaticNodes();
    }

    public boolean isMIME_XHTML() {
        return this.markupTemplate.isMIME_XHTML();
    }

    public boolean isMIME_HTML() {
        return this.markupTemplate.isMIME_HTML();
    }

    @Override
    public String getId() {
        return this.idObj.getId();
    }

    @Override
    public UniqueId getUniqueId() {
        return this.idObj;
    }

    @Override
    public Document getDocument() {
        return this.templateDoc;
    }

    public String getEncoding() {
        return this.markupTemplate.getEncoding();
    }

    public String getNamespace() {
        return this.markupTemplate.getNamespace();
    }

    public String getMIME() {
        return this.markupTemplate.getMIME();
    }

    public boolean isInvalid(MarkupSourceImpl source, ItsNatServletRequest request, ItsNatServletResponse response) {
        boolean invalid = source.isMustReload(this.timeStamp, request, response);
        if (invalid) {
            return true;
        }
        for (ItsNatDocFragmentTemplateVersionImpl docFragTemplateIncVersion : this.fragments) {
            if (!docFragTemplateIncVersion.isInvalid(request, response)) continue;
            return true;
        }
        return false;
    }

    public boolean processCommentsIncludesInNode(Node node, ItsNatServletRequest request, ItsNatServletResponse response) {
        if (node.getNodeType() != 1) {
            return false;
        }
        Element nodeElem = (Element)node;
        String namespace = nodeElem.getNamespaceURI();
        if (NamespaceUtil.isItsNatNamespace(namespace)) {
            String localName = nodeElem.getLocalName();
            if (!this.getMarkupTemplate().isItsNatTagsAllowed()) {
                throw new ItsNatException("ItsNat tags are not allowed in this context, detected: " + localName, (Object)node);
            }
            if (localName.equals("include")) {
                String fragName = nodeElem.getAttribute("name");
                this.processIncludeReplacingNode(nodeElem, fragName, request, response);
                return true;
            }
            if (localName.equals("comment")) {
                nodeElem.getParentNode().removeChild(nodeElem);
                return true;
            }
            throw new ItsNatDOMException("Unknown itsnat tag name:" + localName, (Node)nodeElem);
        }
        if (nodeElem.hasAttributes()) {
            NamedNodeMap attribs = nodeElem.getAttributes();
            for (int i = 0; i < attribs.getLength(); ++i) {
                String fragName;
                Attr attr = (Attr)attribs.item(i);
                namespace = attr.getNamespaceURI();
                if (!NamespaceUtil.isItsNatNamespace(namespace)) continue;
                String localName = attr.getLocalName();
                if (localName.equals("include")) {
                    fragName = attr.getValue();
                    this.processIncludeReplacingNode(nodeElem, fragName, request, response);
                    nodeElem.removeAttributeNode(attr);
                    continue;
                }
                if (localName.equals("includeInside")) {
                    fragName = attr.getValue();
                    this.processIncludeInsideNode(nodeElem, fragName, request, response);
                    nodeElem.removeAttributeNode(attr);
                    continue;
                }
                if (!localName.equals("comment")) continue;
                nodeElem.removeAttributeNode(attr);
            }
        }
        return false;
    }

    public DocumentFragment loadDocumentFragmentByIncludeTag(Element includeElem, String fragName, ItsNatServletRequest request, ItsNatServletResponse response) {
        ItsNatDocFragmentTemplateImpl docFragTemplateInc = (ItsNatDocFragmentTemplateImpl)this.markupTemplate.getItsNatServlet().getItsNatDocFragmentTemplate(fragName);
        if (docFragTemplateInc == null) {
            throw new ItsNatDOMException("Document fragment not found: " + fragName, (Node)includeElem);
        }
        ItsNatDocFragmentTemplateVersionImpl docFragTemplateIncVersion = docFragTemplateInc.getNewestItsNatDocFragmentTemplateVersion(request, response);
        this.fragments.add(docFragTemplateIncVersion);
        return docFragTemplateIncVersion.loadDocumentFragmentByIncludeTag(this, includeElem);
    }

    public void processIncludeReplacingNode(Element includeElem, String fragName, ItsNatServletRequest request, ItsNatServletResponse response) {
        DocumentFragment docFrag = this.loadDocumentFragmentByIncludeTag(includeElem, fragName, request, response);
        Node parent = includeElem.getParentNode();
        parent.insertBefore(docFrag, includeElem);
        parent.removeChild(includeElem);
    }

    public void processIncludeInsideNode(Element includeElem, String fragName, ItsNatServletRequest request, ItsNatServletResponse response) {
        DocumentFragment docFrag = this.loadDocumentFragmentByIncludeTag(includeElem, fragName, request, response);
        DOMUtilInternal.removeAllChildren(includeElem);
        includeElem.appendChild(docFrag);
    }

    public void processCommentsIncludesInTree(Node node, ItsNatServletRequest request, ItsNatServletResponse response) {
        if (!this.processCommentsIncludesInNode(node, request, response)) {
            this.processCommentsIncludesInChildren(node, request, response);
        }
    }

    public void processCommentsIncludesInChildren(Node parent, ItsNatServletRequest request, ItsNatServletResponse response) {
        Node child = parent.getFirstChild();
        while (child != null) {
            Node nextChild = child.getNextSibling();
            this.processCommentsIncludesInTree(child, request, response);
            child = nextChild;
        }
    }

    private String serializeChildNodes(Element parent, DOMRenderImpl nodeRender) {
        StringWriter out = new StringWriter();
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.serializeNode(child, out, nodeRender);
        }
        return out.toString();
    }

    public String serializeNode(Node node, DOMRenderImpl nodeRender) {
        StringWriter out = new StringWriter();
        this.serializeNode(node, out, nodeRender);
        return out.toString();
    }

    public void serializeNode(Node node, Writer out, DOMRenderImpl nodeRender) {
        this.templateDelegate.serializeNode(node, out, nodeRender);
    }

    protected boolean isNodeStaticAndFindCacheable(Node node, LinkedList<Node> cacheableList) {
        if (node instanceof Element) {
            return this.isElementStaticOrFindCacheableChildren((Element)node, cacheableList);
        }
        if (node instanceof CharacterData) {
            return this.isCharacterDataStaticAndFindCacheable((CharacterData)node, cacheableList);
        }
        return false;
    }

    private boolean isCharacterDataStaticAndFindCacheable(CharacterData node, LinkedList<Node> cacheableList) {
        if (this.isCharacterDataStatic(node)) {
            cacheableList.add(node);
            return true;
        }
        return false;
    }

    private boolean isCharacterDataStatic(CharacterData node) {
        return !this.hasVariables(node.getData());
    }

    protected boolean isElementValidForCaching(Element elem) {
        return true;
    }

    protected boolean isElementStaticOrFindCacheableChildren(Element elem, LinkedList<Node> cacheableList) {
        if (this.isDeclaredNotCacheable(elem)) {
            return false;
        }
        if (this.declaredAsComponent(elem)) {
            return false;
        }
        LinkedList<Node> cacheableChildrenLocal = new LinkedList<Node>();
        boolean childrenAreStatic = this.areChildNodesStaticAndFindCacheable(elem, cacheableChildrenLocal);
        boolean elementCacheableCapable = this.isElementValidForCaching(elem);
        if (childrenAreStatic && elementCacheableCapable) {
            cacheableList.add(elem);
        } else {
            cacheableList.addAll(cacheableChildrenLocal);
        }
        boolean attributesStatic = this.areAllAttributesStatic(elem);
        return elementCacheableCapable && attributesStatic && childrenAreStatic;
    }

    protected boolean areChildNodesStaticAndFindCacheable(Element elem, LinkedList<Node> cacheableList) {
        if (!elem.hasChildNodes()) {
            return true;
        }
        boolean allChildrenStatic = true;
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (this.isNodeStaticAndFindCacheable(child, cacheableList)) continue;
            allChildrenStatic = false;
        }
        return allChildrenStatic;
    }

    protected boolean isRootElementCacheableOrFindCacheableChildren(Element elem, LinkedList<Node> cacheableChildren) {
        return this.isElementStaticOrFindCacheableChildren(elem, cacheableChildren);
    }

    private boolean isDeclaredNotCacheable(Element elem) {
        String nocache = elem.getAttributeNS("http://itsnat.org/itsnat", "nocache");
        return "true".equals(nocache);
    }

    private boolean areAllAttributesStatic(Node node) {
        if (!node.hasAttributes()) {
            return true;
        }
        boolean allStatic = true;
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            if (!this.hasVariables(attr.getValue())) continue;
            allStatic = false;
            break;
        }
        return allStatic;
    }

    private boolean hasVariables(String content) {
        int index = content.indexOf("${");
        return index != -1;
    }

    public boolean declaredAsComponent(Element elem) {
        return this.templateDelegate.declaredAsComponent(elem);
    }

    protected void doCacheDocument() {
        LinkedList<Node> cacheableChildren;
        Document docTemplate = this.getDocument();
        DOMRenderImpl nodeRender = this.createNodeDOMRender(docTemplate, true);
        Element rootElem = docTemplate.getDocumentElement();
        boolean cacheable = this.isRootElementCacheableOrFindCacheableChildren(rootElem, cacheableChildren = new LinkedList<Node>());
        if (cacheable) {
            this.addNodeToCache(rootElem, nodeRender);
        } else {
            for (Node child : cacheableChildren) {
                this.addNodeToCache(child, nodeRender);
            }
        }
    }

    protected void addNodeToCache(Node node, DOMRenderImpl nodeRender) {
        if (node instanceof Element) {
            this.addElementToCache((Element)node, nodeRender);
        } else if (node instanceof CharacterData) {
            this.addCharacterDataToCache((CharacterData)node, nodeRender);
        } else {
            throw new ItsNatDOMException("INTERNAL ERROR", node);
        }
    }

    protected void addElementToCache(Element elem, DOMRenderImpl nodeRender) {
        if (!elem.hasChildNodes()) {
            return;
        }
        Node firstChild = elem.getFirstChild();
        if (firstChild.getNextSibling() == null && firstChild instanceof CharacterData) {
            this.addCharacterDataToCache((CharacterData)firstChild, nodeRender);
        } else {
            String code = this.serializeChildNodes(elem, nodeRender);
            DOMUtilInternal.removeAllChildren(elem);
            Document doc = elem.getOwnerDocument();
            String markedCode = this.addToCache(elem, code);
            Text markNode = doc.createTextNode(markedCode);
            elem.appendChild(markNode);
        }
    }

    public MapUniqueId<CachedSubtreeImpl> getElementCacheMap() {
        if (this.elementCacheMap == null) {
            this.elementCacheMap = new MapUniqueId(this.idGenerator);
        }
        return this.elementCacheMap;
    }

    @Override
    public boolean hasCachedNodes() {
        return this.elementCacheMap != null || this.usedTemplatesWithCachedNodes != null;
    }

    protected void addCharacterDataToCache(CharacterData node, DOMRenderImpl nodeRender) {
        String prefix;
        String value = node.getData();
        if (value.length() < 100) {
            return;
        }
        String code = this.serializeNode(node, nodeRender);
        short nodeType = node.getNodeType();
        if (nodeType == 8 || nodeType == 4) {
            String suffix;
            if (nodeType == 8) {
                prefix = "<!--";
                suffix = "-->";
            } else {
                prefix = "<![CDATA[";
                suffix = "]]>";
            }
            code = MarkupTemplateVersionImpl.removePrefixSuffix(code, prefix, suffix);
        } else if (nodeType == 3 && this.isMIME_XHTML()) {
            prefix = "<![CDATA[";
            String suffix = "]]>";
            if (code.startsWith(prefix)) {
                code = MarkupTemplateVersionImpl.removePrefixSuffix(code, prefix, suffix);
            }
        }
        String markCode = this.addToCache(node, code);
        node.setData(markCode);
    }

    public static String removePrefixSuffix(String code, String prefix, String suffix) {
        code = code.substring(prefix.length(), code.length() - suffix.length());
        return code;
    }

    protected CachedSubtreeImpl createCachedSubtree(Node node, String code) {
        if (node instanceof Text) {
            return new CachedTextNodeImpl(this, code, ((Text)node).getData());
        }
        return new CachedSubtreeDefaultImpl(this, code);
    }

    protected String addToCache(Node node, String code) {
        CachedSubtreeImpl cachedNode = this.createCachedSubtree(node, code);
        MapUniqueId<CachedSubtreeImpl> elementCacheMap = this.getElementCacheMap();
        elementCacheMap.put(cachedNode);
        return cachedNode.getMarkCode();
    }

    @Override
    public MarkupTemplateVersionImpl getUsedMarkupTemplateVersion(String id) {
        if (this.getId().equals(id)) {
            return this;
        }
        return super.getUsedMarkupTemplateVersion(id);
    }

    protected abstract MarkupTemplateVersionDelegateImpl createMarkupTemplateVersionDelegate();

    public void cleanDOMPattern() {
        this.templateDoc = null;
    }
}

