/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.template;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.ItsNatServlet;
import org.itsnat.core.ItsNatServletConfig;
import org.itsnat.core.ItsNatServletRequest;
import org.itsnat.core.ItsNatServletResponse;
import org.itsnat.core.tmpl.MarkupTemplate;
import org.itsnat.impl.core.ItsNatUserDataImpl;
import org.itsnat.impl.core.domutil.NamespaceUtil;
import org.itsnat.impl.core.markup.parse.XercesDOMParserWrapperImpl;
import org.itsnat.impl.core.servlet.ItsNatServletImpl;
import org.itsnat.impl.core.template.ItsNatDocumentTemplateImpl;
import org.itsnat.impl.core.template.MarkupSourceImpl;
import org.itsnat.impl.core.template.MarkupTemplateDelegateImpl;
import org.itsnat.impl.core.template.MarkupTemplateVersionImpl;
import org.xml.sax.InputSource;

public abstract class MarkupTemplateImpl
extends ItsNatUserDataImpl
implements MarkupTemplate {
    protected MarkupTemplateDelegateImpl delegate;
    protected final XercesDOMParserWrapperImpl parser;
    protected final String name;
    protected final String mime;
    protected final ItsNatServletImpl servlet;
    protected String encoding;
    protected boolean onLoadCachingDOMNodes;
    protected final int namespaceOfMIME;

    public MarkupTemplateImpl(String name, String mime, MarkupSourceImpl source, ItsNatServletImpl servlet) {
        super(true);
        this.name = name;
        this.mime = mime;
        this.servlet = servlet;
        ItsNatServletConfig servletConfig = servlet.getItsNatServletConfig();
        this.encoding = servletConfig.getDefaultEncoding();
        this.namespaceOfMIME = NamespaceUtil.getNamespaceCode(mime);
        this.onLoadCachingDOMNodes = servletConfig.isOnLoadCacheStaticNodes(this.getMIME());
        this.delegate = this.createMarkupTemplateDelegate(source);
        this.parser = this.createMarkupParser();
    }

    public abstract MarkupTemplateDelegateImpl createMarkupTemplateDelegate(MarkupSourceImpl var1);

    public XercesDOMParserWrapperImpl getMarkupParser() {
        return this.parser;
    }

    protected XercesDOMParserWrapperImpl createMarkupParser() {
        return XercesDOMParserWrapperImpl.createXercesDOMParserWrapper(this.namespaceOfMIME, this.encoding);
    }

    public abstract boolean isDocFragment();

    public boolean isMIME_XHTML() {
        return NamespaceUtil.isMIME_XHTML(this.namespaceOfMIME);
    }

    public boolean isMIME_HTML() {
        return NamespaceUtil.isMIME_HTML(this.namespaceOfMIME);
    }

    public boolean isMIME_HTML_or_XHTML() {
        return NamespaceUtil.isMIME_HTML_or_XHTML(this.namespaceOfMIME);
    }

    public boolean isMIME_OTHERNS() {
        return NamespaceUtil.isMIME_OTHERNS(this.namespaceOfMIME);
    }

    public boolean isMIME_SVG() {
        return NamespaceUtil.isMIME_SVG(this.namespaceOfMIME);
    }

    public boolean isMIME_XUL() {
        return NamespaceUtil.isMIME_XUL(this.namespaceOfMIME);
    }

    public boolean isMIME_XML() {
        return NamespaceUtil.isMIME_XML(this.namespaceOfMIME);
    }

    public boolean isMIME_ANDROID_LAYOUT() {
        return NamespaceUtil.isMIME_ANDROID_LAYOUT(this.namespaceOfMIME);
    }

    public String getNamespace() {
        return NamespaceUtil.getNamespace(this.namespaceOfMIME);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMIME() {
        return this.mime;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.checkIsAlreadyUsed();
        this.encoding = encoding;
    }

    @Override
    public boolean isOnLoadCacheStaticNodes() {
        return this.onLoadCachingDOMNodes;
    }

    @Override
    public void setOnLoadCacheStaticNodes(boolean value) {
        this.checkIsAlreadyUsed();
        this.onLoadCachingDOMNodes = value;
    }

    @Override
    public Object getSource() {
        return this.delegate.getSource();
    }

    public MarkupTemplateVersionImpl getNewestMarkupTemplateVersion(ItsNatServletRequest request, ItsNatServletResponse response) {
        return this.delegate.getNewestMarkupTemplateVersion(request, response);
    }

    @Override
    public ItsNatServlet getItsNatServlet() {
        return this.servlet;
    }

    public ItsNatServletImpl getItsNatServletImpl() {
        return this.servlet;
    }

    public abstract MarkupTemplateVersionImpl createMarkupTemplateVersion(InputSource var1, long var2, ItsNatServletRequest var4, ItsNatServletResponse var5);

    public void checkIsAlreadyUsed() {
        if (this.delegate.isTemplateAlreadyUsed()) {
            throw new ItsNatException("Template is frozen because some document/fragment was already loaded", (Object)this);
        }
    }

    public boolean isItsNatTagsAllowed() {
        return this.delegate.isItsNatTagsAllowed();
    }

    public static void writeObject(MarkupTemplateImpl template, ObjectOutputStream out) throws IOException {
        String templateType = template instanceof ItsNatDocumentTemplateImpl ? "document" : "docFrag";
        String templateName = template.getName();
        out.writeObject(templateType);
        out.writeObject(templateName);
    }

    public static String[] readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String templateType = (String)in.readObject();
        String templateName = (String)in.readObject();
        return new String[]{templateType, templateName};
    }

    public static MarkupTemplateImpl getMarkupTemplate(ItsNatServletImpl itsNatServlet, String[] templateId) {
        String templateType = templateId[0];
        String templateName = templateId[1];
        if (templateType.equals("document")) {
            return itsNatServlet.getItsNatDocumentTemplateImpl(templateName);
        }
        return itsNatServlet.getItsNatDocFragmentTemplateImpl(templateName);
    }
}

