/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.template;

import java.io.File;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.ItsNatServletRequest;
import org.itsnat.core.ItsNatServletResponse;
import org.itsnat.impl.core.template.MarkupSourceFromFileImpl;
import org.xml.sax.InputSource;

public class MarkupSourceLocalFileImpl
extends MarkupSourceFromFileImpl {
    protected final File file;
    protected String url;

    public MarkupSourceLocalFileImpl(String path) {
        this.file = new File(path);
        if (!this.file.exists()) {
            throw new ItsNatException("File " + this.file.getAbsoluteFile() + " does not exist");
        }
        int index = path.indexOf("file:");
        this.url = index != -1 ? path : "file:" + path;
    }

    @Override
    public long getCurrentTimestamp(ItsNatServletRequest request, ItsNatServletResponse response) {
        if (!this.file.exists()) {
            throw new ItsNatException("File " + this.file.getAbsoluteFile() + " does not exist", (Object)this);
        }
        return this.file.lastModified();
    }

    @Override
    public boolean isMustReload(long oldTimestamp, ItsNatServletRequest request, ItsNatServletResponse response) {
        long currentTimeStamp = this.getCurrentTimestamp(request, response);
        return currentTimeStamp > oldTimestamp;
    }

    @Override
    public InputSource createInputSource(ItsNatServletRequest request, ItsNatServletResponse response) {
        return new InputSource(this.url);
    }

    @Override
    public Object getSource() {
        return this.url;
    }
}

