/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.template;

import java.text.DateFormat;
import java.text.NumberFormat;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.ItsNatServletRequest;
import org.itsnat.core.ItsNatServletResponse;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.domimpl.BatikItsNatDOMImplementationImpl;
import org.itsnat.impl.core.domimpl.DocumentImpl;
import org.itsnat.impl.core.domimpl.XMLDecImpl;
import org.itsnat.impl.core.markup.parse.XercesDOMParserWrapperImpl;
import org.itsnat.impl.core.req.norm.RequestNormalLoadDocImpl;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionImpl;
import org.itsnat.impl.core.template.ItsNatDocumentTemplateImpl;
import org.itsnat.impl.core.template.MarkupTemplateVersionImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public abstract class ItsNatDocumentTemplateVersionImpl
extends MarkupTemplateVersionImpl {
    public ItsNatDocumentTemplateVersionImpl(ItsNatDocumentTemplateImpl docTemplate, InputSource source, long timeStamp, ItsNatServletRequest request, ItsNatServletResponse response) {
        super(docTemplate, source, timeStamp, request, response);
        if (this.isReferrerEnabled() && !this.isEventsEnabled()) {
            throw new ItsNatException("Referrer feature needs events enabled", (Object)docTemplate);
        }
        if (!this.isScriptingEnabled()) {
            if (this.isEventsEnabled()) {
                throw new ItsNatException("Events cannot be enabled whether scripting is disabled", (Object)docTemplate);
            }
            if (!this.isFastLoadMode()) {
                throw new ItsNatException("Fast load mode must be enabled if scripting is disabled", (Object)docTemplate);
            }
        }
        this.doCacheAndNormalizeDocument();
    }

    public XercesDOMParserWrapperImpl createMarkupParser() {
        return this.markupTemplate.createMarkupParser();
    }

    public boolean isFastLoadMode() {
        return this.getItsNatDocumentTemplate().isFastLoadMode();
    }

    public boolean isDebugMode() {
        return this.getItsNatDocumentTemplate().isDebugMode();
    }

    public int getClientErrorMode() {
        return this.getItsNatDocumentTemplate().getClientErrorMode();
    }

    public int getCommMode() {
        return this.getItsNatDocumentTemplate().getCommMode();
    }

    public long getEventTimeout() {
        return this.getItsNatDocumentTemplate().getEventTimeout();
    }

    public int getUseGZip() {
        return this.getItsNatDocumentTemplate().getUseGZip();
    }

    public boolean isNodeCacheEnabled() {
        return this.getItsNatDocumentTemplate().isNodeCacheEnabled();
    }

    public boolean isAutoBuildComponents() {
        return this.getItsNatDocumentTemplate().isAutoBuildComponents();
    }

    public boolean isLoadScriptInline() {
        return this.getItsNatDocumentTemplate().isLoadScriptInline();
    }

    public boolean isReferrerPushEnabled() {
        return this.getItsNatDocumentTemplate().isReferrerPushEnabled();
    }

    public boolean canVersionBeSharedBetweenDocs() {
        return this.getItsNatDocumentTemplate().canVersionBeSharedBetweenDocs();
    }

    public ItsNatDocumentImpl loadItsNatDocument(RequestNormalLoadDocImpl request) {
        ItsNatServletRequestImpl itsNatRequest = request.getItsNatServletRequest();
        Browser browser = this.getBrowser(itsNatRequest);
        Document doc = this.loadDocument(browser);
        boolean stateless = request.isStateless();
        ItsNatDocumentImpl itsNatDoc = this.createItsNatDocument(doc, browser, itsNatRequest.getRequestURLInternal().toString(), itsNatRequest.getItsNatSessionImpl(), stateless);
        if (!this.canVersionBeSharedBetweenDocs()) {
            this.cleanDOMPattern();
        }
        return itsNatDoc;
    }

    public Browser getBrowser(ItsNatServletRequestImpl itsNatRequest) {
        String userAgent = itsNatRequest.getHeader("User-Agent");
        Browser currBrowser = itsNatRequest.getItsNatSessionImpl().getBrowser();
        if (currBrowser.getUserAgent().equals(userAgent)) {
            return currBrowser;
        }
        return Browser.createBrowser(itsNatRequest);
    }

    protected abstract ItsNatDocumentImpl createItsNatDocument(Document var1, Browser var2, String var3, ItsNatSessionImpl var4, boolean var5);

    public Document loadDocument(Browser browser) {
        return this.manualClone();
    }

    protected Document manualClone() {
        Document doc = this.getDocument();
        Document cloneDoc = this.manualCloneDocument(doc);
        if (doc.hasChildNodes()) {
            Element root = doc.getDocumentElement();
            Element cloneRoot = cloneDoc.getDocumentElement();
            for (Node child = doc.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child instanceof DocumentType) continue;
                if (child == root) {
                    this.manualCloneTree(child, cloneDoc, cloneDoc);
                    continue;
                }
                Node cloneChild = this.manualCloneNode(child, cloneDoc);
                cloneDoc.insertBefore(cloneChild, cloneRoot);
            }
        }
        return cloneDoc;
    }

    protected Node manualCloneTree(Node node, Node cloneParent, Document cloneDoc) {
        Node cloneNode = this.manualCloneNodeAndAppend(node, cloneParent, cloneDoc);
        if (node.hasAttributes()) {
            Element cloneElem = (Element)cloneNode;
            NamedNodeMap attribs = node.getAttributes();
            int len = attribs.getLength();
            for (int i = 0; i < len; ++i) {
                Attr attr = (Attr)attribs.item(i);
                Attr cloneAttr = (Attr)this.manualCloneNode(attr, cloneDoc);
                String namespace = cloneAttr.getNamespaceURI();
                if (namespace != null) {
                    cloneElem.setAttributeNodeNS(cloneAttr);
                    continue;
                }
                cloneElem.setAttributeNode(cloneAttr);
            }
        }
        if (node.hasChildNodes()) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.manualCloneTree(child, cloneNode, cloneDoc);
            }
        }
        return cloneNode;
    }

    protected Node manualCloneNodeAndAppend(Node node, Node cloneParent, Document cloneDoc) {
        Node cloneNode;
        if (node == node.getOwnerDocument().getDocumentElement() && cloneDoc.getDocumentElement() != null) {
            cloneNode = cloneDoc.getDocumentElement();
        } else {
            cloneNode = this.manualCloneNode(node, cloneDoc);
            cloneParent.appendChild(cloneNode);
        }
        return cloneNode;
    }

    protected Node manualCloneNode(Node node, Document cloneDoc) {
        Node cloneNode = null;
        switch (node.getNodeType()) {
            case 2: {
                Attr attr = (Attr)node;
                cloneNode = cloneDoc.createAttributeNS(attr.getNamespaceURI(), attr.getName());
                ((Attr)cloneNode).setValue(attr.getValue());
                break;
            }
            case 4: {
                cloneNode = cloneDoc.createCDATASection(((CDATASection)node).getData());
                break;
            }
            case 8: {
                cloneNode = cloneDoc.createComment(((Comment)node).getData());
                break;
            }
            case 11: {
                throw new ItsNatException("INTERNAL ERROR");
            }
            case 9: {
                throw new ItsNatException("INTERNAL ERROR");
            }
            case 10: {
                throw new ItsNatException("INTERNAL ERROR");
            }
            case 1: {
                Element elem = (Element)node;
                cloneNode = this.manualCloneElement(elem, cloneDoc);
                break;
            }
            case 6: {
                throw new ItsNatException("INTERNAL ERROR");
            }
            case 5: {
                cloneNode = cloneDoc.createEntityReference(((EntityReference)node).getNodeName());
                break;
            }
            case 12: {
                throw new ItsNatException("INTERNAL ERROR");
            }
            case 7: {
                ProcessingInstruction procInst = (ProcessingInstruction)node;
                cloneNode = cloneDoc.createProcessingInstruction(procInst.getTarget(), procInst.getData());
                break;
            }
            case 3: {
                cloneNode = cloneDoc.createTextNode(((Text)node).getData());
            }
        }
        return cloneNode;
    }

    protected Document manualCloneDocument(Document doc) {
        BatikItsNatDOMImplementationImpl domImplClone = BatikItsNatDOMImplementationImpl.getBatikItsNatDOMImplementation();
        DocumentType cloneDocType = null;
        DocumentType docType = doc.getDoctype();
        if (docType != null) {
            cloneDocType = domImplClone.createDocumentType(docType.getNodeName(), docType.getPublicId(), docType.getSystemId());
        }
        Element docElem = doc.getDocumentElement();
        DocumentImpl docClone = (DocumentImpl)domImplClone.createDocument(docElem.getNamespaceURI(), docElem.getTagName(), cloneDocType);
        XMLDecImpl xmlDec = ((DocumentImpl)doc).getXMLDec();
        if (xmlDec != null) {
            docClone.setXMLDec(xmlDec.getVersion(), xmlDec.getEncoding(), xmlDec.getStandalone());
        }
        return docClone;
    }

    protected Element manualCloneElement(Element elem, Document cloneDoc) {
        String namespace = elem.getNamespaceURI();
        if (namespace != null) {
            return cloneDoc.createElementNS(namespace, elem.getTagName());
        }
        return cloneDoc.createElement(elem.getTagName());
    }

    public ItsNatDocumentTemplateImpl getItsNatDocumentTemplate() {
        return (ItsNatDocumentTemplateImpl)this.markupTemplate;
    }

    public DateFormat getDefaultDateFormat() {
        return this.getItsNatDocumentTemplate().getDefaultDateFormat();
    }

    public DateFormat getDefaultDateFormatCloned() {
        DateFormat format = this.getDefaultDateFormat();
        if (format != null) {
            format = (DateFormat)format.clone();
        }
        return format;
    }

    public NumberFormat getDefaultNumberFormat() {
        return this.getItsNatDocumentTemplate().getDefaultNumberFormat();
    }

    public NumberFormat getDefaultNumberFormatCloned() {
        NumberFormat format = this.getDefaultNumberFormat();
        if (format != null) {
            format = (NumberFormat)format.clone();
        }
        return format;
    }

    public long getEventDispatcherMaxWait() {
        return this.getItsNatDocumentTemplate().getEventDispatcherMaxWait();
    }

    public int getMaxOpenClientsByDocument() {
        return this.getItsNatDocumentTemplate().getMaxOpenClientsByDocument();
    }

    public boolean isReferrerEnabled() {
        return this.getItsNatDocumentTemplate().isReferrerEnabled();
    }

    public boolean isEventsEnabled() {
        return this.getItsNatDocumentTemplate().isEventsEnabled();
    }

    public boolean isScriptingEnabled() {
        return this.getItsNatDocumentTemplate().isScriptingEnabled();
    }

    public boolean isAutoCleanEventListeners() {
        return this.getItsNatDocumentTemplate().isAutoCleanEventListeners();
    }

    public boolean isUseXHRSyncOnUnloadEvent() {
        return this.getItsNatDocumentTemplate().isUseXHRSyncOnUnloadEvent();
    }

    public boolean isUsePatternMarkupToRender() {
        return this.getItsNatDocumentTemplate().isUsePatternMarkupToRender();
    }

    public void setUsePatternMarkupToRender(boolean usePatternMarkupToRender) {
        this.getItsNatDocumentTemplate().setUsePatternMarkupToRender(usePatternMarkupToRender);
    }

    public boolean isSelectionOnComponentsUsesKeyboard() {
        return this.getItsNatDocumentTemplate().isSelectionOnComponentsUsesKeyboard();
    }

    public boolean isJoystickMode() {
        return this.getItsNatDocumentTemplate().isJoystickMode();
    }

    public boolean isMarkupDrivenComponents() {
        return this.getItsNatDocumentTemplate().isMarkupDrivenComponents();
    }

    public abstract DocumentFragment parseFragmentToDocFragment(String var1, ItsNatDocumentImpl var2);
}

