/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.template;

import com.innowhere.relproxy.jproxy.JProxyScriptEngine;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.itsnat.comp.CreateItsNatComponentListener;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.event.ItsNatAttachedClientEventListener;
import org.itsnat.core.event.ItsNatServletRequestListener;
import org.itsnat.core.tmpl.ItsNatDocumentTemplate;
import org.itsnat.impl.core.CommModeImpl;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.domutil.NamespaceUtil;
import org.itsnat.impl.core.req.norm.RequestNormalLoadDocImpl;
import org.itsnat.impl.core.servlet.ItsNatServletConfigImpl;
import org.itsnat.impl.core.servlet.ItsNatServletImpl;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;
import org.itsnat.impl.core.servlet.ItsNatServletResponseImpl;
import org.itsnat.impl.core.template.ItsNatDocumentTemplateVersionImpl;
import org.itsnat.impl.core.template.ItsNatStfulDocumentTemplateAttachedServerImpl;
import org.itsnat.impl.core.template.ItsNatStfulDocumentTemplateNormalImpl;
import org.itsnat.impl.core.template.MarkupSourceImpl;
import org.itsnat.impl.core.template.MarkupTemplateImpl;
import org.itsnat.impl.core.template.xml.ItsNatXMLDocumentTemplateImpl;
import org.w3c.dom.events.EventListener;

public abstract class ItsNatDocumentTemplateImpl
extends MarkupTemplateImpl
implements ItsNatDocumentTemplate {
    protected LinkedList<ItsNatServletRequestListener> requestListeners;
    protected LinkedList<ItsNatAttachedClientEventListener> attachedEventListeners;
    protected LinkedList<EventListener> domEventListeners;
    protected LinkedList<CreateItsNatComponentListener> createCompListeners;
    protected Map<String, Object> artifacts;
    protected int commMode;
    protected long eventTimeout;
    protected int useGZip;
    protected boolean autoBuildComponents;
    protected boolean fastLoadMode;
    protected boolean loadScriptInline;
    protected boolean nodeCacheEnabled;
    protected DateFormat dateFormat;
    protected NumberFormat numberFormat;
    protected long evtDispMaxWait;
    protected int maxOpenClients;
    protected boolean referrerEnabled;
    protected boolean referrerPushEnabled;
    protected boolean eventsEnabled;
    protected boolean scriptEnabled;
    protected boolean autoCleanEventListeners;
    protected boolean useXHRSyncOnUnloadEvent;
    protected boolean usePatternMarkupToRender;
    protected boolean selectionOnComponentsUsesKeyboard;
    protected boolean joystickMode;
    protected boolean markupDrivenComponents;
    protected boolean debugMode;
    protected int clientErrorMode;

    public ItsNatDocumentTemplateImpl(String name, String mime, MarkupSourceImpl source, ItsNatServletImpl servlet) {
        super(name, mime, source, servlet);
        ItsNatServletConfigImpl servletConfig = servlet.getItsNatServletConfigImpl();
        this.commMode = servletConfig.getCommMode();
        this.eventTimeout = servletConfig.getEventTimeout();
        this.useGZip = servletConfig.getUseGZip();
        this.fastLoadMode = servletConfig.isFastLoadMode();
        this.loadScriptInline = servletConfig.isLoadScriptInline();
        this.nodeCacheEnabled = servletConfig.isNodeCacheEnabled();
        this.dateFormat = servletConfig.getDefaultDateFormat();
        this.numberFormat = servletConfig.getDefaultNumberFormat();
        this.evtDispMaxWait = servletConfig.getEventDispatcherMaxWait();
        this.maxOpenClients = servletConfig.getMaxOpenClientsByDocument();
        this.autoBuildComponents = servletConfig.isAutoBuildComponents();
        this.referrerEnabled = servletConfig.isReferrerEnabled();
        this.referrerPushEnabled = servletConfig.isReferrerPushEnabled();
        this.eventsEnabled = servletConfig.isEventsEnabled();
        this.scriptEnabled = servletConfig.isScriptingEnabled();
        this.autoCleanEventListeners = servletConfig.isAutoCleanEventListeners();
        this.useXHRSyncOnUnloadEvent = servletConfig.isUseXHRSyncOnUnloadEvent();
        this.usePatternMarkupToRender = servletConfig.isUsePatternMarkupToRender();
        this.selectionOnComponentsUsesKeyboard = servletConfig.isSelectionOnComponentsUsesKeyboard();
        this.joystickMode = servletConfig.isJoystickMode();
        this.markupDrivenComponents = servletConfig.isMarkupDrivenComponents();
        this.debugMode = servletConfig.isDebugMode();
        this.clientErrorMode = servletConfig.getClientErrorMode();
    }

    public static ItsNatDocumentTemplateImpl createItsNatDocumentTemplate(String name, String mime, Object source, ItsNatServletImpl servlet) {
        MarkupSourceImpl markupSource = MarkupSourceImpl.createMarkupSource(source);
        if (NamespaceUtil.isStatefulMime(mime)) {
            return ItsNatStfulDocumentTemplateNormalImpl.createItsNatStfulDocumentTemplateNormal(name, mime, markupSource, servlet);
        }
        return new ItsNatXMLDocumentTemplateImpl(name, mime, markupSource, servlet);
    }

    public static ItsNatStfulDocumentTemplateAttachedServerImpl createItsNatStfulDocumentTemplateAttachedServer(String name, String mime, ItsNatServletImpl servlet) {
        if (NamespaceUtil.isStatefulMime(mime)) {
            return new ItsNatStfulDocumentTemplateAttachedServerImpl(name, mime, servlet);
        }
        throw new ItsNatException("This MIME " + mime + " is not recognized as stateful and stateless is not valid in attached server mode");
    }

    @Override
    public boolean isDocFragment() {
        return false;
    }

    @Override
    public int getCommMode() {
        return this.commMode;
    }

    @Override
    public void setCommMode(int commMode) {
        this.checkIsAlreadyUsed();
        CommModeImpl.checkMode(commMode);
        this.commMode = commMode;
    }

    @Override
    public long getEventTimeout() {
        return this.eventTimeout;
    }

    @Override
    public void setEventTimeout(long timeout) {
        this.checkIsAlreadyUsed();
        this.eventTimeout = timeout;
    }

    @Override
    public int getUseGZip() {
        return this.useGZip;
    }

    @Override
    public void setUseGZip(int value) {
        this.checkIsAlreadyUsed();
        this.useGZip = value;
    }

    @Override
    public boolean isFastLoadMode() {
        return this.fastLoadMode;
    }

    @Override
    public void setFastLoadMode(boolean fastLoadMode) {
        this.checkIsAlreadyUsed();
        this.fastLoadMode = fastLoadMode;
    }

    @Override
    public boolean isLoadScriptInline() {
        return this.loadScriptInline;
    }

    @Override
    public void setLoadScriptInline(boolean value) {
        this.checkIsAlreadyUsed();
        this.loadScriptInline = value;
    }

    @Override
    public boolean isNodeCacheEnabled() {
        return this.nodeCacheEnabled;
    }

    @Override
    public void setNodeCacheEnabled(boolean nodeCacheEnabled) {
        this.checkIsAlreadyUsed();
        this.nodeCacheEnabled = nodeCacheEnabled;
    }

    @Override
    public boolean isAutoBuildComponents() {
        return this.autoBuildComponents;
    }

    @Override
    public void setAutoBuildComponents(boolean autoBuildComponents) {
        this.checkIsAlreadyUsed();
        this.autoBuildComponents = autoBuildComponents;
    }

    @Override
    public DateFormat getDefaultDateFormat() {
        return this.dateFormat;
    }

    @Override
    public void setDefaultDateFormat(DateFormat dateFormat) {
        this.checkIsAlreadyUsed();
        this.dateFormat = dateFormat;
    }

    @Override
    public NumberFormat getDefaultNumberFormat() {
        return this.numberFormat;
    }

    @Override
    public void setDefaultNumberFormat(NumberFormat numberFormat) {
        this.checkIsAlreadyUsed();
        this.numberFormat = numberFormat;
    }

    @Override
    public long getEventDispatcherMaxWait() {
        return this.evtDispMaxWait;
    }

    @Override
    public void setEventDispatcherMaxWait(long wait) {
        this.checkIsAlreadyUsed();
        this.evtDispMaxWait = wait;
    }

    @Override
    public int getMaxOpenClientsByDocument() {
        return this.maxOpenClients;
    }

    @Override
    public void setMaxOpenClientsByDocument(int value) {
        this.checkIsAlreadyUsed();
        ItsNatServletConfigImpl.checkMaxOpenClientsByDocument(value);
        this.maxOpenClients = value;
    }

    @Override
    public boolean isReferrerEnabled() {
        return this.referrerEnabled;
    }

    @Override
    public void setReferrerEnabled(boolean enabled) {
        this.checkIsAlreadyUsed();
        this.referrerEnabled = enabled;
    }

    @Override
    public boolean isReferrerPushEnabled() {
        return this.referrerPushEnabled;
    }

    @Override
    public void setReferrerPushEnabled(boolean referrerPushEnabled) {
        this.checkIsAlreadyUsed();
        this.referrerPushEnabled = referrerPushEnabled;
    }

    @Override
    public boolean isEventsEnabled() {
        return this.eventsEnabled;
    }

    @Override
    public void setEventsEnabled(boolean enabled) {
        this.checkIsAlreadyUsed();
        this.eventsEnabled = enabled;
    }

    @Override
    public boolean isScriptingEnabled() {
        return this.scriptEnabled;
    }

    @Override
    public void setScriptingEnabled(boolean enabled) {
        this.checkIsAlreadyUsed();
        this.scriptEnabled = enabled;
        if (!enabled) {
            this.setEventsEnabled(false);
            this.setFastLoadMode(true);
        }
    }

    @Override
    public boolean isAutoCleanEventListeners() {
        return this.autoCleanEventListeners;
    }

    @Override
    public void setAutoCleanEventListeners(boolean enable) {
        this.checkIsAlreadyUsed();
        this.autoCleanEventListeners = enable;
    }

    @Override
    public boolean isUseXHRSyncOnUnloadEvent() {
        return this.useXHRSyncOnUnloadEvent;
    }

    @Override
    public void setUseXHRSyncOnUnloadEvent(boolean enable) {
        this.checkIsAlreadyUsed();
        this.useXHRSyncOnUnloadEvent = enable;
    }

    public void setAutoCleanEventListenersTESTING(boolean enable) {
        this.autoCleanEventListeners = enable;
    }

    @Override
    public boolean isUsePatternMarkupToRender() {
        return this.usePatternMarkupToRender;
    }

    @Override
    public void setUsePatternMarkupToRender(boolean usePatternMarkupToRender) {
        this.checkIsAlreadyUsed();
        this.usePatternMarkupToRender = usePatternMarkupToRender;
    }

    @Override
    public boolean isSelectionOnComponentsUsesKeyboard() {
        return this.selectionOnComponentsUsesKeyboard;
    }

    @Override
    public void setSelectionOnComponentsUsesKeyboard(boolean value) {
        this.checkIsAlreadyUsed();
        this.selectionOnComponentsUsesKeyboard = value;
    }

    @Override
    public boolean isJoystickMode() {
        return this.joystickMode;
    }

    @Override
    public void setJoystickMode(boolean value) {
        this.checkIsAlreadyUsed();
        this.joystickMode = value;
    }

    @Override
    public boolean isMarkupDrivenComponents() {
        return this.markupDrivenComponents;
    }

    @Override
    public void setMarkupDrivenComponents(boolean value) {
        this.checkIsAlreadyUsed();
        this.markupDrivenComponents = value;
    }

    @Override
    public boolean isDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean debugMode) {
        this.checkIsAlreadyUsed();
        this.debugMode = debugMode;
    }

    @Override
    public int getClientErrorMode() {
        return this.clientErrorMode;
    }

    @Override
    public void setClientErrorMode(int mode) {
        this.checkIsAlreadyUsed();
        this.clientErrorMode = mode;
    }

    public ItsNatDocumentTemplateVersionImpl getNewestItsNatDocumentTemplateVersion(RequestNormalLoadDocImpl request) {
        MarkupSourceImpl source = this.delegate.getMarkupSource(request);
        ItsNatServletRequestImpl itsNatRequest = request.getItsNatServletRequest();
        ItsNatServletResponseImpl itsNatResponse = itsNatRequest.getItsNatServletResponseImpl();
        return (ItsNatDocumentTemplateVersionImpl)this.delegate.getNewestMarkupTemplateVersion(source, itsNatRequest, itsNatResponse);
    }

    public boolean hasItsNatServletRequestListeners() {
        if (this.requestListeners == null) {
            return false;
        }
        return !this.requestListeners.isEmpty();
    }

    public LinkedList<ItsNatServletRequestListener> getItsNatServletRequestListenerList() {
        if (this.requestListeners == null) {
            this.requestListeners = new LinkedList();
        }
        return this.requestListeners;
    }

    public Iterator<ItsNatServletRequestListener> getItsNatServletRequestListenerIterator() {
        if (this.requestListeners == null) {
            return null;
        }
        if (this.requestListeners.isEmpty()) {
            return null;
        }
        return this.requestListeners.iterator();
    }

    @Override
    public void addItsNatServletRequestListener(ItsNatServletRequestListener listener) {
        this.checkIsAlreadyUsed();
        JProxyScriptEngine jProxy = this.servlet.getItsNatImpl().getJProxyScriptEngineIfConfigured();
        if (jProxy != null) {
            listener = (ItsNatServletRequestListener)jProxy.create((Object)listener, ItsNatServletRequestListener.class);
        }
        LinkedList<ItsNatServletRequestListener> requestListeners = this.getItsNatServletRequestListenerList();
        requestListeners.add(listener);
    }

    @Override
    public void removeItsNatServletRequestListener(ItsNatServletRequestListener listener) {
        this.checkIsAlreadyUsed();
        JProxyScriptEngine jProxy = this.servlet.getItsNatImpl().getJProxyScriptEngineIfConfigured();
        if (jProxy != null) {
            listener = (ItsNatServletRequestListener)jProxy.create((Object)listener, ItsNatServletRequestListener.class);
        }
        LinkedList<ItsNatServletRequestListener> requestListeners = this.getItsNatServletRequestListenerList();
        requestListeners.remove(listener);
    }

    public LinkedList<ItsNatAttachedClientEventListener> getItsNatAttachedClientEventListenerList() {
        if (this.attachedEventListeners == null) {
            this.attachedEventListeners = new LinkedList();
        }
        return this.attachedEventListeners;
    }

    public void getItsNatAttachedClientEventListenerList(LinkedList<ItsNatAttachedClientEventListener> list) {
        if (this.attachedEventListeners == null) {
            return;
        }
        list.addAll(this.attachedEventListeners);
    }

    @Override
    public void addItsNatAttachedClientEventListener(ItsNatAttachedClientEventListener listener) {
        this.checkIsAlreadyUsed();
        JProxyScriptEngine jProxy = this.servlet.getItsNatImpl().getJProxyScriptEngineIfConfigured();
        if (jProxy != null) {
            listener = (ItsNatAttachedClientEventListener)jProxy.create((Object)listener, ItsNatAttachedClientEventListener.class);
        }
        LinkedList<ItsNatAttachedClientEventListener> attachedEventListeners = this.getItsNatAttachedClientEventListenerList();
        attachedEventListeners.add(listener);
    }

    @Override
    public void removeItsNatAttachedClientEventListener(ItsNatAttachedClientEventListener listener) {
        this.checkIsAlreadyUsed();
        JProxyScriptEngine jProxy = this.servlet.getItsNatImpl().getJProxyScriptEngineIfConfigured();
        if (jProxy != null) {
            listener = (ItsNatAttachedClientEventListener)jProxy.create((Object)listener, ItsNatAttachedClientEventListener.class);
        }
        LinkedList<ItsNatAttachedClientEventListener> attachedEventListeners = this.getItsNatAttachedClientEventListenerList();
        attachedEventListeners.remove(listener);
    }

    public boolean hasGlobalEventListenerListeners() {
        if (this.domEventListeners == null) {
            return false;
        }
        return !this.domEventListeners.isEmpty();
    }

    public LinkedList<EventListener> getGlobalEventListenerList() {
        if (this.domEventListeners == null) {
            this.domEventListeners = new LinkedList();
        }
        return this.domEventListeners;
    }

    public void getGlobalEventListenerList(LinkedList<EventListener> list) {
        if (this.domEventListeners == null) {
            return;
        }
        list.addAll(this.domEventListeners);
    }

    @Override
    public void addEventListener(EventListener listener) {
        this.checkIsAlreadyUsed();
        LinkedList<EventListener> domEventListeners = this.getGlobalEventListenerList();
        domEventListeners.add(listener);
    }

    @Override
    public void removeEventListener(EventListener listener) {
        this.checkIsAlreadyUsed();
        LinkedList<EventListener> domEventListeners = this.getGlobalEventListenerList();
        domEventListeners.remove(listener);
    }

    public boolean hasCreateItsNatComponentList() {
        if (this.createCompListeners == null) {
            return false;
        }
        return !this.createCompListeners.isEmpty();
    }

    public LinkedList<CreateItsNatComponentListener> getCreateItsNatComponentList() {
        if (this.createCompListeners == null) {
            this.createCompListeners = new LinkedList();
        }
        return this.createCompListeners;
    }

    public Iterator<CreateItsNatComponentListener> getCreateItsNatComponentListenerIterator() {
        if (!this.hasCreateItsNatComponentList()) {
            return null;
        }
        return this.createCompListeners.iterator();
    }

    @Override
    public void addCreateItsNatComponentListener(CreateItsNatComponentListener listener) {
        this.checkIsAlreadyUsed();
        LinkedList<CreateItsNatComponentListener> list = this.getCreateItsNatComponentList();
        list.add(listener);
    }

    @Override
    public void removeCreateItsNatComponentListener(CreateItsNatComponentListener listener) {
        this.checkIsAlreadyUsed();
        LinkedList<CreateItsNatComponentListener> list = this.getCreateItsNatComponentList();
        list.remove(listener);
    }

    public boolean hasArtifacts() {
        if (this.artifacts == null) {
            return false;
        }
        return !this.artifacts.isEmpty();
    }

    public Map<String, Object> getArtifactMap() {
        if (this.artifacts == null) {
            this.artifacts = new HashMap<String, Object>();
        }
        return this.artifacts;
    }

    @Override
    public Object getArtifact(String name) {
        if (!this.hasArtifacts()) {
            return null;
        }
        Map<String, Object> artifacts = this.getArtifactMap();
        return artifacts.get(name);
    }

    @Override
    public void registerArtifact(String name, Object value) {
        this.checkIsAlreadyUsed();
        Map<String, Object> artifacts = this.getArtifactMap();
        artifacts.put(name, value);
    }

    @Override
    public Object removeArtifact(String name) {
        this.checkIsAlreadyUsed();
        Map<String, Object> artifacts = this.getArtifactMap();
        return artifacts.remove(name);
    }

    @Override
    public Object getArtifact(String name, boolean cascade) {
        Object artif = this.getArtifact(name);
        if (cascade && artif == null) {
            artif = this.getItsNatServletImpl().getItsNatServletConfigImpl().getArtifact(name);
        }
        return artif;
    }

    public ItsNatDocumentImpl loadItsNatDocument(RequestNormalLoadDocImpl request) {
        ItsNatDocumentTemplateVersionImpl loader = this.getNewestItsNatDocumentTemplateVersion(request);
        return loader.loadItsNatDocument(request);
    }

    public boolean canVersionBeSharedBetweenDocs() {
        return this.delegate.canVersionBeSharedBetweenDocs();
    }
}

