/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.template;

import java.io.Serializable;
import java.util.LinkedList;
import org.itsnat.impl.core.template.CachedSubtreeImpl;
import org.itsnat.impl.core.template.MarkupTemplateVersionImpl;

public class CachedTextNodeImpl
extends CachedSubtreeImpl {
    protected LinkedList<PairPosChar> entities = new LinkedList();

    public CachedTextNodeImpl(MarkupTemplateVersionImpl template, String markup, String dom) {
        super(template, markup);
        int posMarkup = 0;
        int posDOM = 0;
        while (posMarkup < markup.length()) {
            if (CachedTextNodeImpl.isEntityStart(markup, dom, posMarkup, posDOM)) {
                char cDOM = dom.charAt(posDOM);
                int end = markup.indexOf(";", posMarkup + 1);
                if (this.entities == null) {
                    this.entities = new LinkedList();
                }
                this.entities.add(new PairPosChar(posMarkup, end, cDOM));
                posMarkup = end + 1;
            } else {
                ++posMarkup;
            }
            ++posDOM;
        }
    }

    protected static boolean isEntityStart(String markup, String dom, int posMarkup, int posDOM) {
        if (markup.charAt(posMarkup) != '&') {
            return false;
        }
        if (dom.charAt(posDOM) != '&') {
            return true;
        }
        if (markup.length() - posMarkup < "&amp;".length()) {
            return false;
        }
        int posSemicolon = markup.indexOf(59, posMarkup + 1);
        if (posSemicolon == -1) {
            return false;
        }
        return "&amp;".equals(markup.substring(posMarkup, posSemicolon + 1));
    }

    @Override
    public String getCode(boolean resolveEntities) {
        if (resolveEntities && this.entities != null) {
            StringBuilder dom = new StringBuilder();
            int prevPosMarkup = 0;
            for (PairPosChar entity : this.entities) {
                int posMarkup = entity.start;
                if (prevPosMarkup < posMarkup) {
                    dom.append(this.markup.substring(prevPosMarkup, posMarkup));
                }
                dom.append(entity.c);
                prevPosMarkup = posMarkup = entity.end + 1;
            }
            if (prevPosMarkup < this.markup.length()) {
                dom.append(this.markup.substring(prevPosMarkup));
            }
            return dom.toString();
        }
        return this.markup;
    }

    public static class PairPosChar
    implements Serializable {
        public int start;
        public int end;
        public char c;

        public PairPosChar(int start, int end, char c) {
            this.start = start;
            this.end = end;
            this.c = c;
        }
    }
}

