/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.template;

import java.io.Serializable;
import org.itsnat.impl.core.template.MarkupTemplateVersionImpl;
import org.itsnat.impl.core.util.HasUniqueId;
import org.itsnat.impl.core.util.UniqueId;

public abstract class CachedSubtreeImpl
implements HasUniqueId,
Serializable {
    protected MarkupTemplateVersionImpl template;
    protected UniqueId idObj;
    protected String markup;
    protected String markCode;

    public CachedSubtreeImpl(MarkupTemplateVersionImpl template, String markup) {
        this.template = template;
        this.idObj = template.getUniqueIdGenerator().generateUniqueId("cs");
        this.markup = markup;
        this.markCode = CachedSubtreeImpl.getMarkCodeStart() + "," + template.getId() + "," + this.idObj.getId() + "}";
    }

    @Override
    public String getId() {
        return this.idObj.getId();
    }

    @Override
    public UniqueId getUniqueId() {
        return this.idObj;
    }

    public abstract String getCode(boolean var1);

    public static String getMarkCodeStart() {
        return "${itsnat_cached_node";
    }

    public static String getTemplateId(String mark) {
        int start = CachedSubtreeImpl.getMarkCodeStart().length() + 1;
        int last = mark.lastIndexOf(44);
        return mark.substring(start, last);
    }

    public static String getNodeId(String mark) {
        int start = mark.lastIndexOf(44) + 1;
        return mark.substring(start, mark.length() - 1);
    }

    public String getMarkCode() {
        return this.markCode;
    }
}

