/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.servlet.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.ItsNatServletResponse;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.servlet.DeserialPendingTask;
import org.itsnat.impl.core.servlet.ItsNatServletContextImpl;
import org.itsnat.impl.core.servlet.ItsNatServletImpl;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;
import org.itsnat.impl.core.servlet.ItsNatServletResponseImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionSerializeContainerImpl;
import org.itsnat.impl.core.servlet.http.ItsNatHttpServletRequestImpl;
import org.itsnat.impl.core.servlet.http.ItsNatHttpSessionImpl;
import org.itsnat.impl.core.util.MapListImpl;

public class ItsNatHttpSessionReplicationCapableImpl
extends ItsNatHttpSessionImpl {
    public static final String SESSION_ATTRIBUTE_NAME = "itsnat_session";
    public static final String SESSION_ATTRIBUTE_NAME_FRAGMENT_COUNT = "itsnat_session_fragment_count";
    public static final String SESSION_ATTRIBUTE_NAME_FRAGMENT_NUM = "itsnat_session_fragment_";

    protected ItsNatHttpSessionReplicationCapableImpl(HttpSession session, ItsNatServletContextImpl context, Browser browser) {
        super(session, context, browser);
        this.serialContainer = new ItsNatSessionSerializeContainerImpl(this);
        this.writeItsNatHttpSessionToAttribute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeItsNatHttpSessionToAttribute() {
        try {
            HttpSession httpSession = this.session;
            synchronized (httpSession) {
                if (this.context.isSessionExplicitSerialize()) {
                    long size = this.context.getSessionExplicitSerializeFragmentSize();
                    byte[] stream = ItsNatHttpSessionReplicationCapableImpl.serializeSession(this.serialContainer);
                    if (size == 0L) {
                        this.session.setAttribute(SESSION_ATTRIBUTE_NAME, (Object)stream);
                    } else {
                        Integer numFragObjOld;
                        int sizeInt = (int)size;
                        int numFrag = stream.length / sizeInt;
                        int modulo = stream.length % sizeInt;
                        if (modulo != 0) {
                            ++numFrag;
                        }
                        if ((numFragObjOld = (Integer)this.session.getAttribute(SESSION_ATTRIBUTE_NAME_FRAGMENT_COUNT)) != null) {
                            int numFragOld = numFragObjOld;
                            for (int i = numFrag; i < numFragOld; ++i) {
                                this.session.removeAttribute(SESSION_ATTRIBUTE_NAME_FRAGMENT_NUM + i);
                            }
                        }
                        this.session.setAttribute(SESSION_ATTRIBUTE_NAME_FRAGMENT_COUNT, (Object)new Integer(numFrag));
                        for (int i = 0; i < numFrag; ++i) {
                            int sizeFrag = i != numFrag - 1 ? sizeInt : modulo;
                            byte[] fragment = new byte[sizeFrag];
                            System.arraycopy(stream, i * sizeInt, fragment, 0, sizeFrag);
                            this.session.setAttribute(SESSION_ATTRIBUTE_NAME_FRAGMENT_NUM + i, (Object)fragment);
                        }
                    }
                } else {
                    this.session.setAttribute(SESSION_ATTRIBUTE_NAME, (Object)this.serialContainer);
                }
            }
        }
        catch (Exception ex) {
            ItsNatSessionSerializeContainerImpl.showError(ex, true);
        }
    }

    @Override
    public void endOfRequestBeforeSendCode() {
    }

    @Override
    public void endOfRequest() {
        this.writeItsNatHttpSessionToAttribute();
    }

    protected static ItsNatSessionSerializeContainerImpl readItsNatSessionSerializeContainerFromSessionAttribute(HttpSession session, ItsNatServletContextImpl context) {
        try {
            if (context.isSessionExplicitSerialize()) {
                byte[] stream;
                long size = context.getSessionExplicitSerializeFragmentSize();
                if (size == 0L) {
                    stream = (byte[])session.getAttribute(SESSION_ATTRIBUTE_NAME);
                    if (stream == null) {
                        return null;
                    }
                } else {
                    Integer numFragObj = (Integer)session.getAttribute(SESSION_ATTRIBUTE_NAME_FRAGMENT_COUNT);
                    if (numFragObj == null) {
                        return null;
                    }
                    int numFrag = numFragObj;
                    ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
                    for (int i = 0; i < numFrag; ++i) {
                        byte[] fragment = (byte[])session.getAttribute(SESSION_ATTRIBUTE_NAME_FRAGMENT_NUM + i);
                        byteArray.write(fragment);
                    }
                    stream = byteArray.toByteArray();
                }
                return ItsNatHttpSessionReplicationCapableImpl.deserializeSession(stream);
            }
            return (ItsNatSessionSerializeContainerImpl)session.getAttribute(SESSION_ATTRIBUTE_NAME);
        }
        catch (Exception ex) {
            ItsNatSessionSerializeContainerImpl.showError(ex, false);
            return null;
        }
    }

    protected static ItsNatHttpSessionImpl readItsNatHttpSessionFromAttribute(HttpSession session, ItsNatServletContextImpl itsNatContext, ItsNatHttpServletRequestImpl itsNatRequest) {
        try {
            ItsNatSessionSerializeContainerImpl serialContainer = ItsNatHttpSessionReplicationCapableImpl.readItsNatSessionSerializeContainerFromSessionAttribute(session, itsNatContext);
            if (serialContainer == null) {
                return null;
            }
            ItsNatHttpSessionReplicationCapableImpl itsNatSession = (ItsNatHttpSessionReplicationCapableImpl)serialContainer.getItsNatSession();
            if (itsNatSession == null) {
                return null;
            }
            if (itsNatSession.session == null) {
                itsNatSession.session = session;
                itsNatSession.executeDeserialPendingTasks(itsNatContext, itsNatRequest);
                itsNatContext.addItsNatSession(itsNatSession);
            }
            return itsNatSession;
        }
        catch (Exception ex) {
            ItsNatSessionSerializeContainerImpl.showError(ex, false);
            return null;
        }
    }

    protected void executeDeserialPendingTasks(ItsNatServletContextImpl itsNatContext, ItsNatServletRequestImpl itsNatRequest) throws Exception {
        ItsNatServletImpl itsNatServlet;
        DeserialPendingTask sessionTask = this.getSessionDeserialPendingTask();
        if (sessionTask != null) {
            itsNatServlet = itsNatRequest.getItsNatServletImpl();
            ItsNatServletResponse itsNatResponse = itsNatRequest.getItsNatServletResponse();
            sessionTask.process(itsNatServlet, itsNatRequest, itsNatResponse);
            this.setSessionDeserialPendingTask(null);
        }
        if (this.hasDeserialPendingTasks()) {
            itsNatServlet = itsNatRequest.getItsNatServletImpl();
            String servletName = itsNatServlet.getName();
            ItsNatServletResponse itsNatResponse = itsNatRequest.getItsNatServletResponse();
            ServletContext context = itsNatContext.getServletContext();
            MapListImpl<String, DeserialPendingTask> pendingTasks = this.getDeserialPendingTasks();
            for (Map.Entry<String, LinkedList<DeserialPendingTask>> entry : pendingTasks.getMap().entrySet()) {
                String currServletName = entry.getKey();
                LinkedList<DeserialPendingTask> pendingTasksOfServlet = entry.getValue();
                if (pendingTasksOfServlet == null) continue;
                if (servletName.equals(currServletName)) {
                    for (DeserialPendingTask task : pendingTasksOfServlet) {
                        task.process(itsNatServlet, itsNatRequest, itsNatResponse);
                    }
                    continue;
                }
                ItsNatServletImpl currItsNatServlet = ItsNatServletImpl.getItsNatServletByName(currServletName);
                ServletRequest servRequest = itsNatRequest.getServletRequest();
                ServletResponse servResponse = itsNatResponse.getServletResponse();
                if (currItsNatServlet == null) {
                    RequestDispatcher servletDisp = context.getNamedDispatcher(currServletName);
                    Object currItsNatAction = servRequest.getAttribute("itsnat_action");
                    servRequest.setAttribute("itsnat_action", (Object)"servlet_weak_up");
                    servletDisp.include(servRequest, servResponse);
                    servRequest.removeAttribute("itsnat_action");
                    if (currItsNatAction != null) {
                        servRequest.setAttribute("itsnat_action", currItsNatAction);
                    }
                    currItsNatServlet = ItsNatServletImpl.getItsNatServletByName(currServletName);
                }
                ItsNatServletRequestImpl currItsNatServReq = currItsNatServlet.createItsNatServletRequest(servRequest, servResponse, this);
                ItsNatServletResponseImpl currItsNatServResp = currItsNatServReq.getItsNatServletResponseImpl();
                for (DeserialPendingTask task : pendingTasksOfServlet) {
                    task.process(currItsNatServlet, currItsNatServReq, currItsNatServResp);
                }
            }
            this.clearDeserialPendingTasks();
        }
    }

    public static byte[] serializeSession(ItsNatSessionSerializeContainerImpl serialContainer) {
        ByteArrayOutputStream ostream = null;
        try {
            ostream = new ByteArrayOutputStream();
            ObjectOutputStream p = new ObjectOutputStream(ostream);
            p.writeObject(serialContainer);
            p.flush();
            ostream.close();
        }
        catch (Exception ex) {
            try {
                if (ostream != null) {
                    ostream.close();
                }
            }
            catch (IOException ex2) {
                ex.printStackTrace();
                throw new ItsNatException(ex2);
            }
            throw new ItsNatException(ex);
        }
        return ostream.toByteArray();
    }

    public static ItsNatSessionSerializeContainerImpl deserializeSession(byte[] stream) {
        ItsNatSessionSerializeContainerImpl serialContainer;
        ByteArrayInputStream istream = null;
        try {
            istream = new ByteArrayInputStream(stream);
            ObjectInputStream q = new ObjectInputStream(istream);
            serialContainer = (ItsNatSessionSerializeContainerImpl)q.readObject();
            istream.close();
        }
        catch (Exception ex) {
            try {
                if (istream != null) {
                    istream.close();
                }
            }
            catch (IOException ex2) {
                ex.printStackTrace();
                throw new ItsNatException(ex2);
            }
            throw new ItsNatException(ex);
        }
        return serialContainer;
    }
}

