/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.servlet.http;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.http.ItsNatHttpSession;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.servlet.ItsNatServletContextImpl;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionImpl;
import org.itsnat.impl.core.servlet.http.ItsNatHttpServletRequestImpl;
import org.itsnat.impl.core.servlet.http.ItsNatHttpSessionCleanListenerImpl;
import org.itsnat.impl.core.servlet.http.ItsNatHttpSessionReplicationCapableImpl;
import org.itsnat.impl.core.servlet.http.ItsNatHttpSessionStickyImpl;

public abstract class ItsNatHttpSessionImpl
extends ItsNatSessionImpl
implements ItsNatHttpSession {
    public static final String SESSION_CLEAN_ATTRIBUTE_NAME = "itsnat_session_clean";
    protected transient HttpSession session;

    protected ItsNatHttpSessionImpl(HttpSession session, ItsNatServletContextImpl context, Browser browser) {
        super(context, browser);
        this.session = session;
        this.idObj = context.getUniqueIdGenerator().generateUniqueId(session, "ss");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ItsNatHttpSessionImpl getItsNatHttpSession(ItsNatHttpServletRequestImpl itsNatRequest) {
        ItsNatHttpSessionImpl itsNatSession;
        ItsNatServletContextImpl context = itsNatRequest.getItsNatServletContext();
        HttpServletRequest request = itsNatRequest.getHttpServletRequest();
        HttpSession session = request.getSession();
        if (session == null) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        boolean useAttribute = context.isSessionReplicationCapable();
        HttpSession httpSession = session;
        synchronized (httpSession) {
            itsNatSession = useAttribute ? ItsNatHttpSessionReplicationCapableImpl.readItsNatHttpSessionFromAttribute(session, context, itsNatRequest) : ItsNatHttpSessionStickyImpl.getItsNatHttpSessionStickyByStandardId(session, context);
            if (itsNatSession == null) {
                itsNatSession = ItsNatHttpSessionImpl.createItsNatHttpSession(session, context, itsNatRequest);
                context.addItsNatSession(itsNatSession);
                if (session.getAttribute(SESSION_CLEAN_ATTRIBUTE_NAME) == null) {
                    session.setAttribute(SESSION_CLEAN_ATTRIBUTE_NAME, (Object)new ItsNatHttpSessionCleanListenerImpl());
                }
            }
        }
        return itsNatSession;
    }

    protected static ItsNatHttpSessionImpl createItsNatHttpSession(HttpSession session, ItsNatServletContextImpl context, ItsNatServletRequestImpl itsNatRequest) {
        Browser browser = Browser.createBrowser(itsNatRequest);
        if (context.isSessionReplicationCapable()) {
            return new ItsNatHttpSessionReplicationCapableImpl(session, context, browser);
        }
        return new ItsNatHttpSessionStickyImpl(session, context, browser);
    }

    @Override
    public HttpSession getHttpSession() {
        return this.session;
    }

    @Override
    public Object getStandardSessionObject() {
        return this.session;
    }

    @Override
    public String getStandardSessionId() {
        return this.session.getId();
    }

    @Override
    public Object getAttribute(String name) {
        return this.session.getAttribute(name);
    }

    @Override
    public Enumeration getAttributeNames() {
        return this.session.getAttributeNames();
    }

    @Override
    public void removeAttribute(String name) {
        this.session.removeAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.session.setAttribute(name, value);
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }
}

