/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.servlet.http;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.itsnat.core.http.ItsNatHttpServlet;
import org.itsnat.core.http.ItsNatHttpServletResponse;
import org.itsnat.core.http.ItsNatHttpSession;
import org.itsnat.impl.core.servlet.ItsNatServletResponseImpl;
import org.itsnat.impl.core.servlet.ServletResponseAttachedServer;
import org.itsnat.impl.core.servlet.http.HttpServletResponseAttachedServerImpl;
import org.itsnat.impl.core.servlet.http.ItsNatHttpServletImpl;
import org.itsnat.impl.core.servlet.http.ItsNatHttpServletRequestImpl;
import org.itsnat.impl.core.servlet.http.ItsNatHttpSessionImpl;

public class ItsNatHttpServletResponseImpl
extends ItsNatServletResponseImpl
implements ItsNatHttpServletResponse {
    public ItsNatHttpServletResponseImpl(ItsNatHttpServletRequestImpl request, HttpServletResponse response) {
        super(request, (ServletResponse)response);
    }

    public ItsNatHttpServletImpl getItsNatHttpServletImpl() {
        return (ItsNatHttpServletImpl)this.getItsNatServletImpl();
    }

    public ItsNatHttpServletRequestImpl getItsNatHttpServletRequestImpl() {
        return (ItsNatHttpServletRequestImpl)this.request;
    }

    @Override
    public HttpServletResponse getHttpServletResponse() {
        return (HttpServletResponse)this.response;
    }

    @Override
    public ItsNatHttpServlet getItsNatHttpServlet() {
        return this.getItsNatHttpServletRequestImpl().getItsNatHttpServletImpl();
    }

    @Override
    public ItsNatHttpSession getItsNatHttpSession() {
        return this.getItsNatHttpSessionImpl();
    }

    public ItsNatHttpSessionImpl getItsNatHttpSessionImpl() {
        return this.getItsNatHttpServletRequestImpl().getItsNatHttpSessionImpl();
    }

    @Override
    public void prepareResponse() {
        HttpServletResponse response = this.getHttpServletResponse();
        response.addHeader("Cache-Control", "no-store,no-cache,must-revalidate");
        response.addHeader("Pragma", "no-cache");
        response.addDateHeader("Expires", 0L);
        response.addHeader("ItsNat-version", this.getItsNatHttpServletImpl().getItsNatImpl().getVersion());
    }

    @Override
    public ServletResponseAttachedServer createServletResponseAttachedServer() {
        return new HttpServletResponseAttachedServerImpl(this.getHttpServletResponse());
    }

    @Override
    public Writer getWriterGZip() throws IOException {
        GZIPOutputStream out = null;
        ItsNatHttpServletRequestImpl itsNatRequest = this.getItsNatHttpServletRequestImpl();
        HttpServletResponse response = this.getHttpServletResponse();
        if (!(response instanceof HttpServletResponseAttachedServerImpl)) {
            HttpServletRequest request = itsNatRequest.getHttpServletRequest();
            String acceptEncoding = request.getHeader("Accept-Encoding");
            if (acceptEncoding != null && acceptEncoding.contains("gzip")) {
                response.addHeader("Content-Encoding", "gzip");
                out = new GZIPOutputStream((OutputStream)response.getOutputStream());
            }
            if (out != null) {
                String encoding = response.getCharacterEncoding();
                return new BufferedWriter(new OutputStreamWriter(out, encoding));
            }
        }
        return super.getWriter();
    }

    @Override
    public String encodeURL(String url) {
        HttpServletResponse response = this.getHttpServletResponse();
        return response.encodeURL(url);
    }
}

