/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.servlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.servlet.ItsNatServletContextImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionObjectInputStream;
import org.itsnat.impl.core.servlet.ItsNatSessionObjectOutputStream;

public class ItsNatSessionSerializeContainerImpl
implements Serializable {
    public static final long serialVersionUID = 1L;
    protected transient ItsNatSessionImpl itsNatSession;

    public ItsNatSessionSerializeContainerImpl(ItsNatSessionImpl itsNatSession) {
        this.itsNatSession = itsNatSession;
    }

    public ItsNatSessionImpl getItsNatSession() {
        return this.itsNatSession;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            byte[] stream = ItsNatSessionSerializeContainerImpl.serializeSession(this.itsNatSession);
            ItsNatServletContextImpl itsNatCtx = this.itsNatSession.getItsNatServletContextImpl();
            boolean compressed = itsNatCtx.isSessionSerializeCompressed();
            if (compressed) {
                stream = ItsNatSessionSerializeContainerImpl.compressByteArray(stream);
            }
            out.writeBoolean(compressed);
            out.writeInt(stream.length);
            out.write(stream);
        }
        catch (Exception ex) {
            ItsNatSessionSerializeContainerImpl.showError(ex, true);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.itsNatSession = null;
        try {
            boolean compressed = in.readBoolean();
            int total = in.readInt();
            byte[] stream = new byte[total];
            in.readFully(stream);
            if (compressed) {
                stream = ItsNatSessionSerializeContainerImpl.decompressByteArray(stream);
            }
            this.itsNatSession = ItsNatSessionSerializeContainerImpl.deserializeSession(stream);
            this.itsNatSession.setItsNatSessionSerializeContainer(this);
        }
        catch (Exception ex) {
            this.itsNatSession = null;
            ItsNatSessionSerializeContainerImpl.showError(ex, false);
        }
    }

    public static void showError(Exception ex, boolean write) {
        if (write) {
            System.err.println("Something was wrong serializing");
        } else {
            System.err.println("Something was wrong de-serializing, stored session was discarded");
        }
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        System.err.println(sw.toString());
    }

    public static byte[] serializeSession(ItsNatSessionImpl itsNatSession) {
        ByteArrayOutputStream ostream = null;
        try {
            ostream = new ByteArrayOutputStream();
            ItsNatSessionObjectOutputStream p = new ItsNatSessionObjectOutputStream(ostream);
            p.writeObject(itsNatSession);
            p.flush();
            ostream.close();
        }
        catch (Exception ex) {
            try {
                if (ostream != null) {
                    ostream.close();
                }
            }
            catch (IOException ex2) {
                ex.printStackTrace();
                throw new ItsNatException(ex2);
            }
            throw new ItsNatException(ex);
        }
        return ostream.toByteArray();
    }

    public static ItsNatSessionImpl deserializeSession(byte[] stream) {
        ItsNatSessionImpl itsNatSession;
        ByteArrayInputStream istream = null;
        try {
            istream = new ByteArrayInputStream(stream);
            ItsNatSessionObjectInputStream q = new ItsNatSessionObjectInputStream(istream);
            itsNatSession = (ItsNatSessionImpl)q.readObject();
            istream.close();
        }
        catch (Exception ex) {
            try {
                if (istream != null) {
                    istream.close();
                }
            }
            catch (IOException ex2) {
                ex.printStackTrace();
                throw new ItsNatException(ex2);
            }
            throw new ItsNatException(ex);
        }
        return itsNatSession;
    }

    protected static byte[] compressByteArray(byte[] stream) {
        ByteArrayOutputStream inByteArray = new ByteArrayOutputStream();
        GZIPOutputStream output = null;
        try {
            output = new GZIPOutputStream(inByteArray);
            output.write(stream);
        }
        catch (IOException ex) {
            throw new ItsNatException(ex);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException ex) {
                    throw new ItsNatException(ex);
                }
            }
        }
        stream = inByteArray.toByteArray();
        return stream;
    }

    protected static byte[] decompressByteArray(byte[] stream) {
        ByteArrayOutputStream outByteArray = new ByteArrayOutputStream();
        GZIPInputStream input = null;
        try {
            int readed;
            input = new GZIPInputStream(new ByteArrayInputStream(stream));
            byte[] buffer = new byte[stream.length];
            while ((readed = input.read(buffer)) != -1) {
                outByteArray.write(buffer, 0, readed);
            }
        }
        catch (IOException ex) {
            throw new ItsNatException(ex);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    throw new ItsNatException(ex);
                }
            }
        }
        stream = outByteArray.toByteArray();
        return stream;
    }
}

