/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.servlet;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.itsnat.core.ItsNatDocument;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.ItsNatServletContext;
import org.itsnat.core.ItsNatServletRequest;
import org.itsnat.core.ItsNatServletResponse;
import org.itsnat.core.ItsNatSession;
import org.itsnat.core.ItsNatVariableResolver;
import org.itsnat.impl.core.ItsNatUserDataImpl;
import org.itsnat.impl.core.ItsNatVariableResolverImpl;
import org.itsnat.impl.core.Referrer;
import org.itsnat.impl.core.ReferrerStrong;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.clientdoc.ClientDocumentAttachedClientImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentAttachedServerImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulOwnerImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.servlet.DeserialPendingTask;
import org.itsnat.impl.core.servlet.ItsNatServletContextImpl;
import org.itsnat.impl.core.servlet.ItsNatServletImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionObjectInputStream;
import org.itsnat.impl.core.servlet.ItsNatSessionObjectOutputStream;
import org.itsnat.impl.core.servlet.ItsNatSessionSerializeContainerImpl;
import org.itsnat.impl.core.servlet.LastRequestComparator;
import org.itsnat.impl.core.util.HasUniqueId;
import org.itsnat.impl.core.util.MapListImpl;
import org.itsnat.impl.core.util.MapUniqueId;
import org.itsnat.impl.core.util.UniqueId;
import org.itsnat.impl.core.util.UniqueIdGenIntList;

public abstract class ItsNatSessionImpl
extends ItsNatUserDataImpl
implements ItsNatSession,
HasUniqueId {
    public static final Comparator<ClientDocumentStfulOwnerImpl> COMPARATOR_STFUL_OWNER = new LastRequestComparator<ClientDocumentStfulOwnerImpl>();
    public static final Comparator<ClientDocumentAttachedClientImpl> COMPARATOR_ATTACHED_CLIENTS = new LastRequestComparator<ClientDocumentAttachedClientImpl>();
    public static final Comparator<ClientDocumentAttachedServerImpl> COMPARATOR_ATTACHED_SERVERS = new LastRequestComparator<ClientDocumentAttachedServerImpl>();
    protected transient ItsNatSessionSerializeContainerImpl serialContainer;
    protected transient ItsNatServletContextImpl context;
    protected transient UniqueId idObj;
    protected final UniqueIdGenIntList idGenerator = new UniqueIdGenIntList(true);
    protected final MapUniqueId<ItsNatStfulDocumentImpl> docsById = new MapUniqueId(this.idGenerator);
    protected final MapUniqueId<ClientDocumentStfulOwnerImpl> ownerClientsById = new MapUniqueId(this.idGenerator);
    protected final MapUniqueId<ClientDocumentAttachedClientImpl> attachedClientsById = new MapUniqueId(this.idGenerator);
    protected final MapUniqueId<ClientDocumentAttachedServerImpl> attachedServersById = new MapUniqueId(this.idGenerator);
    protected Browser browser;
    protected Referrer referrer;
    protected String token;
    protected transient DeserialPendingTask sessionDeserialPendingTask;
    protected transient MapListImpl<String, DeserialPendingTask> deserialPending;

    public ItsNatSessionImpl(ItsNatServletContextImpl context, Browser browser) {
        super(true);
        this.context = context;
        this.browser = browser;
        this.referrer = Referrer.createReferrer(browser);
        this.token = System.currentTimeMillis() + "_" + context.getNewToken();
    }

    public void setItsNatSessionSerializeContainer(ItsNatSessionSerializeContainerImpl serialContainer) {
        this.serialContainer = serialContainer;
    }

    public DeserialPendingTask getSessionDeserialPendingTask() {
        return this.sessionDeserialPendingTask;
    }

    public void setSessionDeserialPendingTask(DeserialPendingTask task) {
        this.sessionDeserialPendingTask = task;
    }

    public boolean hasDeserialPendingTasks() {
        if (this.deserialPending == null) {
            return false;
        }
        return !this.deserialPending.isEmpty();
    }

    public MapListImpl<String, DeserialPendingTask> getDeserialPendingTasks() {
        if (this.deserialPending == null) {
            this.deserialPending = new MapListImpl();
        }
        return this.deserialPending;
    }

    public void addDeserialPendingTask(String servletName, DeserialPendingTask task) {
        this.getDeserialPendingTasks().add(servletName, task);
    }

    public void clearDeserialPendingTasks() {
        if (this.deserialPending == null) {
            return;
        }
        this.deserialPending.clear();
        this.deserialPending = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ItsNatSessionObjectOutputStream.castToItsNatSessionObjectOutputStream(out);
        out.writeObject(this.idObj.getId());
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ItsNatSessionObjectInputStream.setItsNatSession(in, this);
        final String id = (String)in.readObject();
        DeserialPendingTask task = new DeserialPendingTask(){

            @Override
            public void process(ItsNatServletImpl itsNatServlet, ItsNatServletRequest request, ItsNatServletResponse response) {
                ItsNatSessionImpl.this.context = itsNatServlet.getItsNatServletContextImpl();
                ItsNatSessionImpl.this.idObj = new UniqueId(id, ItsNatSessionImpl.this.context.getUniqueIdGenerator());
            }
        };
        this.setSessionDeserialPendingTask(task);
        in.defaultReadObject();
    }

    public abstract void endOfRequestBeforeSendCode();

    public abstract void endOfRequest();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ItsNatServletContextImpl context = this.getItsNatServletContextImpl();
        context.removeItsNatSession(this);
        ClientDocumentStfulOwnerImpl[] clients = this.getClientDocumentStfulOwnerArray();
        if (clients != null) {
            for (int i = 0; i < clients.length; ++i) {
                ItsNatStfulDocumentImpl itsNatDoc;
                ClientDocumentStfulOwnerImpl clientDoc = clients[i];
                ItsNatStfulDocumentImpl itsNatStfulDocumentImpl = itsNatDoc = clientDoc.getItsNatStfulDocument();
                synchronized (itsNatStfulDocumentImpl) {
                    clientDoc.setInvalid();
                    continue;
                }
            }
        }
        MapUniqueId<ClientDocumentStfulOwnerImpl> i = this.ownerClientsById;
        synchronized (i) {
            this.ownerClientsById.clear();
            this.docsById.clear();
        }
        ClientDocumentAttachedClientImpl[] attachedClients = this.getClientDocumentAttachedClientArray();
        if (attachedClients != null) {
            for (int i2 = 0; i2 < attachedClients.length; ++i2) {
                ItsNatStfulDocumentImpl itsNatDoc;
                ClientDocumentAttachedClientImpl clientDoc = attachedClients[i2];
                ItsNatStfulDocumentImpl itsNatStfulDocumentImpl = itsNatDoc = clientDoc.getItsNatStfulDocument();
                synchronized (itsNatStfulDocumentImpl) {
                    clientDoc.setInvalid();
                    continue;
                }
            }
        }
        MapUniqueId<ClientDocumentImpl> mapUniqueId = this.attachedClientsById;
        synchronized (mapUniqueId) {
            this.attachedClientsById.clear();
        }
        mapUniqueId = this.attachedServersById;
        synchronized (mapUniqueId) {
            this.attachedServersById.clear();
        }
        this.referrer.popItsNatStfulDocument();
    }

    public String getToken() {
        return this.token;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    @Override
    public String getId() {
        return this.idObj.getId();
    }

    @Override
    public UniqueId getUniqueId() {
        return this.idObj;
    }

    public String getUserAgent() {
        return this.browser.getUserAgent();
    }

    protected abstract int getMaxInactiveInterval();

    public long getMaxInactiveIntervalMillisec() {
        int maxInterval = this.getMaxInactiveInterval();
        if (maxInterval < 0) {
            return Long.MAX_VALUE;
        }
        return 1000 * maxInterval;
    }

    public abstract Object getStandardSessionObject();

    public abstract String getStandardSessionId();

    @Override
    public ItsNatServletContext getItsNatServletContext() {
        return this.context;
    }

    public ItsNatServletContextImpl getItsNatServletContextImpl() {
        return this.context;
    }

    public Referrer getReferrer() {
        return this.referrer;
    }

    public ClientDocumentStfulImpl getClientDocumentStfulById(String id) {
        ClientDocumentStfulImpl clientDoc = this.getClientDocumentStfulOwnerById(id);
        if (clientDoc == null) {
            clientDoc = this.getClientDocumentAttachedClientById(id);
        }
        return clientDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientDocumentStfulOwnerCount() {
        MapUniqueId<ClientDocumentStfulOwnerImpl> mapUniqueId = this.ownerClientsById;
        synchronized (mapUniqueId) {
            return this.ownerClientsById.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientDocumentStfulOwnerImpl[] getClientDocumentStfulOwnerArray() {
        MapUniqueId<ClientDocumentStfulOwnerImpl> mapUniqueId = this.ownerClientsById;
        synchronized (mapUniqueId) {
            int size = this.ownerClientsById.size();
            if (size == 0) {
                return null;
            }
            ClientDocumentStfulOwnerImpl[] res = new ClientDocumentStfulOwnerImpl[size];
            int i = 0;
            for (Map.Entry<String, ClientDocumentStfulOwnerImpl> entry : this.ownerClientsById.entrySet()) {
                res[i] = entry.getValue();
                ++i;
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientDocumentStfulOwnerImpl getClientDocumentStfulOwnerById(String id) {
        MapUniqueId<ClientDocumentStfulOwnerImpl> mapUniqueId = this.ownerClientsById;
        synchronized (mapUniqueId) {
            return this.ownerClientsById.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClientDocumentStfulOwner(ClientDocumentStfulOwnerImpl clientDoc) {
        ItsNatStfulDocumentImpl docRes;
        ClientDocumentStfulOwnerImpl clientRes;
        ItsNatStfulDocumentImpl itsNatDoc = clientDoc.getItsNatStfulDocument();
        MapUniqueId<ClientDocumentStfulOwnerImpl> mapUniqueId = this.ownerClientsById;
        synchronized (mapUniqueId) {
            clientRes = this.ownerClientsById.put(clientDoc);
            docRes = this.docsById.put(itsNatDoc);
        }
        if (clientRes != null) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        if (docRes != null) {
            throw new ItsNatException("INTERNAL ERROR");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterClientDocumentStfulOwner(ClientDocumentStfulOwnerImpl clientDoc) {
        ItsNatStfulDocumentImpl itsNatDoc = clientDoc.getItsNatStfulDocument();
        MapUniqueId<ClientDocumentStfulOwnerImpl> mapUniqueId = this.ownerClientsById;
        synchronized (mapUniqueId) {
            this.ownerClientsById.remove(clientDoc);
            this.docsById.remove(itsNatDoc);
        }
    }

    @Override
    public ItsNatDocument[] getItsNatDocuments() {
        return this.getItsNatStfulDocumentArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getItsNatDocumentCount() {
        MapUniqueId<ClientDocumentStfulOwnerImpl> mapUniqueId = this.ownerClientsById;
        synchronized (mapUniqueId) {
            return this.docsById.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItsNatStfulDocumentImpl[] getItsNatStfulDocumentArray() {
        MapUniqueId<ClientDocumentStfulOwnerImpl> mapUniqueId = this.ownerClientsById;
        synchronized (mapUniqueId) {
            ItsNatStfulDocumentImpl[] res = new ItsNatStfulDocumentImpl[this.docsById.size()];
            int i = 0;
            for (Map.Entry<String, ItsNatStfulDocumentImpl> entry : this.docsById.entrySet()) {
                res[i] = entry.getValue();
                ++i;
            }
            return res;
        }
    }

    @Override
    public ItsNatDocument getItsNatDocumentById(String id) {
        return this.getItsNatStfulDocumentById(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItsNatStfulDocumentImpl getItsNatStfulDocumentById(String id) {
        MapUniqueId<ClientDocumentStfulOwnerImpl> mapUniqueId = this.ownerClientsById;
        synchronized (mapUniqueId) {
            return this.docsById.get(id);
        }
    }

    public UniqueIdGenIntList getUniqueIdGenerator() {
        return this.idGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientDocumentAttachedClientImpl getClientDocumentAttachedClientById(String id) {
        MapUniqueId<ClientDocumentAttachedClientImpl> mapUniqueId = this.attachedClientsById;
        synchronized (mapUniqueId) {
            return this.attachedClientsById.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClientDocumentAttachedClient(ClientDocumentAttachedClientImpl clientDoc) {
        ClientDocumentAttachedClientImpl res;
        MapUniqueId<ClientDocumentAttachedClientImpl> mapUniqueId = this.attachedClientsById;
        synchronized (mapUniqueId) {
            res = this.attachedClientsById.put(clientDoc);
        }
        if (res != null) {
            throw new ItsNatException("INTERNAL ERROR");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeClientDocumentAttachedClient(ClientDocumentAttachedClientImpl clientDoc) {
        ClientDocumentAttachedClientImpl res;
        MapUniqueId<ClientDocumentAttachedClientImpl> mapUniqueId = this.attachedClientsById;
        synchronized (mapUniqueId) {
            res = this.attachedClientsById.remove(clientDoc);
        }
        return res != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientDocumentAttachedClientCount() {
        MapUniqueId<ClientDocumentAttachedClientImpl> mapUniqueId = this.attachedClientsById;
        synchronized (mapUniqueId) {
            return this.attachedClientsById.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientDocumentAttachedClientImpl[] getClientDocumentAttachedClientArray() {
        MapUniqueId<ClientDocumentAttachedClientImpl> mapUniqueId = this.attachedClientsById;
        synchronized (mapUniqueId) {
            int size = this.attachedClientsById.size();
            if (size == 0) {
                return null;
            }
            ClientDocumentAttachedClientImpl[] res = new ClientDocumentAttachedClientImpl[size];
            int i = 0;
            for (Map.Entry<String, ClientDocumentAttachedClientImpl> entry : this.attachedClientsById.entrySet()) {
                res[i] = entry.getValue();
                ++i;
            }
            return res;
        }
    }

    public void registerClientDocumentAttachedClient(ClientDocumentAttachedClientImpl clientDoc) {
        this.addClientDocumentAttachedClient(clientDoc);
        ItsNatStfulDocumentImpl itsNatDoc = clientDoc.getItsNatStfulDocument();
        itsNatDoc.addClientDocumentAttachedClient(clientDoc);
    }

    public void unregisterClientDocumentAttachedClient(ClientDocumentAttachedClientImpl clientDoc) {
        clientDoc.setInvalid();
        boolean res = this.removeClientDocumentAttachedClient(clientDoc);
        if (res) {
            ItsNatStfulDocumentImpl itsNatDoc = clientDoc.getItsNatStfulDocument();
            itsNatDoc.removeClientDocumentAttachedClient(clientDoc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientDocumentAttachedServerImpl getClientDocumentAttachedServersById(String id) {
        MapUniqueId<ClientDocumentAttachedServerImpl> mapUniqueId = this.attachedServersById;
        synchronized (mapUniqueId) {
            return this.attachedServersById.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientDocumentAttachedServer(ClientDocumentAttachedServerImpl clientDoc) {
        ClientDocumentAttachedServerImpl res;
        MapUniqueId<ClientDocumentAttachedServerImpl> mapUniqueId = this.attachedServersById;
        synchronized (mapUniqueId) {
            res = this.attachedServersById.put(clientDoc);
        }
        if (res != null) {
            throw new ItsNatException("INTERNAL ERROR");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeClientDocumentAttachedServer(ClientDocumentAttachedServerImpl clientDoc) {
        ClientDocumentAttachedServerImpl res;
        MapUniqueId<ClientDocumentAttachedServerImpl> mapUniqueId = this.attachedServersById;
        synchronized (mapUniqueId) {
            res = this.attachedServersById.remove(clientDoc);
        }
        return res != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientDocumentAttachedServerCount() {
        MapUniqueId<ClientDocumentAttachedServerImpl> mapUniqueId = this.attachedServersById;
        synchronized (mapUniqueId) {
            return this.attachedServersById.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientDocumentAttachedServerImpl[] getClientDocumentAttachedServerArray() {
        MapUniqueId<ClientDocumentAttachedServerImpl> mapUniqueId = this.attachedServersById;
        synchronized (mapUniqueId) {
            int size = this.attachedServersById.size();
            if (size == 0) {
                return null;
            }
            ClientDocumentAttachedServerImpl[] res = new ClientDocumentAttachedServerImpl[size];
            int i = 0;
            for (Map.Entry<String, ClientDocumentAttachedServerImpl> entry : this.attachedServersById.entrySet()) {
                res[i] = entry.getValue();
                ++i;
            }
            return res;
        }
    }

    @Override
    public ItsNatVariableResolver createItsNatVariableResolver() {
        return new ItsNatVariableResolverImpl(null, null, null, this, null);
    }

    public Object getVariable(String varName) {
        Object value = this.getAttribute(varName);
        if (value != null) {
            return value;
        }
        return this.getItsNatServletContextImpl().getVariable(varName);
    }

    public void invalidateLostResources() {
        long currentTime = System.currentTimeMillis();
        long maxInactiveInterval = this.getMaxInactiveIntervalMillisec();
        this.cleanExpiredClients(currentTime, maxInactiveInterval);
        this.cleanExpiredAttachedServerClients(currentTime, maxInactiveInterval);
        this.cleanExpiredReferrer(currentTime, maxInactiveInterval);
        this.cleanExcessClientDocumentStfulOwners();
        this.cleanExcessClientDocumentAttachedServers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanExpiredClients(long currentTime, long maxInactiveInterval) {
        ClientDocumentAttachedClientImpl[] clientAttachedList;
        ClientDocumentStfulOwnerImpl[] clientOwnerList = this.getClientDocumentStfulOwnerArray();
        if (clientOwnerList != null) {
            for (int i = 0; i < clientOwnerList.length; ++i) {
                ItsNatStfulDocumentImpl itsNatStfulDocumentImpl;
                ItsNatStfulDocumentImpl itsNatDoc;
                ClientDocumentStfulOwnerImpl clientDoc = clientOwnerList[i];
                long lastRequestTime = clientDoc.getLastRequestTime();
                long interval = currentTime - lastRequestTime;
                if (interval > maxInactiveInterval) {
                    itsNatStfulDocumentImpl = itsNatDoc = clientDoc.getItsNatStfulDocument();
                    synchronized (itsNatStfulDocumentImpl) {
                        clientDoc.setInvalid();
                        continue;
                    }
                }
                itsNatStfulDocumentImpl = itsNatDoc = clientDoc.getItsNatStfulDocument();
                synchronized (itsNatStfulDocumentImpl) {
                    if (itsNatDoc.hasClientDocumentAttachedClient()) {
                        ClientDocumentAttachedClientImpl[] clientAttachList = itsNatDoc.getClientDocumentAttachedClientArray();
                        for (int j = 0; j < clientAttachList.length; ++j) {
                            ClientDocumentAttachedClientImpl clientDocAttached = clientAttachList[j];
                            ItsNatSessionImpl attachedSession = clientDocAttached.getItsNatSessionImpl();
                            if (attachedSession == this) continue;
                            ItsNatSessionImpl.cleanExpiredClientDocumentAttachedClient(clientDocAttached, currentTime);
                        }
                    }
                    this.cleanExcessClientDocumentAttachedClients(itsNatDoc);
                    continue;
                }
            }
        }
        if ((clientAttachedList = this.getClientDocumentAttachedClientArray()) != null) {
            for (int i = 0; i < clientAttachedList.length; ++i) {
                ClientDocumentAttachedClientImpl clientDoc = clientAttachedList[i];
                ItsNatSessionImpl.cleanExpiredClientDocumentAttachedClient(clientDoc, currentTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanExpiredClientDocumentAttachedClient(ClientDocumentAttachedClientImpl clientDoc, long currentTime) {
        ItsNatSessionImpl session = clientDoc.getItsNatSessionImpl();
        long maxInactiveInterval = session.getMaxInactiveIntervalMillisec();
        long lastRequestTime = clientDoc.getLastRequestTime();
        long interval = currentTime - lastRequestTime;
        if (interval > maxInactiveInterval) {
            ItsNatStfulDocumentImpl itsNatDoc;
            ItsNatStfulDocumentImpl itsNatStfulDocumentImpl = itsNatDoc = clientDoc.getItsNatStfulDocument();
            synchronized (itsNatStfulDocumentImpl) {
                clientDoc.invalidateAndUnregister();
            }
        }
    }

    public void cleanExpiredAttachedServerClients(long currentTime, long maxInactiveInterval) {
        ClientDocumentAttachedServerImpl[] clientAttachedList = this.getClientDocumentAttachedServerArray();
        if (clientAttachedList != null) {
            for (int i = 0; i < clientAttachedList.length; ++i) {
                ClientDocumentAttachedServerImpl clientDoc = clientAttachedList[i];
                long lastRequestTime = clientDoc.getLastRequestTime();
                long interval = currentTime - lastRequestTime;
                if (interval <= maxInactiveInterval) continue;
                clientDoc.setInvalid();
            }
        }
    }

    protected void cleanExpiredReferrer(long currentTime, long maxInactiveInterval) {
        ClientDocumentStfulOwnerImpl clientRef;
        long lastRequestTime;
        long interval;
        ItsNatStfulDocumentImpl itsNatDocRef;
        Referrer referer = this.getReferrer();
        if (this.referrer instanceof ReferrerStrong && (itsNatDocRef = referer.getItsNatStfulDocument()) != null && (interval = currentTime - (lastRequestTime = (clientRef = itsNatDocRef.getClientDocumentStfulOwner()).getLastRequestTime())) > maxInactiveInterval) {
            referer.popItsNatStfulDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanExcessClientDocumentStfulOwners() {
        ClientDocumentStfulOwnerImpl[] clients;
        int maxLiveDocs = this.getItsNatServletContextImpl().getMaxOpenDocumentsBySession();
        if (maxLiveDocs >= 0 && this.getClientDocumentStfulOwnerCount() > maxLiveDocs && (clients = this.getClientDocumentStfulOwnerArray()) != null) {
            int excess = clients.length - maxLiveDocs;
            Arrays.sort(clients, COMPARATOR_STFUL_OWNER);
            for (int i = 0; i < excess; ++i) {
                ItsNatStfulDocumentImpl itsNatDoc;
                ClientDocumentStfulOwnerImpl clientDoc = clients[i];
                ItsNatStfulDocumentImpl itsNatStfulDocumentImpl = itsNatDoc = clientDoc.getItsNatStfulDocument();
                synchronized (itsNatStfulDocumentImpl) {
                    clientDoc.setInvalid();
                    continue;
                }
            }
        }
    }

    public void cleanExcessClientDocumentAttachedClients(ItsNatStfulDocumentImpl itsNatDoc) {
        int maxClients = itsNatDoc.getMaxOpenClientsByDocument();
        int maxClientAttachedNum = maxClients < -1 ? -1 : maxClients - 1;
        if (maxClientAttachedNum >= 0 && itsNatDoc.getClientDocumentAttachedCount() > maxClientAttachedNum) {
            ClientDocumentAttachedClientImpl[] clientList = itsNatDoc.getClientDocumentAttachedClientArray();
            int excess = clientList.length - maxClientAttachedNum;
            Arrays.sort(clientList, COMPARATOR_ATTACHED_CLIENTS);
            for (int i = 0; i < excess; ++i) {
                ClientDocumentAttachedClientImpl clientDoc = clientList[i];
                clientDoc.invalidateAndUnregister();
            }
        }
    }

    protected void cleanExcessClientDocumentAttachedServers() {
        ClientDocumentAttachedServerImpl[] clientList;
        int maxLiveDocs = this.getItsNatServletContextImpl().getMaxOpenDocumentsBySession();
        if (maxLiveDocs >= 0 && this.getClientDocumentAttachedServerCount() > maxLiveDocs && (clientList = this.getClientDocumentAttachedServerArray()) != null) {
            int excess = clientList.length - maxLiveDocs;
            Arrays.sort(clientList, COMPARATOR_ATTACHED_SERVERS);
            for (int i = 0; i < excess; ++i) {
                ClientDocumentAttachedServerImpl clientDoc = clientList[i];
                clientDoc.setInvalid();
            }
        }
    }
}

