/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.servlet;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.itsnat.core.ClientDocument;
import org.itsnat.core.ItsNatDocument;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.ItsNatServlet;
import org.itsnat.core.ItsNatServletRequest;
import org.itsnat.core.ItsNatServletResponse;
import org.itsnat.core.ItsNatSession;
import org.itsnat.core.ItsNatVariableResolver;
import org.itsnat.impl.core.ItsNatUserDataImpl;
import org.itsnat.impl.core.ItsNatVariableResolverImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.req.RequestImpl;
import org.itsnat.impl.core.servlet.ItsNatServletContextImpl;
import org.itsnat.impl.core.servlet.ItsNatServletImpl;
import org.itsnat.impl.core.servlet.ItsNatServletResponseImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionImpl;

public abstract class ItsNatServletRequestImpl
extends ItsNatUserDataImpl
implements ItsNatServletRequest {
    protected ItsNatServletImpl itsNatServlet;
    protected ServletRequest request;
    protected ItsNatServletResponseImpl itsNatResponse;
    protected ItsNatSessionImpl itsnatSession;
    protected RequestImpl delegRequest;

    public ItsNatServletRequestImpl(ItsNatServletImpl itsNatServlet, ServletRequest request, ServletResponse response) {
        super(false);
        this.itsNatServlet = itsNatServlet;
        this.request = request;
        this.itsNatResponse = this.createItsNatServletResponse(response);
    }

    public abstract ItsNatServletResponseImpl createItsNatServletResponse(ServletResponse var1);

    public ItsNatSessionImpl getItsNatSessionImpl() {
        return this.itsnatSession;
    }

    public ItsNatServletImpl getItsNatServletImpl() {
        return this.itsNatServlet;
    }

    @Override
    public ItsNatServlet getItsNatServlet() {
        return this.itsNatServlet;
    }

    @Override
    public ServletRequest getServletRequest() {
        return this.request;
    }

    public ItsNatServletResponse getItsNatServletResponse() {
        return this.getItsNatServletResponseImpl();
    }

    public ItsNatServletResponseImpl getItsNatServletResponseImpl() {
        return this.itsNatResponse;
    }

    public RequestImpl getRequest() {
        return this.delegRequest;
    }

    public void setRequest(RequestImpl delegRequest) {
        this.delegRequest = delegRequest;
    }

    public ItsNatDocumentImpl getItsNatDocumentImpl() {
        return this.delegRequest.getItsNatDocument();
    }

    @Override
    public ItsNatDocument getItsNatDocument() {
        return this.getItsNatDocumentImpl();
    }

    public static String getAttrOrParam(ServletRequest request, String name) {
        String value = (String)request.getAttribute(name);
        if (value != null) {
            return value;
        }
        return request.getParameter(name);
    }

    public String getAttrOrParam(String name) {
        return ItsNatServletRequestImpl.getAttrOrParam(this.request, name);
    }

    public String getAttrOrParamExist(String name) {
        return this.getAttrOrParam(name, true);
    }

    protected String getAttrOrParam(String name, boolean throwError) {
        String param = this.getAttrOrParam(name);
        if (param == null && throwError) {
            throw new ItsNatException(name + " parameter is not specified");
        }
        return param;
    }

    public void bindRequestToDocument(ItsNatDocumentImpl itsNatDoc) {
        if (itsNatDoc != null) {
            itsNatDoc.setCurrentItsNatServletRequest(this);
        }
    }

    public void unbindRequestFromDocument() {
        ItsNatDocumentImpl itsNatDoc;
        ClientDocumentImpl clientDoc = this.getClientDocumentImpl();
        if (clientDoc != null && (itsNatDoc = clientDoc.getItsNatDocumentImpl()).getCurrentItsNatServletRequest() == this) {
            itsNatDoc.setCurrentItsNatServletRequest(null);
        }
    }

    @Override
    public ClientDocument getClientDocument() {
        return this.getClientDocumentImpl();
    }

    public ClientDocumentImpl getClientDocumentImpl() {
        return this.delegRequest.getClientDocument();
    }

    public ItsNatServletContextImpl getItsNatServletContext() {
        return this.getItsNatServletImpl().getItsNatServletConfigImpl().getItsNatServletContextImpl();
    }

    @Override
    public ItsNatSession getItsNatSession() {
        return this.getItsNatSessionImpl();
    }

    public void process(String action, ClientDocumentStfulImpl clientDocStateless) {
        this.delegRequest = RequestImpl.createRequest(action, this);
        this.delegRequest.process(clientDocStateless);
    }

    public Object getVariable(String varName) {
        ServletRequest request = this.getServletRequest();
        Object value = request.getParameter(varName);
        if (value != null) {
            return value;
        }
        value = request.getAttribute(varName);
        if (value != null) {
            return value;
        }
        return this.getItsNatDocumentImpl().getVariable(varName);
    }

    @Override
    public ItsNatVariableResolver createItsNatVariableResolver() {
        return new ItsNatVariableResolverImpl(null, this, null, null, null);
    }

    @Override
    public ItsNatDocument getItsNatDocumentReferrer() {
        return this.getItsNatStfulDocumentReferrer();
    }

    public ItsNatStfulDocumentImpl getItsNatStfulDocumentReferrer() {
        return this.delegRequest.getItsNatStfulDocumentReferrer();
    }

    public String getServletPath(boolean absoluteURL, boolean addSessionIdWhenNeeded) {
        String servletPath = absoluteURL ? this.getRequestURLInternal().toString() : this.getServletPathInternal();
        if (addSessionIdWhenNeeded) {
            ItsNatServletResponseImpl itsNatResponse = this.getItsNatServletResponseImpl();
            servletPath = itsNatResponse.encodeURL(servletPath);
        }
        return servletPath;
    }

    public abstract String getServletPathInternal();

    public abstract StringBuffer getRequestURLInternal();

    public abstract String getQueryStringInternal();

    public abstract boolean isValidClientStandardSessionId();

    public abstract String getHeader(String var1);
}

