/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.servlet;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.itsnat.comp.CreateItsNatComponentListener;
import org.itsnat.core.ItsNat;
import org.itsnat.core.ItsNatBoot;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.ItsNatServlet;
import org.itsnat.core.ItsNatServletConfig;
import org.itsnat.core.ItsNatServletContext;
import org.itsnat.core.event.ItsNatAttachedClientEventListener;
import org.itsnat.core.event.ItsNatServletRequestListener;
import org.itsnat.core.tmpl.ItsNatDocFragmentTemplate;
import org.itsnat.core.tmpl.ItsNatDocumentTemplate;
import org.itsnat.impl.core.ItsNatImpl;
import org.itsnat.impl.core.ItsNatUserDataImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.servlet.ItsNatServletConfigImpl;
import org.itsnat.impl.core.servlet.ItsNatServletContextImpl;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;
import org.itsnat.impl.core.servlet.ItsNatServletResponseImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionImpl;
import org.itsnat.impl.core.template.ItsNatDocFragmentTemplateImpl;
import org.itsnat.impl.core.template.ItsNatDocumentTemplateImpl;
import org.itsnat.impl.core.template.ItsNatStfulDocumentTemplateAttachedServerImpl;
import org.itsnat.impl.core.util.UniqueIdGenIntList;
import org.w3c.dom.events.EventListener;

public abstract class ItsNatServletImpl
extends ItsNatUserDataImpl
implements ItsNatServlet {
    protected ItsNatImpl parent;
    protected Servlet servlet;
    protected UniqueIdGenIntList idGenerator = new UniqueIdGenIntList(true);
    protected Map<String, ItsNatDocumentTemplateImpl> pages = Collections.synchronizedMap(new HashMap());
    protected Map<String, ItsNatDocFragmentTemplateImpl> fragments = Collections.synchronizedMap(new HashMap());
    protected LinkedList<ItsNatServletRequestListener> requestListeners;
    protected LinkedList<ItsNatAttachedClientEventListener> attachedEventListeners;
    protected LinkedList<EventListener> domEventListeners;
    protected LinkedList<CreateItsNatComponentListener> createCompListeners;
    protected ItsNatServletConfigImpl servletConfig;

    public ItsNatServletImpl(ItsNatImpl parent, Servlet servlet) {
        super(true);
        this.parent = parent;
        this.servlet = servlet;
        this.servletConfig = this.createItsNatServletConfig();
    }

    public static void writeObject(ItsNatServletImpl itsNatServlet, ObjectOutputStream out) throws IOException {
        out.writeObject(itsNatServlet.getName());
    }

    public static String readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        return (String)in.readObject();
    }

    public static ItsNatServletImpl getItsNatServletByName(String servletName) {
        ItsNatImpl itsNat = (ItsNatImpl)ItsNatBoot.get();
        return itsNat.getItsNatServletByName(servletName);
    }

    public ItsNatServletConfigImpl createItsNatServletConfig() {
        return new ItsNatServletConfigImpl(this.servlet.getServletConfig(), this);
    }

    @Override
    public ItsNatServletContext getItsNatServletContext() {
        return this.servletConfig.getItsNatServletContext();
    }

    public ItsNatServletContextImpl getItsNatServletContextImpl() {
        return this.servletConfig.getItsNatServletContextImpl();
    }

    public UniqueIdGenIntList getUniqueIdGenerator() {
        return this.idGenerator;
    }

    @Override
    public ItsNat getItsNat() {
        return this.getItsNatImpl();
    }

    public ItsNatImpl getItsNatImpl() {
        return this.parent;
    }

    public String getName() {
        return this.servlet.getServletConfig().getServletName();
    }

    @Override
    public Servlet getServlet() {
        return this.servlet;
    }

    @Override
    public ItsNatServletConfig getItsNatServletConfig() {
        return this.servletConfig;
    }

    public ItsNatServletConfigImpl getItsNatServletConfigImpl() {
        return this.servletConfig;
    }

    protected void registerItsNatDocumentTemplate(ItsNatDocumentTemplateImpl docTemplate) {
        ItsNatDocumentTemplateImpl res = this.pages.put(docTemplate.getName(), docTemplate);
        if (res != null) {
            throw new ItsNatException("One document template is already registered with this name:" + docTemplate.getName());
        }
    }

    @Override
    public ItsNatDocumentTemplate registerItsNatDocumentTemplate(String name, String mime, Object source) {
        ItsNatDocumentTemplateImpl docTemplate = ItsNatDocumentTemplateImpl.createItsNatDocumentTemplate(name, mime, source, this);
        this.registerItsNatDocumentTemplate(docTemplate);
        return docTemplate;
    }

    @Override
    public ItsNatDocumentTemplate registerItsNatDocumentTemplateAttachedServer(String name, String mime) {
        ItsNatStfulDocumentTemplateAttachedServerImpl docTemplate = ItsNatDocumentTemplateImpl.createItsNatStfulDocumentTemplateAttachedServer(name, mime, this);
        this.registerItsNatDocumentTemplate(docTemplate);
        return docTemplate;
    }

    @Override
    public ItsNatDocumentTemplate getItsNatDocumentTemplate(String name) {
        return this.getItsNatDocumentTemplateImpl(name);
    }

    public ItsNatDocumentTemplateImpl getItsNatDocumentTemplateImpl(String name) {
        return this.pages.get(name);
    }

    @Override
    public ItsNatDocFragmentTemplate registerItsNatDocFragmentTemplate(String name, String mime, Object source) {
        ItsNatDocFragmentTemplateImpl fragmentDesc = ItsNatDocFragmentTemplateImpl.createItsNatDocFragmentTemplate(name, mime, source, this);
        ItsNatDocFragmentTemplateImpl res = this.fragments.put(fragmentDesc.getName(), fragmentDesc);
        if (res != null) {
            throw new ItsNatException("One document fragment template is already registered with this name:" + fragmentDesc.getName());
        }
        return fragmentDesc;
    }

    @Override
    public ItsNatDocFragmentTemplate getItsNatDocFragmentTemplate(String name) {
        return this.getItsNatDocFragmentTemplateImpl(name);
    }

    public ItsNatDocFragmentTemplateImpl getItsNatDocFragmentTemplateImpl(String name) {
        return this.fragments.get(name);
    }

    public void checkIsAlreadyUsed() {
        if (!this.fragments.isEmpty()) {
            throw new ItsNatException("Servlet is frozen because some fragment was already registered", (Object)this);
        }
    }

    public boolean dispatchItsNatServletRequestListeners(ItsNatServletRequestImpl itsNatRequest) {
        if (this.hasItsNatServletRequestListeners()) {
            ItsNatServletResponseImpl itsNatResponse = itsNatRequest.getItsNatServletResponseImpl();
            Iterator<ItsNatServletRequestListener> iterator = this.getItsNatServletRequestListenerIterator();
            itsNatResponse.dispatchItsNatServletRequestListeners(iterator);
            return true;
        }
        return false;
    }

    public boolean hasItsNatServletRequestListeners() {
        if (this.requestListeners == null) {
            return false;
        }
        return !this.requestListeners.isEmpty();
    }

    public LinkedList<ItsNatServletRequestListener> getItsNatServletRequestListenerList() {
        if (this.requestListeners == null) {
            this.requestListeners = new LinkedList();
        }
        return this.requestListeners;
    }

    public Iterator<ItsNatServletRequestListener> getItsNatServletRequestListenerIterator() {
        if (this.requestListeners == null) {
            return null;
        }
        if (this.requestListeners.isEmpty()) {
            return null;
        }
        return this.requestListeners.iterator();
    }

    @Override
    public void addItsNatServletRequestListener(ItsNatServletRequestListener listener) {
        this.checkIsAlreadyUsed();
        LinkedList<ItsNatServletRequestListener> requestListeners = this.getItsNatServletRequestListenerList();
        requestListeners.add(listener);
    }

    @Override
    public void removeItsNatServletRequestListener(ItsNatServletRequestListener listener) {
        this.checkIsAlreadyUsed();
        LinkedList<ItsNatServletRequestListener> requestListeners = this.getItsNatServletRequestListenerList();
        requestListeners.remove(listener);
    }

    public LinkedList<ItsNatAttachedClientEventListener> getItsNatAttachedClientEventListenerList() {
        if (this.attachedEventListeners == null) {
            this.attachedEventListeners = new LinkedList();
        }
        return this.attachedEventListeners;
    }

    public boolean hasItsNatAttachedClientEventListeners() {
        if (this.attachedEventListeners == null) {
            return false;
        }
        return !this.attachedEventListeners.isEmpty();
    }

    public void getItsNatAttachedClientEventListenerList(LinkedList<ItsNatAttachedClientEventListener> list) {
        if (this.attachedEventListeners == null) {
            return;
        }
        list.addAll(this.attachedEventListeners);
    }

    @Override
    public void addItsNatAttachedClientEventListener(ItsNatAttachedClientEventListener listener) {
        this.checkIsAlreadyUsed();
        LinkedList<ItsNatAttachedClientEventListener> attachedEventListeners = this.getItsNatAttachedClientEventListenerList();
        attachedEventListeners.add(listener);
    }

    @Override
    public void removeItsNatAttachedClientEventListener(ItsNatAttachedClientEventListener listener) {
        this.checkIsAlreadyUsed();
        LinkedList<ItsNatAttachedClientEventListener> attachedEventListeners = this.getItsNatAttachedClientEventListenerList();
        attachedEventListeners.remove(listener);
    }

    public boolean hasGlobalEventListenerListeners() {
        if (this.domEventListeners == null) {
            return false;
        }
        return !this.domEventListeners.isEmpty();
    }

    public LinkedList<EventListener> getGlobalEventListenerList() {
        if (this.domEventListeners == null) {
            this.domEventListeners = new LinkedList();
        }
        return this.domEventListeners;
    }

    public void getGlobalEventListenerList(LinkedList<EventListener> list) {
        if (this.domEventListeners == null) {
            return;
        }
        list.addAll(this.domEventListeners);
    }

    @Override
    public void addEventListener(EventListener listener) {
        this.checkIsAlreadyUsed();
        LinkedList<EventListener> domEventListeners = this.getGlobalEventListenerList();
        domEventListeners.add(listener);
    }

    @Override
    public void removeEventListener(EventListener listener) {
        this.checkIsAlreadyUsed();
        LinkedList<EventListener> domEventListeners = this.getGlobalEventListenerList();
        domEventListeners.remove(listener);
    }

    public boolean hasCreateItsNatComponentList() {
        if (this.createCompListeners == null) {
            return false;
        }
        return !this.createCompListeners.isEmpty();
    }

    public LinkedList<CreateItsNatComponentListener> getCreateItsNatComponentList() {
        if (this.createCompListeners == null) {
            this.createCompListeners = new LinkedList();
        }
        return this.createCompListeners;
    }

    public Iterator<CreateItsNatComponentListener> getCreateItsNatComponentListenerIterator() {
        if (!this.hasCreateItsNatComponentList()) {
            return null;
        }
        return this.createCompListeners.iterator();
    }

    @Override
    public void addCreateItsNatComponentListener(CreateItsNatComponentListener listener) {
        this.checkIsAlreadyUsed();
        LinkedList<CreateItsNatComponentListener> list = this.getCreateItsNatComponentList();
        list.add(listener);
    }

    @Override
    public void removeCreateItsNatComponentListener(CreateItsNatComponentListener listener) {
        this.checkIsAlreadyUsed();
        LinkedList<CreateItsNatComponentListener> list = this.getCreateItsNatComponentList();
        list.remove(listener);
    }

    @Override
    public void processRequest(ServletRequest request, ServletResponse response) {
        this.processRequestInternal(request, response, null);
    }

    public abstract ItsNatServletRequestImpl processRequestInternal(ServletRequest var1, ServletResponse var2, ClientDocumentStfulImpl var3);

    public abstract ItsNatServletRequestImpl createItsNatServletRequest(ServletRequest var1, ServletResponse var2, ItsNatSessionImpl var3);
}

