/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.servlet;

import java.security.MessageDigest;
import javax.servlet.http.HttpSession;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.servlet.ItsNatServletContextImpl;
import org.itsnat.impl.core.util.UniqueId;
import org.itsnat.impl.core.util.UniqueIdGenIntList;
import org.itsnat.impl.core.util.UniqueIdGenMessageDigest;
import org.itsnat.impl.core.util.UniqueIdGenerator;

public class ItsNatServletContextUniqueIdGenImpl
implements UniqueIdGenerator {
    protected MessageDigest md;
    protected ItsNatServletContextImpl context;
    protected UniqueIdGenIntList genIntList;
    protected UniqueIdGenMessageDigest genMesDigest;
    protected boolean frozen = false;

    public ItsNatServletContextUniqueIdGenImpl(ItsNatServletContextImpl context) {
        this.context = context;
        this.initIdGenerators();
    }

    public void initIdGenerators() {
        if (this.context.isSessionReplicationCapable()) {
            this.genIntList = null;
            this.genMesDigest = new UniqueIdGenMessageDigest();
        } else {
            this.genIntList = new UniqueIdGenIntList(true);
            this.genMesDigest = null;
        }
    }

    public void notifySessionReplicationCapableChanged() {
        if (this.frozen) {
            throw new ItsNatException("Too late some servlet has already received events");
        }
        this.initIdGenerators();
    }

    public UniqueId generateUniqueId(HttpSession session, String prefix) {
        this.frozen = true;
        String id = this.context.isSessionReplicationCapable() ? this.genMesDigest.generateId(session.getId(), prefix) : this.genIntList.generateId(prefix);
        return new UniqueId(id, this);
    }
}

