/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.servlet;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.servlet.ServletContext;
import org.itsnat.core.ItsNat;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.ItsNatServletContext;
import org.itsnat.core.ItsNatSessionCallback;
import org.itsnat.core.ItsNatVariableResolver;
import org.itsnat.impl.core.ItsNatImpl;
import org.itsnat.impl.core.ItsNatUserDataImpl;
import org.itsnat.impl.core.ItsNatVariableResolverImpl;
import org.itsnat.impl.core.servlet.ItsNatServletContextUniqueIdGenImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionImpl;
import org.itsnat.impl.core.util.MapUniqueId;

public class ItsNatServletContextImpl
extends ItsNatUserDataImpl
implements ItsNatServletContext {
    public static final long SESSION_EXPLICIT_SERIALIZE_ONE_FRAGMENT = 0L;
    protected ItsNatImpl itsNat;
    protected ServletContext servletContext;
    protected final Map<String, ItsNatSessionImpl> sessionsByStandardId = new HashMap<String, ItsNatSessionImpl>();
    protected Map<String, ItsNatSessionImpl> sessionsByItsNatId = new HashMap<String, ItsNatSessionImpl>();
    protected ItsNatServletContextUniqueIdGenImpl idGenerator = new ItsNatServletContextUniqueIdGenImpl(this);
    protected Random random = new Random();
    protected int maxOpenDocumentsBySession = 10;
    protected boolean maxOpenDocumentsBySession_WasSet = false;
    protected boolean sessionReplicationCapable = false;
    protected boolean sessionReplicationCapable_WasSet = false;
    protected boolean sessionSerializeCompressed = false;
    protected boolean sessionSerializeCompressed_WasSet = false;
    protected boolean sessionExplicitSerialize = false;
    protected boolean sessionExplicitSerialize_WasSet = false;
    protected long sessionExplicitSerializeFragmentSize = 0L;
    protected boolean sessionExplicitSerializeFragmentSize_WasSet = false;
    protected boolean configurationFrozen = false;

    public ItsNatServletContextImpl(ItsNatImpl itsNat, ServletContext servletContext) {
        super(true);
        this.itsNat = itsNat;
        this.servletContext = servletContext;
    }

    public ItsNatImpl getItsNatImpl() {
        return this.itsNat;
    }

    @Override
    public ItsNat getItsNat() {
        return this.itsNat;
    }

    public String getURLRootPath() {
        try {
            return this.servletContext.getResource("/").getPath();
        }
        catch (MalformedURLException ex) {
            throw new ItsNatException(ex);
        }
    }

    public ItsNatServletContextUniqueIdGenImpl getUniqueIdGenerator() {
        return this.idGenerator;
    }

    public int getNewToken() {
        return this.random.nextInt(65536);
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void checkConfigChange(boolean changed, boolean wasSet) {
        if (changed && wasSet) {
            throw new ItsNatException("Incoherent new value, current configuration value cannot be changed again or maybe two servlets are defining different values");
        }
    }

    public void checkConfigChange(boolean currValue, boolean newValue, boolean wasSet) {
        this.checkConfigChange(currValue != newValue, wasSet);
    }

    public void checkConfigChange(int currValue, int newValue, boolean wasSet) {
        this.checkConfigChange(currValue != newValue, wasSet);
    }

    public void checkConfigChange(long currValue, long newValue, boolean wasSet) {
        this.checkConfigChange(currValue != newValue, wasSet);
    }

    @Override
    public int getMaxOpenDocumentsBySession() {
        return this.maxOpenDocumentsBySession;
    }

    @Override
    public void setMaxOpenDocumentsBySession(int maxOpenDocumentsBySession) {
        this.checkConfigChange(this.maxOpenDocumentsBySession, maxOpenDocumentsBySession, this.maxOpenDocumentsBySession_WasSet);
        this.maxOpenDocumentsBySession = maxOpenDocumentsBySession;
        this.maxOpenDocumentsBySession_WasSet = true;
    }

    @Override
    public boolean isSessionReplicationCapable() {
        return this.sessionReplicationCapable;
    }

    @Override
    public void setSessionReplicationCapable(boolean sessionReplicationCapable) {
        this.checkConfigChange(this.sessionReplicationCapable, sessionReplicationCapable, this.sessionReplicationCapable_WasSet);
        boolean changed = this.sessionReplicationCapable != sessionReplicationCapable;
        this.sessionReplicationCapable = sessionReplicationCapable;
        this.sessionReplicationCapable_WasSet = true;
        if (changed) {
            this.idGenerator.notifySessionReplicationCapableChanged();
        }
    }

    @Override
    public boolean isSessionSerializeCompressed() {
        return this.sessionSerializeCompressed;
    }

    @Override
    public void setSessionSerializeCompressed(boolean sessionSerializeCompressed) {
        this.checkConfigChange(this.sessionSerializeCompressed, sessionSerializeCompressed, this.sessionSerializeCompressed_WasSet);
        this.sessionSerializeCompressed = sessionSerializeCompressed;
        this.sessionSerializeCompressed_WasSet = true;
    }

    @Override
    public boolean isSessionExplicitSerialize() {
        return this.sessionExplicitSerialize;
    }

    @Override
    public void setSessionExplicitSerialize(boolean sessionExplicitSerialize) {
        this.checkConfigChange(this.sessionExplicitSerialize, sessionExplicitSerialize, this.sessionExplicitSerialize_WasSet);
        this.sessionExplicitSerialize = sessionExplicitSerialize;
        this.sessionExplicitSerialize_WasSet = true;
    }

    public long getSessionExplicitSerializeFragmentSize() {
        return this.sessionExplicitSerializeFragmentSize;
    }

    public void setSessionExplicitSerializeFragmentSize(long sessionExplicitSerializeFragmentSize) {
        if (sessionExplicitSerializeFragmentSize < 0L) {
            throw new ItsNatException("Expected a positive value or cero: " + sessionExplicitSerializeFragmentSize);
        }
        this.checkConfigChange(this.sessionExplicitSerializeFragmentSize, sessionExplicitSerializeFragmentSize, this.sessionExplicitSerializeFragmentSize_WasSet);
        this.sessionExplicitSerializeFragmentSize = sessionExplicitSerializeFragmentSize;
        this.sessionExplicitSerializeFragmentSize_WasSet = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItsNatSession(ItsNatSessionImpl itsNatSession) {
        if (!this.configurationFrozen) {
            this.configurationFrozen = true;
        }
        String builtInId = itsNatSession.getStandardSessionId();
        Map<String, ItsNatSessionImpl> map = this.sessionsByStandardId;
        synchronized (map) {
            this.sessionsByStandardId.put(builtInId, itsNatSession);
            MapUniqueId.check(this.idGenerator, itsNatSession);
            this.sessionsByItsNatId.put(itsNatSession.getId(), itsNatSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItsNatSessionImpl findItsNatSessionByItsNatId(String id) {
        ItsNatSessionImpl itsNatSession;
        Map<String, ItsNatSessionImpl> map = this.sessionsByStandardId;
        synchronized (map) {
            itsNatSession = this.sessionsByItsNatId.get(id);
        }
        return itsNatSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItsNatSessionImpl getItsNatSessionByStandardId(String id) {
        ItsNatSessionImpl itsNatSession;
        Map<String, ItsNatSessionImpl> map = this.sessionsByStandardId;
        synchronized (map) {
            itsNatSession = this.sessionsByStandardId.get(id);
        }
        return itsNatSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItsNatSession(ItsNatSessionImpl itsNatSession) {
        String builtInId = itsNatSession.getStandardSessionId();
        Map<String, ItsNatSessionImpl> map = this.sessionsByStandardId;
        synchronized (map) {
            this.sessionsByStandardId.remove(builtInId);
            this.sessionsByItsNatId.remove(itsNatSession.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerateSessions(ItsNatSessionCallback callback) {
        Map<String, ItsNatSessionImpl> map = this.sessionsByStandardId;
        synchronized (map) {
            Map.Entry<String, ItsNatSessionImpl> entry;
            ItsNatSessionImpl itsNatSession;
            if (this.sessionsByStandardId.isEmpty()) {
                return;
            }
            Iterator<Map.Entry<String, ItsNatSessionImpl>> i$ = this.sessionsByStandardId.entrySet().iterator();
            while (i$.hasNext() && ((itsNatSession = (entry = i$.next()).getValue()) == null || callback.handleSession(itsNatSession))) {
            }
        }
    }

    public Object getVariable(String varName) {
        return this.getServletContext().getAttribute(varName);
    }

    @Override
    public ItsNatVariableResolver createItsNatVariableResolver() {
        return new ItsNatVariableResolverImpl(null, null, null, null, this);
    }
}

