/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.servlet;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.ItsNatServletConfig;
import org.itsnat.core.ItsNatServletContext;
import org.itsnat.impl.core.CommModeImpl;
import org.itsnat.impl.core.ItsNatImpl;
import org.itsnat.impl.core.ItsNatUserDataImpl;
import org.itsnat.impl.core.servlet.ItsNatServletContextImpl;
import org.itsnat.impl.core.servlet.ItsNatServletImpl;

public class ItsNatServletConfigImpl
extends ItsNatUserDataImpl
implements ItsNatServletConfig {
    protected ServletConfig servletConfig;
    protected ItsNatServletImpl servlet;
    protected ItsNatServletContextImpl servletContext;
    protected Map<String, Boolean> cacheDOMNodesByMime = new HashMap<String, Boolean>();
    protected Map<String, Object> artifacts;
    protected int commMode = 3;
    protected long eventTimeout = -1L;
    protected String defaultEncoding = "UTF-8";
    protected boolean debugMode = true;
    protected int clientErrorMode = 4;
    protected boolean loadScriptInline = true;
    protected boolean fastLoadMode = true;
    protected boolean nodeCacheEnabled = true;
    protected boolean autoBuildComponents = false;
    protected int useGZip = 2;
    protected DateFormat dateFormat = DateFormat.getInstance();
    protected NumberFormat numberFormat = NumberFormat.getInstance();
    protected long evtDispMaxWait = 0L;
    protected int maxOpenClients = 10;
    protected boolean referrerEnabled = false;
    protected boolean referrerPushEnabled = false;
    protected boolean eventsEnabled = true;
    protected boolean scriptEnabled = true;
    protected boolean autoCleanEventListeners = true;
    protected boolean useXHRSyncOnUnloadEvent = true;
    protected boolean usePatternMarkupToRender = false;
    protected boolean selectionOnComponentsUsesKeyboard = true;
    protected boolean joystickMode = false;
    protected boolean markupDrivenComponents = false;
    protected int bitmapDensityReference = 320;

    public ItsNatServletConfigImpl(ServletConfig servletConfig, ItsNatServletImpl servlet) {
        super(true);
        this.servletConfig = servletConfig;
        this.servlet = servlet;
        ItsNatImpl itsNat = servlet.getItsNatImpl();
        this.servletContext = itsNat.getItsNatServletContextImpl(servletConfig.getServletContext());
        this.cacheDOMNodesByMime.put("text/html", Boolean.TRUE);
        this.cacheDOMNodesByMime.put("application/xhtml+xml", Boolean.TRUE);
        this.cacheDOMNodesByMime.put("image/svg+xml", Boolean.TRUE);
        this.cacheDOMNodesByMime.put("application/vnd.mozilla.xul+xml", Boolean.TRUE);
        this.cacheDOMNodesByMime.put("text/xml", Boolean.FALSE);
        this.cacheDOMNodesByMime.put("android/layout", Boolean.FALSE);
    }

    @Override
    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    @Override
    public ItsNatServletContext getItsNatServletContext() {
        return this.servletContext;
    }

    public ItsNatServletContextImpl getItsNatServletContextImpl() {
        return this.servletContext;
    }

    public boolean hasArtifacts() {
        if (this.artifacts == null) {
            return false;
        }
        return !this.artifacts.isEmpty();
    }

    public Map<String, Object> getArtifactMap() {
        if (this.artifacts == null) {
            this.artifacts = new HashMap<String, Object>();
        }
        return this.artifacts;
    }

    @Override
    public Object getArtifact(String name) {
        if (!this.hasArtifacts()) {
            return null;
        }
        Map<String, Object> artifacts = this.getArtifactMap();
        return artifacts.get(name);
    }

    @Override
    public void registerArtifact(String name, Object value) {
        this.checkIsAlreadyUsed();
        Map<String, Object> artifacts = this.getArtifactMap();
        artifacts.put(name, value);
    }

    @Override
    public Object removeArtifact(String name) {
        this.checkIsAlreadyUsed();
        Map<String, Object> artifacts = this.getArtifactMap();
        return artifacts.remove(name);
    }

    public void checkIsAlreadyUsed() {
        this.servlet.checkIsAlreadyUsed();
    }

    @Override
    public int getCommMode() {
        return this.commMode;
    }

    @Override
    public void setCommMode(int commMode) {
        this.checkIsAlreadyUsed();
        CommModeImpl.checkMode(commMode);
        this.commMode = commMode;
    }

    @Override
    public long getEventTimeout() {
        return this.eventTimeout;
    }

    @Override
    public void setEventTimeout(long timeout) {
        this.checkIsAlreadyUsed();
        this.eventTimeout = timeout;
    }

    @Override
    public int getUseGZip() {
        return this.useGZip;
    }

    @Override
    public void setUseGZip(int value) {
        this.checkIsAlreadyUsed();
        this.useGZip = value;
    }

    @Override
    public boolean isOnLoadCacheStaticNodes(String mime) {
        Boolean value = this.cacheDOMNodesByMime.get(mime);
        if (value == null) {
            return false;
        }
        return value;
    }

    @Override
    public void setOnLoadCacheStaticNodes(String mime, boolean cache) {
        this.checkIsAlreadyUsed();
        this.cacheDOMNodesByMime.put(mime, cache);
    }

    @Override
    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    @Override
    public void setDefaultEncoding(String defaultEncoding) {
        this.checkIsAlreadyUsed();
        this.defaultEncoding = defaultEncoding;
    }

    @Override
    public boolean isLoadScriptInline() {
        return this.loadScriptInline;
    }

    @Override
    public void setLoadScriptInline(boolean value) {
        this.checkIsAlreadyUsed();
        this.loadScriptInline = value;
    }

    @Override
    public boolean isDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean debugMode) {
        this.checkIsAlreadyUsed();
        this.debugMode = debugMode;
    }

    @Override
    public int getClientErrorMode() {
        return this.clientErrorMode;
    }

    @Override
    public void setClientErrorMode(int mode) {
        this.checkIsAlreadyUsed();
        this.clientErrorMode = mode;
    }

    @Override
    public boolean isFastLoadMode() {
        return this.fastLoadMode;
    }

    @Override
    public void setFastLoadMode(boolean fastLoadMode) {
        this.checkIsAlreadyUsed();
        this.fastLoadMode = fastLoadMode;
    }

    @Override
    public boolean isNodeCacheEnabled() {
        return this.nodeCacheEnabled;
    }

    @Override
    public void setNodeCacheEnabled(boolean nodeCacheEnabled) {
        this.checkIsAlreadyUsed();
        this.nodeCacheEnabled = nodeCacheEnabled;
    }

    @Override
    public boolean isAutoBuildComponents() {
        return this.autoBuildComponents;
    }

    @Override
    public void setAutoBuildComponents(boolean autoBuildComponents) {
        this.checkIsAlreadyUsed();
        this.autoBuildComponents = autoBuildComponents;
    }

    @Override
    public DateFormat getDefaultDateFormat() {
        return this.dateFormat;
    }

    @Override
    public void setDefaultDateFormat(DateFormat dateFormat) {
        this.checkIsAlreadyUsed();
        this.dateFormat = dateFormat;
    }

    @Override
    public NumberFormat getDefaultNumberFormat() {
        return this.numberFormat;
    }

    @Override
    public void setDefaultNumberFormat(NumberFormat numberFormat) {
        this.checkIsAlreadyUsed();
        this.numberFormat = numberFormat;
    }

    @Override
    public long getEventDispatcherMaxWait() {
        return this.evtDispMaxWait;
    }

    @Override
    public void setEventDispatcherMaxWait(long wait) {
        this.checkIsAlreadyUsed();
        this.evtDispMaxWait = wait;
    }

    @Override
    public int getMaxOpenClientsByDocument() {
        return this.maxOpenClients;
    }

    @Override
    public void setMaxOpenClientsByDocument(int value) {
        this.checkIsAlreadyUsed();
        ItsNatServletConfigImpl.checkMaxOpenClientsByDocument(value);
        this.maxOpenClients = value;
    }

    public static void checkMaxOpenClientsByDocument(int value) {
        if (value == 0) {
            throw new ItsNatException("Max number of open clients cannot be 0");
        }
    }

    @Override
    public boolean isReferrerEnabled() {
        return this.referrerEnabled;
    }

    @Override
    public void setReferrerEnabled(boolean referrerEnabled) {
        this.checkIsAlreadyUsed();
        this.referrerEnabled = referrerEnabled;
    }

    @Override
    public boolean isReferrerPushEnabled() {
        return this.referrerPushEnabled;
    }

    @Override
    public void setReferrerPushEnabled(boolean referrerPushEnabled) {
        this.checkIsAlreadyUsed();
        this.referrerPushEnabled = referrerPushEnabled;
    }

    @Override
    public boolean isEventsEnabled() {
        return this.eventsEnabled;
    }

    @Override
    public void setEventsEnabled(boolean enable) {
        this.checkIsAlreadyUsed();
        this.eventsEnabled = enable;
    }

    @Override
    public boolean isScriptingEnabled() {
        return this.scriptEnabled;
    }

    @Override
    public void setScriptingEnabled(boolean enabled) {
        this.checkIsAlreadyUsed();
        this.scriptEnabled = enabled;
        if (!enabled) {
            this.setEventsEnabled(false);
            this.setFastLoadMode(true);
        }
    }

    @Override
    public boolean isAutoCleanEventListeners() {
        return this.autoCleanEventListeners;
    }

    @Override
    public void setAutoCleanEventListeners(boolean enable) {
        this.checkIsAlreadyUsed();
        this.autoCleanEventListeners = enable;
    }

    @Override
    public boolean isUseXHRSyncOnUnloadEvent() {
        return this.useXHRSyncOnUnloadEvent;
    }

    @Override
    public void setUseXHRSyncOnUnloadEvent(boolean enable) {
        this.checkIsAlreadyUsed();
        this.useXHRSyncOnUnloadEvent = enable;
    }

    @Override
    public boolean isUsePatternMarkupToRender() {
        return this.usePatternMarkupToRender;
    }

    @Override
    public void setUsePatternMarkupToRender(boolean usePatternMarkupToRender) {
        this.checkIsAlreadyUsed();
        this.usePatternMarkupToRender = usePatternMarkupToRender;
    }

    @Override
    public boolean isSelectionOnComponentsUsesKeyboard() {
        return this.selectionOnComponentsUsesKeyboard;
    }

    @Override
    public void setSelectionOnComponentsUsesKeyboard(boolean value) {
        this.checkIsAlreadyUsed();
        this.selectionOnComponentsUsesKeyboard = value;
    }

    @Override
    public boolean isJoystickMode() {
        return this.joystickMode;
    }

    @Override
    public void setJoystickMode(boolean value) {
        this.checkIsAlreadyUsed();
        this.joystickMode = value;
    }

    @Override
    public boolean isMarkupDrivenComponents() {
        return this.markupDrivenComponents;
    }

    @Override
    public void setMarkupDrivenComponents(boolean value) {
        this.checkIsAlreadyUsed();
        this.markupDrivenComponents = value;
    }

    @Override
    public int getBitmapDensityReference() {
        return this.bitmapDensityReference;
    }

    @Override
    public void setBitmapDensityReference(int density) {
        this.checkIsAlreadyUsed();
        this.bitmapDensityReference = density;
    }
}

