/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.scriptren.shared;

import org.itsnat.core.ItsNatException;
import org.itsnat.core.script.ScriptExpr;
import org.itsnat.core.script.ScriptUtil;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.clientdoc.NodeCacheRegistryImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.doc.droid.ItsNatStfulDroidDocumentImpl;
import org.itsnat.impl.core.doc.web.ItsNatStfulWebDocumentImpl;
import org.itsnat.impl.core.dompath.NodeLocationWithParentImpl;
import org.itsnat.impl.core.scriptren.bsren.BSScriptUtilFromDocImpl;
import org.itsnat.impl.core.scriptren.jsren.JSScriptUtilFromDocImpl;
import org.itsnat.impl.core.scriptren.shared.JSAndBSRenderImpl;
import org.itsnat.impl.core.scriptren.shared.ScriptExprImpl;
import org.w3c.dom.Node;

public abstract class ScriptUtilImpl
implements ScriptUtil {
    public static ScriptUtilImpl createScriptUtilFromDoc(ItsNatStfulDocumentImpl itsNatDoc) {
        if (itsNatDoc instanceof ItsNatStfulWebDocumentImpl) {
            return new JSScriptUtilFromDocImpl((ItsNatStfulWebDocumentImpl)itsNatDoc);
        }
        if (itsNatDoc instanceof ItsNatStfulDroidDocumentImpl) {
            return new BSScriptUtilFromDocImpl((ItsNatStfulDroidDocumentImpl)itsNatDoc);
        }
        return null;
    }

    public void checkAllClientsCanReceiveScriptCode() {
        ClientDocumentStfulDelegateImpl clientDoc = this.getCurrentClientDocumentStfulDelegate();
        if (!clientDoc.getClientDocumentStful().isSendCodeEnabled()) {
            throw new ItsNatException("This client cannot receive JavaScript code", (Object)this);
        }
    }

    @Override
    public String getNodeReference(Node node) {
        if (node == null) {
            return "null";
        }
        this.preventiveNodeCaching(node);
        ClientDocumentStfulDelegateImpl clientDoc = this.getCurrentClientDocumentStfulDelegate();
        return clientDoc.getNodeReference(node, false, true);
    }

    @Override
    public String getTransportableStringLiteral(String text) {
        ClientDocumentStfulDelegateImpl clientDoc = this.getCurrentClientDocumentStfulDelegate();
        return JSAndBSRenderImpl.toTransportableStringLiteral(text, clientDoc.getBrowser());
    }

    @Override
    public String getTransportableCharLiteral(char c) {
        ClientDocumentStfulDelegateImpl clientDoc = this.getCurrentClientDocumentStfulDelegate();
        return JSAndBSRenderImpl.getTransportableCharLiteral(c, clientDoc.getBrowser());
    }

    protected boolean isNodeCachedWithId(Node node, String id, ClientDocumentStfulDelegateImpl clientDoc) {
        NodeCacheRegistryImpl nodeCache = clientDoc.getNodeCacheRegistry();
        Node nodeCached = nodeCache.getNodeById(id);
        return node == nodeCached;
    }

    public boolean preventiveNodeCaching(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        return this.preventiveNodeCaching((Node)obj);
    }

    public boolean preventiveNodeCaching(Node node) {
        if (node == null) {
            return false;
        }
        this.checkAllClientsCanReceiveScriptCode();
        ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
        if (!itsNatDoc.isNodeCacheEnabled()) {
            return false;
        }
        if (!NodeCacheRegistryImpl.isCacheableNode(node, itsNatDoc.getDocument())) {
            return false;
        }
        return this.preventiveNodeCaching2(node);
    }

    protected abstract boolean preventiveNodeCaching2(Node var1);

    protected boolean preventiveNodeCachingOneClient(Node node, ClientDocumentStfulDelegateImpl clientDoc) {
        NodeCacheRegistryImpl nodeCache = clientDoc.getNodeCacheRegistry();
        String oldId = nodeCache.getId(node);
        if (oldId != null) {
            return false;
        }
        ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
        String id = NodeCacheRegistryImpl.generateUniqueId(itsNatDoc);
        this.preventiveNodeCaching(node, id, clientDoc);
        return true;
    }

    protected boolean preventiveNodeCaching(Object[] nodes) {
        if (nodes == null) {
            return false;
        }
        boolean someOneCached = false;
        for (int i = 0; i < nodes.length; ++i) {
            if (!this.preventiveNodeCaching(nodes[i])) continue;
            someOneCached = true;
        }
        return someOneCached;
    }

    protected void preventiveNodeCaching(Node node, String id, ClientDocumentStfulDelegateImpl clientDoc) {
        NodeCacheRegistryImpl nodeCache = clientDoc.getNodeCacheRegistry();
        nodeCache.addNode(node, id);
        NodeLocationWithParentImpl nodeLoc = NodeLocationWithParentImpl.getNodeLocationWithParentUsingCache(node, id, true, nodeCache);
        if (!nodeLoc.isJustCached()) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        clientDoc.addCodeToSend(this.renderAddNodeToCache(nodeLoc));
    }

    @Override
    public String getCallMethodCode(Object obj, String methodName, Object[] params) {
        return this.getCallMethodCode(obj, methodName, params, false);
    }

    @Override
    public String getCallMethodCode(Object obj, String methodName, Object[] params, boolean endSentence) {
        this.preventiveNodeCaching(obj);
        this.preventiveNodeCaching(params);
        ClientDocumentStfulDelegateImpl clientDoc = this.getCurrentClientDocumentStfulDelegate();
        return this.renderGetCallMethodCode(obj, methodName, params, endSentence, clientDoc);
    }

    @Override
    public String getSetPropertyCode(Object obj, String propertyName, Object value) {
        return this.getSetPropertyCode(obj, propertyName, value, false);
    }

    @Override
    public String getGetPropertyCode(Object obj, String propertyName) {
        return this.getGetPropertyCode(obj, propertyName, false);
    }

    @Override
    public String getGetPropertyCode(Object obj, String propertyName, boolean endSentence) {
        this.preventiveNodeCaching(obj);
        ClientDocumentStfulDelegateImpl clientDoc = this.getCurrentClientDocumentStfulDelegate();
        return this.renderGetPropertyCode(obj, propertyName, endSentence, clientDoc);
    }

    @Override
    public String getSetPropertyCode(Object obj, String propertyName, Object value, boolean endSentence) {
        this.preventiveNodeCaching(obj);
        this.preventiveNodeCaching(value);
        ClientDocumentStfulDelegateImpl clientDoc = this.getCurrentClientDocumentStfulDelegate();
        return this.renderSetPropertyCode(obj, propertyName, value, endSentence, false, clientDoc);
    }

    @Override
    public String toScript(Object value) {
        this.preventiveNodeCaching(value);
        ClientDocumentStfulDelegateImpl clientDoc = this.getCurrentClientDocumentStfulDelegate();
        return this.javaToScript(value, clientDoc);
    }

    @Override
    public ScriptExpr createScriptExpr(Object value) {
        return new ScriptExprImpl(value, this);
    }

    protected abstract String renderAddNodeToCache(NodeLocationWithParentImpl var1);

    public abstract ClientDocumentStfulDelegateImpl getCurrentClientDocumentStfulDelegate();

    public abstract ItsNatStfulDocumentImpl getItsNatStfulDocument();

    protected abstract String renderGetCallMethodCode(Object var1, String var2, Object[] var3, boolean var4, ClientDocumentStfulDelegateImpl var5);

    protected abstract String renderSetPropertyCode(Object var1, String var2, Object var3, boolean var4, boolean var5, ClientDocumentStfulDelegateImpl var6);

    protected abstract String renderGetPropertyCode(Object var1, String var2, boolean var3, ClientDocumentStfulDelegateImpl var4);

    protected abstract String javaToScript(Object var1, ClientDocumentStfulDelegateImpl var2);
}

