/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.scriptren.shared;

import org.itsnat.core.script.ScriptExpr;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.browser.droid.BrowserDroid;
import org.itsnat.impl.core.browser.web.BrowserAdobeSVG;
import org.itsnat.impl.core.browser.web.BrowserMSIEOld;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.scriptren.shared.ScriptReference;
import org.w3c.dom.Node;

public class JSAndBSRenderImpl {
    private static final String JS_RELOAD_CODE_NORMAL = "if (document.itsNatDoc) document.itsNatDoc.disabledEvents=true; window.location.reload(true);\n";
    private static final String JS_RELOAD_CODE_AdobeSVG = "window.location.href = window.location.href;";

    public static String getReloadCode(Browser browser) {
        if (browser instanceof BrowserWeb) {
            if (browser instanceof BrowserAdobeSVG) {
                return JS_RELOAD_CODE_AdobeSVG;
            }
            return JS_RELOAD_CODE_NORMAL;
        }
        if (browser instanceof BrowserDroid) {
            return "itsNatDoc.setDisabledEvents(); itsNatDoc.onServerStateLost();";
        }
        return null;
    }

    public static String toLiteralStringScript(String value) {
        value = value == null ? "null" : "\"" + value + "\"";
        return value;
    }

    public static String toTransportableStringLiteral(String text, boolean addQuotation, Browser browser) {
        StringBuilder encoded = new StringBuilder(text);
        block10: for (int i = 0; i < encoded.length(); ++i) {
            char c = encoded.charAt(i);
            switch (c) {
                case '\r': {
                    encoded.deleteCharAt(i);
                    --i;
                    continue block10;
                }
                case '\n': {
                    encoded.deleteCharAt(i);
                    if (browser instanceof BrowserMSIEOld) {
                        encoded.insert(i, "\\r");
                        i += 2;
                    }
                    encoded.insert(i, "\\n");
                    ++i;
                    continue block10;
                }
                case '\"': {
                    encoded.deleteCharAt(i);
                    encoded.insert(i, "\\\"");
                    ++i;
                    continue block10;
                }
                case '\'': {
                    if (addQuotation) continue block10;
                    encoded.deleteCharAt(i);
                    encoded.insert(i, "\\'");
                    ++i;
                    continue block10;
                }
                case '\\': {
                    encoded.deleteCharAt(i);
                    encoded.insert(i, "\\\\");
                    ++i;
                    continue block10;
                }
                case '\t': {
                    encoded.deleteCharAt(i);
                    encoded.insert(i, "\\t");
                    ++i;
                    continue block10;
                }
                case '\f': {
                    encoded.deleteCharAt(i);
                    encoded.insert(i, "\\f");
                    ++i;
                    continue block10;
                }
                case '\b': {
                    encoded.deleteCharAt(i);
                    encoded.insert(i, "\\b");
                    ++i;
                }
            }
        }
        if (addQuotation) {
            if (encoded.indexOf("</script>") != -1) {
                String encoded2 = encoded.toString().replaceAll("</script>", "</\" + \"script>");
                return "\"" + encoded2 + "\"";
            }
            return "\"" + encoded + "\"";
        }
        return encoded.toString();
    }

    public static String toTransportableStringLiteral(String text, Browser browser) {
        return JSAndBSRenderImpl.toTransportableStringLiteral(text, true, browser);
    }

    public static String getTransportableCharLiteral(char c, Browser browser) {
        if (c == '\r') {
            return "'\r'";
        }
        String encoded = JSAndBSRenderImpl.toTransportableStringLiteral(Character.toString(c), browser);
        return "'" + encoded + "'";
    }

    public static String javaToScript(Object value, boolean cacheIfPossible, ClientDocumentStfulDelegateImpl clientDoc) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Node) {
            return clientDoc.getNodeReference((Node)value, cacheIfPossible, true);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Character) {
            return JSAndBSRenderImpl.getTransportableCharLiteral(((Character)value).charValue(), clientDoc.getBrowser());
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof ScriptExpr) {
            return ((ScriptExpr)value).getCode();
        }
        if (value instanceof ScriptReference) {
            return ((ScriptReference)value).getCode();
        }
        if (value instanceof String) {
            return JSAndBSRenderImpl.toTransportableStringLiteral((String)value, clientDoc.getBrowser());
        }
        return value.toString();
    }

    public static String getSetPropertyCode(Object object, String propertyName, Object value, boolean endSentence, boolean cacheIfPossible, ClientDocumentStfulDelegateImpl clientDoc) {
        StringBuilder code = new StringBuilder();
        code.append(JSAndBSRenderImpl.javaToScript(object, cacheIfPossible, clientDoc) + "." + propertyName + "=" + JSAndBSRenderImpl.javaToScript(value, cacheIfPossible, clientDoc));
        if (endSentence) {
            code.append(";");
        }
        return code.toString();
    }

    public static String getGetPropertyCode(Object object, String propertyName, boolean endSentence, boolean cacheIfPossible, ClientDocumentStfulDelegateImpl clientDoc) {
        StringBuilder code = new StringBuilder();
        code.append(JSAndBSRenderImpl.javaToScript(object, cacheIfPossible, clientDoc) + "." + propertyName);
        if (endSentence) {
            code.append(";");
        }
        return code.toString();
    }
}

