/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.scriptren.jsren.node.html.w3c;

import java.util.HashMap;
import java.util.Map;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.NameValue;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.w3c.dom.Node;

public class JSRenderNodeRegistryByClientImpl {
    protected ClientDocumentStfulDelegateWebImpl clientDoc;
    protected String prefix;
    protected Map<String, Node> idMap = new HashMap<String, Node>();
    protected Map<Node, NameValue> nodeMap = new HashMap<Node, NameValue>();

    public JSRenderNodeRegistryByClientImpl(String prefix, ClientDocumentStfulDelegateWebImpl clientDoc) {
        this.prefix = prefix;
        this.clientDoc = clientDoc;
    }

    public String registerNode(Node node) {
        String id = this.clientDoc.getClientDocumentStful().getUniqueIdGenerator().generateId(this.prefix);
        NameValue pair = new NameValue(id, null);
        if (this.idMap.put(id, node) != null) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        if (this.nodeMap.put(node, pair) != null) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        return id;
    }

    public String unRegisterNode(Node node) {
        return this.unRegisterNode(node, true);
    }

    public String unRegisterNode(Node node, boolean throwErr) {
        NameValue pair = this.nodeMap.remove(node);
        String id = pair.getName();
        if (this.idMap.remove(id) == null && throwErr) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        return id;
    }

    public Node getNodeById(String id) {
        return this.idMap.get(id);
    }

    public String getIdByNode(Node node) {
        NameValue pair = this.nodeMap.get(node);
        if (pair == null) {
            return null;
        }
        return pair.getName();
    }

    public NameValue getNameValueByNode(Node node) {
        return this.nodeMap.get(node);
    }
}

