/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.scriptren.jsren.node;

import java.util.LinkedList;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.domutil.DOMUtilHTML;
import org.itsnat.impl.core.domutil.NamespaceUtil;
import org.itsnat.impl.core.scriptren.jsren.JSRenderImpl;
import org.itsnat.impl.core.scriptren.jsren.node.PropertyImpl;
import org.itsnat.impl.core.scriptren.jsren.node.html.JSRenderHTMLPropertyImpl;
import org.itsnat.impl.core.scriptren.jsren.node.otherns.JSRenderXULPropertyImpl;
import org.itsnat.impl.core.util.MapListImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public abstract class JSRenderPropertyImpl {
    protected final MapListImpl<String, PropertyImpl> propertiesByTagName = new MapListImpl();

    public static JSRenderPropertyImpl getJSRenderProperty(Element elem, Browser browser) {
        if (JSRenderPropertyImpl.isHTMLProperty(elem)) {
            return JSRenderHTMLPropertyImpl.getJSRenderHTMLProperty(browser);
        }
        String namespace = elem.getNamespaceURI();
        if (namespace != null) {
            if (NamespaceUtil.isXULNamespace(namespace)) {
                return JSRenderXULPropertyImpl.SINGLETON;
            }
            return null;
        }
        return null;
    }

    public static PropertyImpl getProperty(Element elem, String attrName, Browser browser) {
        JSRenderPropertyImpl render = JSRenderPropertyImpl.getJSRenderProperty(elem, browser);
        if (render == null) {
            return null;
        }
        return render.getProperty(elem, attrName);
    }

    public static boolean isHTMLProperty(Element elem) {
        return DOMUtilHTML.isHTMLElement(elem);
    }

    protected void addProperty(String localName, String propName, int type) {
        this.addProperty(localName, propName, propName, type, null);
    }

    protected void addProperty(String localName, String propName, String attrName, int type) {
        this.addProperty(localName, propName, attrName, type, null);
    }

    protected void addProperty(String localName, String propName, String attrName, int type, String nullValue) {
        PropertyImpl property = new PropertyImpl(this, propName, attrName, type, nullValue);
        this.propertiesByTagName.add(localName, property);
    }

    public PropertyImpl getProperty(Element elem, String attrName) {
        String localNameElem = elem.getLocalName();
        LinkedList<PropertyImpl> propList = this.propertiesByTagName.get(localNameElem);
        if (propList == null) {
            return null;
        }
        String attrNameLower = attrName.toLowerCase();
        if (propList.size() == 1) {
            PropertyImpl prop = propList.getFirst();
            if (prop.getAttributeNameLower().equals(attrNameLower)) {
                return prop;
            }
        } else {
            for (PropertyImpl prop : propList) {
                if (!prop.getAttributeNameLower().equals(attrNameLower)) continue;
                return prop;
            }
        }
        return null;
    }

    protected String attrValueJSToPropValueJS(PropertyImpl prop, boolean setValue, String attrValueJS, String value) {
        String propValueJS;
        int type = prop.getType();
        if (setValue) {
            switch (type) {
                case 1: {
                    propValueJS = "true";
                    break;
                }
                case 2: {
                    propValueJS = attrValueJS;
                    break;
                }
                case 3: {
                    propValueJS = "parseInt(" + attrValueJS + ")";
                    break;
                }
                default: {
                    propValueJS = null;
                    break;
                }
            }
        } else {
            propValueJS = prop.getNullValue();
        }
        return propValueJS;
    }

    public String renderRemoveProperty(PropertyImpl prop, Element elem, String elemVarName, ClientDocumentStfulDelegateWebImpl clientDoc) {
        return this.renderProperty(prop, elem, elemVarName, null, null, false, clientDoc);
    }

    public String renderSetProperty(PropertyImpl prop, Element elem, String elemVarName, String attrValueJS, String value, ClientDocumentStfulDelegateImpl clientDoc) {
        return this.renderProperty(prop, elem, elemVarName, attrValueJS, value, true, clientDoc);
    }

    protected String renderProperty(PropertyImpl prop, Element elem, String elemVarName, String attrValueJS, String value, boolean setValue, ClientDocumentStfulDelegateImpl clientDoc) {
        String propName = prop.getPropertyName();
        String propValueJS = this.attrValueJSToPropValueJS(prop, setValue, attrValueJS, value);
        return elemVarName + "." + propName + " = " + propValueJS + ";\n";
    }

    public String renderAttrAsProperty(PropertyImpl prop, Element elem, String elemVarName, ClientDocumentStfulDelegateWebImpl clientDoc) {
        Attr attr = elem.getAttributeNode(prop.getAttributeName());
        if (attr != null) {
            String value = attr.getValue();
            String attrValueJS = JSRenderImpl.toTransportableStringLiteral(value, clientDoc.getBrowserWeb());
            return this.renderSetProperty(prop, elem, elemVarName, attrValueJS, value, clientDoc);
        }
        return this.renderRemoveProperty(prop, elem, elemVarName, clientDoc);
    }

    public static String renderUIControlProperty(Element elem, String elemVarName, String attrName, ClientDocumentStfulDelegateWebImpl clientDoc) {
        JSRenderPropertyImpl render = JSRenderPropertyImpl.getJSRenderProperty(elem, clientDoc.getBrowserWeb());
        if (render == null) {
            return "";
        }
        PropertyImpl prop = render.getProperty(elem, attrName);
        return render.renderAttrAsProperty(prop, elem, elemVarName, clientDoc);
    }
}

