/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.scriptren.jsren.node;

import java.util.Iterator;
import java.util.LinkedList;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.dompath.NodeLocationImpl;
import org.itsnat.impl.core.scriptren.jsren.JSRenderImpl;
import org.itsnat.impl.core.scriptren.jsren.event.JSRenderEventImpl;
import org.itsnat.impl.core.scriptren.jsren.node.JSRenderAbstractViewImpl;
import org.itsnat.impl.core.scriptren.jsren.node.JSRenderNotAttrOrAbstractViewNodeImpl;
import org.itsnat.impl.core.scriptren.shared.node.JSAndBSRenderNodeImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.views.DocumentView;

public abstract class JSRenderNodeImpl
extends JSRenderImpl {
    public static JSRenderNodeImpl getJSRenderNode(Node node, ClientDocumentStfulDelegateWebImpl clientDoc) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 2: {
                throw new ItsNatException("INTERNAL ERROR");
            }
            case -1: {
                return JSRenderAbstractViewImpl.SINGLETON;
            }
        }
        return JSRenderNotAttrOrAbstractViewNodeImpl.getJSRenderNotAttrOrAbstractViewNode(node, clientDoc);
    }

    public static String addNodeToCache(NodeLocationImpl nodeLoc) {
        return JSAndBSRenderNodeImpl.addNodeToCache(nodeLoc);
    }

    public static String removeNodeFromCache(String id) {
        return "itsNatDoc.removeNodeCache([" + JSRenderNodeImpl.toLiteralStringJS(id) + "]);\n";
    }

    public static String removeNodeFromCache(LinkedList<String> idList) {
        StringBuilder code = new StringBuilder();
        Iterator it = idList.iterator();
        while (it.hasNext()) {
            String id = JSRenderNodeImpl.toLiteralStringJS((String)it.next());
            if (code.length() > 0) {
                code.append("," + id);
                continue;
            }
            code.append(id);
        }
        return "itsNatDoc.removeNodeCache([" + code.toString() + "]);\n";
    }

    public static String getNodeReference(Node node, boolean cacheIfPossible, boolean errIfNull, ClientDocumentStfulDelegateImpl clientDoc) {
        if (node == null) {
            if (errIfNull) {
                throw new ItsNatException("No specified node");
            }
            return "null";
        }
        ItsNatStfulDocumentImpl itsNatDoc = clientDoc.getItsNatStfulDocument();
        Document doc = itsNatDoc.getDocument();
        if (node == ((DocumentView)((Object)doc)).getDefaultView()) {
            return "itsNatDoc.win";
        }
        if (node == doc) {
            return "itsNatDoc.doc";
        }
        if (node == doc.getDoctype()) {
            return "itsNatDoc.doc.doctype";
        }
        if (node == doc.getDocumentElement()) {
            return "itsNatDoc.doc.documentElement";
        }
        NodeLocationImpl nodeLoc = clientDoc.getNodeLocation(node, cacheIfPossible);
        return JSRenderNodeImpl.getNodeReference(nodeLoc, errIfNull);
    }

    public static String getNodeReference(NodeLocationImpl nodeLoc, boolean errIfNull) {
        String nodeRef = JSAndBSRenderNodeImpl.getNodeLocation(nodeLoc, errIfNull);
        return "itsNatDoc.getNode(" + nodeRef + ")";
    }

    public static String getSetNodePropertyCode(Node node, String propertyName, String value, boolean cacheIfPossible, ClientDocumentStfulDelegateWebImpl clientDoc) {
        return clientDoc.getNodeReference(node, cacheIfPossible, true) + "." + propertyName + "=" + JSRenderNodeImpl.toTransportableStringLiteral(value, clientDoc.getBrowserWeb()) + ";\n";
    }

    public static String getGetNodePropertyCode(Node object, String propertyName, boolean cacheIfPossible, ClientDocumentStfulDelegateWebImpl clientDoc) {
        return clientDoc.getNodeReference(object, cacheIfPossible, true) + "." + propertyName;
    }

    public static String getCodeDispatchEvent(EventTarget node, Event evt, String varResName, ClientDocumentStfulDelegateWebImpl clientDoc) {
        JSRenderEventImpl evtRender = JSRenderEventImpl.getJSEventRender(evt, clientDoc.getBrowserWeb());
        NodeLocationImpl nodeLoc = clientDoc.getNodeLocation((Node)((Object)node), true);
        return evtRender.getDispatchEvent(varResName, nodeLoc, evt, clientDoc);
    }
}

