/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.scriptren.jsren.node;

import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.domutil.DOMUtilHTML;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.itsnat.impl.core.scriptren.jsren.node.JSRenderAttributeImpl;
import org.itsnat.impl.core.scriptren.jsren.node.JSRenderHasChildrenNodeImpl;
import org.itsnat.impl.core.scriptren.jsren.node.html.JSRenderHTMLElementImpl;
import org.itsnat.impl.core.scriptren.jsren.node.otherns.JSRenderOtherNSElementImpl;
import org.itsnat.impl.core.scriptren.shared.node.CannotInsertAsMarkupCauseImpl;
import org.itsnat.impl.core.scriptren.shared.node.InnerMarkupCodeImpl;
import org.itsnat.impl.core.scriptren.shared.node.InsertAsMarkupInfoImpl;
import org.itsnat.impl.core.scriptren.shared.node.JSAndBSRenderElementImpl;
import org.itsnat.impl.core.scriptren.shared.node.RenderElement;
import org.itsnat.impl.core.template.MarkupTemplateVersionImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class JSRenderElementImpl
extends JSRenderHasChildrenNodeImpl
implements RenderElement {
    public static JSRenderElementImpl getJSRenderElement(Element elem, ClientDocumentStfulDelegateWebImpl clientDoc) {
        if (DOMUtilHTML.isHTMLElement(elem)) {
            return JSRenderHTMLElementImpl.getJSRenderHTMLElement(clientDoc.getBrowserWeb());
        }
        return JSRenderOtherNSElementImpl.getJSRenderOtherNSElement(elem, clientDoc);
    }

    @Override
    public String createNodeCode(Node node, ClientDocumentStfulDelegateImpl clientDoc) {
        Element nodeElem = (Element)node;
        return this.createElement(nodeElem, clientDoc);
    }

    protected String createElement(Element nodeElem, ClientDocumentStfulDelegateImpl clientDoc) {
        String tagName = nodeElem.getTagName();
        return this.createElement(nodeElem, tagName, clientDoc);
    }

    protected String createElement(Element nodeElem, String tagName, ClientDocumentStfulDelegateImpl clientDoc) {
        return "itsNatDoc.doc.createElement(\"" + tagName + "\")";
    }

    @Override
    public String addAttributesBeforeInsertNode(Node node, String elemVarName, ClientDocumentStfulDelegateImpl clientDoc) {
        ClientDocumentStfulDelegateWebImpl clientDocWeb = (ClientDocumentStfulDelegateWebImpl)clientDoc;
        Element elem = (Element)node;
        StringBuilder code = new StringBuilder();
        NamedNodeMap attribList = elem.getAttributes();
        for (int i = 0; i < attribList.getLength(); ++i) {
            Attr attr = (Attr)attribList.item(i);
            JSRenderAttributeImpl render = JSRenderAttributeImpl.getJSRenderAttribute(attr, elem, clientDocWeb);
            code.append(render.setAttributeCode(attr, elem, elemVarName, true, clientDoc));
        }
        return code.toString();
    }

    @Override
    public Object appendChildNodes(Node parent, String parentVarName, boolean beforeParent, InsertAsMarkupInfoImpl insertMarkupInfo, ClientDocumentStfulDelegateImpl clientDoc) {
        CannotInsertAsMarkupCauseImpl cannotInsertMarkup = this.canInsertAllChildrenAsMarkup((Element)parent, clientDoc.getItsNatStfulDocument().getItsNatStfulDocumentTemplateVersion(), insertMarkupInfo);
        if (cannotInsertMarkup == null) {
            InnerMarkupCodeImpl innerMarkup = this.appendChildrenAsMarkup(parentVarName, parent, clientDoc);
            return innerMarkup;
        }
        InsertAsMarkupInfoImpl insertMarkupInfoNextLevel = cannotInsertMarkup.createInsertAsMarkupInfoNextLevel();
        return super.appendChildNodes(parent, parentVarName, beforeParent, insertMarkupInfoNextLevel, clientDoc);
    }

    @Override
    public Object getInsertNewNodeCode(Node newNode, ClientDocumentStfulDelegateWebImpl clientDoc) {
        CannotInsertAsMarkupCauseImpl cannotInsertMarkup = this.canInsertSingleChildNodeAsMarkup(newNode, clientDoc);
        if (cannotInsertMarkup == null) {
            return this.appendSingleChildNodeAsMarkup(newNode, clientDoc);
        }
        InsertAsMarkupInfoImpl insertMarkupInfoNextLevel = cannotInsertMarkup.createInsertAsMarkupInfoNextLevel();
        return super.getInsertNewNodeCode(newNode, insertMarkupInfoNextLevel, clientDoc);
    }

    private CannotInsertAsMarkupCauseImpl canInsertSingleChildNodeAsMarkup(Node newChildNode, ClientDocumentStfulDelegateWebImpl clientDoc) {
        return JSAndBSRenderElementImpl.canInsertSingleChildNodeAsMarkup(newChildNode, clientDoc, this);
    }

    private InnerMarkupCodeImpl appendSingleChildNodeAsMarkup(Node newNode, ClientDocumentStfulDelegateWebImpl clientDoc) {
        return JSAndBSRenderElementImpl.appendSingleChildNodeAsMarkup(newNode, clientDoc, (RenderElement)this);
    }

    private InnerMarkupCodeImpl appendChildrenAsMarkup(String parentVarName, Node parentNode, ClientDocumentStfulDelegateImpl clientDoc) {
        return JSAndBSRenderElementImpl.appendChildrenAsMarkup(parentVarName, parentNode, clientDoc, this);
    }

    @Override
    public boolean match(Node node, Object context) {
        return this.isChildNotValidInsertedAsMarkup(node, (MarkupTemplateVersionImpl)context);
    }

    public abstract boolean isChildNotValidInsertedAsMarkup(Node var1, MarkupTemplateVersionImpl var2);

    @Override
    public CannotInsertAsMarkupCauseImpl canInsertChildNodeAsMarkupIgnoringOther(Element parent, Node childNode, MarkupTemplateVersionImpl template) {
        return JSAndBSRenderElementImpl.canInsertChildNodeAsMarkupIgnoringOther(parent, childNode, template, this);
    }

    public boolean canInsertAllChildrenAsMarkup(Element parent, MarkupTemplateVersionImpl template) {
        CannotInsertAsMarkupCauseImpl cannotInsertMarkup = this.canInsertAllChildrenAsMarkup(parent, template, null);
        return cannotInsertMarkup == null;
    }

    public CannotInsertAsMarkupCauseImpl canInsertAllChildrenAsMarkup(Element parent, MarkupTemplateVersionImpl template, InsertAsMarkupInfoImpl insertMarkupInfo) {
        return JSAndBSRenderElementImpl.canInsertAllChildrenAsMarkup(parent, template, insertMarkupInfo, this);
    }

    @Override
    public Node getFirstChildIsNotValidInsertedAsMarkup(Element parent, MarkupTemplateVersionImpl template) {
        return DOMUtilInternal.getFirstContainedNodeMatching(parent, this, template);
    }

    @Override
    public InnerMarkupCodeImpl appendChildrenCodeAsMarkup(String parentVarName, Element parentNode, String childrenCode, ClientDocumentStfulDelegateImpl clientDoc) {
        return JSAndBSRenderElementImpl.createInnerMarkupCode(parentVarName, parentNode, childrenCode, clientDoc, this);
    }

    public abstract String getCurrentStyleObject(String var1, String var2, ClientDocumentStfulDelegateWebImpl var3);

    protected String bindBackupAndSetStylePropertyMethod(String methodName, ClientDocumentStfulDelegateWebImpl clientDoc) {
        StringBuilder code = new StringBuilder();
        code.append("var func = function (elem,propName,newValue)");
        code.append("{");
        code.append("  if (typeof elem.style == \"undefined\") return;");
        code.append("  var name = \"style_itsnat_\" + propName;");
        code.append("  var cssProp = elem.style[propName];");
        code.append("  if (typeof cssProp == \"undefined\") cssProp = \"\";");
        code.append("  this.setPropInNative(elem,name,cssProp);");
        code.append("  elem.style[propName] = newValue;");
        code.append("};");
        code.append("itsNatDoc." + methodName + " = func;\n");
        clientDoc.bindClientMethod(methodName);
        return code.toString();
    }

    public String getBackupAndSetStylePropertyMethodName() {
        return "backupSetStyleProp";
    }

    public String bindBackupAndSetStylePropertyMethod(ClientDocumentStfulDelegateWebImpl clientDoc) {
        StringBuilder code = new StringBuilder();
        String methodName = this.getBackupAndSetStylePropertyMethodName();
        if (!clientDoc.isClientMethodBounded(methodName)) {
            code.append(this.bindBackupAndSetStylePropertyMethod(methodName, clientDoc));
        }
        return code.toString();
    }

    public String getBackupAndSetStyleProperty(String elemVarName, String propName, String newValue, ClientDocumentStfulDelegateWebImpl clientDoc) {
        StringBuilder code = new StringBuilder();
        String methodName = this.getBackupAndSetStylePropertyMethodName();
        if (!clientDoc.isClientMethodBounded(methodName)) {
            code.append(this.bindBackupAndSetStylePropertyMethod(methodName, clientDoc));
        }
        code.append("itsNatDoc." + methodName + "(" + elemVarName + ",\"" + propName + "\",\"" + newValue + "\");\n");
        return code.toString();
    }

    protected String bindRestoreBackupStylePropertyMethod(String methodName, ClientDocumentStfulDelegateWebImpl clientDoc) {
        StringBuilder code = new StringBuilder();
        code.append("var func = function (elem,propName)");
        code.append("{");
        code.append("  if (typeof elem.style == \"undefined\") return;");
        code.append("  var name = \"style_itsnat_\" + propName;");
        code.append("  var cssProp = this.getPropInNative(elem,name);\n");
        code.append("  if (cssProp == null) return;\n");
        code.append("  elem.style[propName] = cssProp;\n");
        code.append("  this.removePropInNative(elem,name);\n");
        code.append("};");
        code.append("itsNatDoc." + methodName + " = func;\n");
        clientDoc.bindClientMethod(methodName);
        return code.toString();
    }

    public String getRestoreBackupPropertyMethodName() {
        return "restoreBackupStyleProp";
    }

    public String bindRestoreBackupStylePropertyMethod(ClientDocumentStfulDelegateWebImpl clientDoc) {
        StringBuilder code = new StringBuilder();
        String methodName = this.getRestoreBackupPropertyMethodName();
        if (!clientDoc.isClientMethodBounded(methodName)) {
            code.append(this.bindRestoreBackupStylePropertyMethod(methodName, clientDoc));
        }
        return code.toString();
    }

    public String getRestoreBackupStyleProperty(String elemVarName, String propName, ClientDocumentStfulDelegateWebImpl clientDoc) {
        StringBuilder code = new StringBuilder();
        String methodName = this.getRestoreBackupPropertyMethodName();
        if (!clientDoc.isClientMethodBounded(methodName)) {
            code.append(this.bindRestoreBackupStylePropertyMethod(methodName, clientDoc));
        }
        code.append("itsNatDoc." + methodName + "(" + elemVarName + ",\"" + propName + "\");\n");
        return code.toString();
    }

    public abstract boolean isInsertedScriptNotExecuted(Element var1, ClientDocumentStfulDelegateImpl var2);

    public abstract boolean isTextAddedToInsertedScriptNotExecuted(Element var1, ClientDocumentStfulDelegateWebImpl var2);

    public boolean isScriptWithContent(Node newNode) {
        return newNode.hasChildNodes() && newNode.getLocalName().equals("script");
    }

    public boolean isScriptWithSingleChildTextNode(Node newNode) {
        return this.isScriptWithContent(newNode) && newNode.getFirstChild() == newNode.getLastChild() && newNode.getFirstChild() instanceof CharacterData;
    }

    @Override
    public String getAppendCompleteChildNode(String parentVarName, Node newNode, String newNodeCode, ClientDocumentStfulDelegateImpl clientDoc) {
        if (this.isScriptWithSingleChildTextNode(newNode) && this.isInsertedScriptNotExecuted((Element)newNode, clientDoc)) {
            StringBuilder code = new StringBuilder();
            code.append(super.getAppendCompleteChildNode(parentVarName, newNode, newNodeCode, clientDoc));
            code.append("eval(" + newNodeCode + ".firstChild.data);");
            return code.toString();
        }
        return super.getAppendCompleteChildNode(parentVarName, newNode, newNodeCode, clientDoc);
    }

    @Override
    public String getInsertCompleteNodeCode(Node newNode, String newNodeCode, ClientDocumentStfulDelegateImpl clientDoc) {
        if (this.isScriptWithSingleChildTextNode(newNode) && this.isInsertedScriptNotExecuted((Element)newNode, clientDoc)) {
            StringBuilder code = new StringBuilder();
            code.append(super.getInsertCompleteNodeCode(newNode, newNodeCode, clientDoc));
            code.append("eval(" + newNodeCode + ".firstChild.data);");
            return code.toString();
        }
        return super.getInsertCompleteNodeCode(newNode, newNodeCode, clientDoc);
    }

    @Override
    public boolean isAddChildNodesBeforeNode(Node parent, ClientDocumentStfulDelegateImpl clientDoc) {
        return this.isScriptWithContent(parent);
    }
}

