/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.scriptren.jsren.node;

import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.scriptren.jsren.node.JSRenderCharacterDataImpl;
import org.itsnat.impl.core.scriptren.jsren.node.JSRenderElementImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class JSRenderCharacterDataAliveImpl
extends JSRenderCharacterDataImpl {
    public boolean isScriptContent(Node newNode) {
        Node parentNode = newNode.getParentNode();
        return parentNode instanceof Element && parentNode.getLocalName().equals("script");
    }

    @Override
    public String getInsertCompleteNodeCode(Node newNode, String newNodeCode, ClientDocumentStfulDelegateImpl clientDoc) {
        if (this.isScriptContent(newNode)) {
            ClientDocumentStfulDelegateWebImpl clientDocWeb = (ClientDocumentStfulDelegateWebImpl)clientDoc;
            StringBuilder code = new StringBuilder();
            if (newNodeCode.startsWith("itsNatDoc.doc.createTextNode(") || newNodeCode.startsWith("itsNatDoc.doc.createCDATASection(")) {
                code.append("var textNode = " + newNodeCode + ";\n");
            } else if (newNode instanceof Text) {
                code.append("var textNode = itsNatDoc.doc.createTextNode(" + newNodeCode + ");\n");
            } else {
                code.append("var textNode = itsNatDoc.doc.createCDATASection(" + newNodeCode + ");\n");
            }
            code.append(super.getInsertCompleteNodeCode(newNode, "textNode", clientDoc));
            Element script = (Element)newNode.getParentNode();
            JSRenderElementImpl elemRender = JSRenderElementImpl.getJSRenderElement(script, clientDocWeb);
            if (elemRender.isInsertedScriptNotExecuted(script, clientDoc)) {
                code.append("eval(textNode.data);\n");
            } else if (elemRender.isTextAddedToInsertedScriptNotExecuted(script, clientDocWeb)) {
                String method = "fixScriptTextNode";
                if (!clientDocWeb.isClientMethodBounded(method)) {
                    code.append("var func = function (textNode)");
                    code.append("{");
                    code.append("  var elem = textNode.parentNode;\n");
                    code.append("  var elemClone = elem.cloneNode(false);\n");
                    code.append("  elem.parentNode.replaceChild(elemClone,elem);\n");
                    code.append("  elemClone.parentNode.replaceChild(elem,elemClone);\n");
                    code.append("};");
                    code.append("itsNatDoc." + method + " = func;\n");
                    clientDocWeb.bindClientMethod(method);
                }
                code.append("itsNatDoc." + method + "(textNode);\n");
            }
            return code.toString();
        }
        return super.getInsertCompleteNodeCode(newNode, newNodeCode, clientDoc);
    }
}

