/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.scriptren.jsren.node;

import org.itsnat.impl.core.clientdoc.ClientDocumentAttachedClientImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulOwnerImpl;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.doc.BoundElementDocContainerImpl;
import org.itsnat.impl.core.doc.ElementDocContainerWrapperImpl;
import org.itsnat.impl.core.domimpl.ElementDocContainer;
import org.itsnat.impl.core.dompath.NodeLocationImpl;
import org.itsnat.impl.core.domutil.DOMUtilHTML;
import org.itsnat.impl.core.scriptren.jsren.node.JSRenderNodeImpl;
import org.itsnat.impl.core.scriptren.jsren.node.JSRenderPropertyImpl;
import org.itsnat.impl.core.scriptren.jsren.node.PropertyImpl;
import org.itsnat.impl.core.scriptren.jsren.node.html.JSRenderHTMLAttributeImpl;
import org.itsnat.impl.core.scriptren.jsren.node.otherns.JSRenderOtherNSAttributeImpl;
import org.itsnat.impl.core.scriptren.shared.node.NodeScriptRefImpl;
import org.itsnat.impl.core.scriptren.shared.node.RenderAttribute;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public abstract class JSRenderAttributeImpl
extends JSRenderNodeImpl
implements RenderAttribute {
    public static JSRenderAttributeImpl getJSRenderAttribute(String attrNamespaceURI, Element elem, ClientDocumentStfulDelegateWebImpl clientDoc) {
        if (DOMUtilHTML.isHTMLAttribute(attrNamespaceURI, elem)) {
            return JSRenderHTMLAttributeImpl.getJSRenderHTMLAttribute(clientDoc.getBrowserWeb());
        }
        return JSRenderOtherNSAttributeImpl.getJSRenderOtherNSAttribute(elem, clientDoc);
    }

    public static JSRenderAttributeImpl getJSRenderAttribute(Attr attr, Element elem, ClientDocumentStfulDelegateWebImpl clientDoc) {
        return JSRenderAttributeImpl.getJSRenderAttribute(attr.getNamespaceURI(), elem, clientDoc);
    }

    public abstract boolean isIgnored(Attr var1, Element var2);

    public String setAttributeCode(Attr attr, Element elem, boolean newElem, ClientDocumentStfulDelegateImpl clientDoc) {
        if (this.isIgnored(attr, elem)) {
            return "";
        }
        String attrName = attr.getName();
        String jsValue = this.toJSAttrValue(attr, elem, newElem, clientDoc);
        return this.setAttributeCode(attr, attrName, jsValue, elem, newElem, clientDoc);
    }

    public String setAttributeCode(Attr attr, Element elem, String elemVarName, boolean newElem, ClientDocumentStfulDelegateImpl clientDoc) {
        if (this.isIgnored(attr, elem)) {
            return "";
        }
        String attrName = attr.getName();
        String jsValue = this.toJSAttrValue(attr, elem, newElem, clientDoc);
        return this.setAttributeCode(attr, attrName, jsValue, elem, elemVarName, newElem, clientDoc);
    }

    public String removeAttributeCode(Attr attr, Element elem, ClientDocumentStfulDelegateWebImpl clientDoc) {
        if (this.isIgnored(attr, elem)) {
            return "";
        }
        String attrName = attr.getName();
        return this.removeAttributeCode(attr, attrName, elem, clientDoc);
    }

    protected String toJSAttrValue(String value, ClientDocumentStfulDelegateImpl clientDoc) {
        return JSRenderAttributeImpl.toTransportableStringLiteral(value, clientDoc.getBrowser());
    }

    protected String getAttrValue(Attr attr, Element elem, boolean newElem, ClientDocumentStfulDelegateImpl clientDoc) {
        BoundElementDocContainerImpl bindInfo;
        ElementDocContainer elemDocCont;
        if (!newElem && (elemDocCont = ElementDocContainerWrapperImpl.getElementDocContainerIfURLAttr(attr, elem)) != null && (bindInfo = elemDocCont.getElementDocContainerWrapper().getBoundElementDocContainer()) != null) {
            ClientDocumentStfulImpl clientDocParent = clientDoc.getClientDocumentStful();
            String value = clientDocParent instanceof ClientDocumentStfulOwnerImpl ? bindInfo.generateURLForClientOwner((ClientDocumentStfulOwnerImpl)clientDocParent) : bindInfo.generateURLForClientAttached((ClientDocumentAttachedClientImpl)clientDocParent);
            return value;
        }
        return attr.getValue();
    }

    protected String toJSAttrValue(Attr attr, Element elem, boolean newElem, ClientDocumentStfulDelegateImpl clientDoc) {
        String value = this.getAttrValue(attr, elem, newElem, clientDoc);
        return this.toJSAttrValue(value, clientDoc);
    }

    protected String setAttributeCode(Attr attr, String attrName, String jsValue, Element elem, boolean newElem, ClientDocumentStfulDelegateImpl clientDoc) {
        if (newElem) {
            return this.setAttributeOnlyCode(attr, attrName, jsValue, elem, newElem, clientDoc);
        }
        PropertyImpl prop = JSRenderPropertyImpl.getProperty(elem, attrName, clientDoc.getBrowser());
        if (prop != null) {
            return this.setAttributeWithProperty(attr, attrName, jsValue, elem, newElem, prop, clientDoc);
        }
        return this.setAttributeOnlyCode(attr, attrName, jsValue, elem, newElem, clientDoc);
    }

    protected String setAttributeCode(Attr attr, String attrName, String jsValue, Element elem, String elemVarName, boolean newElem, ClientDocumentStfulDelegateImpl clientDoc) {
        if (newElem) {
            return this.setAttributeOnlyCode(attr, attrName, jsValue, elem, elemVarName, newElem, clientDoc);
        }
        PropertyImpl prop = JSRenderPropertyImpl.getProperty(elem, attrName, clientDoc.getBrowser());
        if (prop != null) {
            return this.setAttributeWithProperty(attr, attrName, jsValue, elem, elemVarName, newElem, prop, clientDoc);
        }
        return this.setAttributeOnlyCode(attr, attrName, jsValue, elem, elemVarName, newElem, clientDoc);
    }

    protected String setAttributeOnlyCode(Attr attr, String attrName, String jsValue, Element elem, boolean newElem, ClientDocumentStfulDelegateImpl clientDoc) {
        NodeLocationImpl nodeLoc = clientDoc.getNodeLocation(elem, true);
        return this.setAttributeOnlyCode(attr, attrName, jsValue, new NodeScriptRefImpl(nodeLoc), newElem, clientDoc);
    }

    protected String setAttributeOnlyCode(Attr attr, String attrName, String jsValue, Element elem, String elemVarName, boolean newElem, ClientDocumentStfulDelegateImpl clientDoc) {
        return this.setAttributeOnlyCode(attr, attrName, jsValue, new NodeScriptRefImpl(elemVarName, clientDoc), newElem, clientDoc);
    }

    public String setAttributeOnlyCode(Attr attr, String attrName, String jsValue, NodeScriptRefImpl nodeRef, boolean newElem, ClientDocumentStfulDelegateImpl clientDoc) {
        if (nodeRef.getNodeRef() instanceof NodeLocationImpl) {
            NodeLocationImpl nodeLoc = (NodeLocationImpl)nodeRef.getNodeRef();
            return "itsNatDoc.setAttribute2(" + nodeLoc.toScriptNodeLocation(true) + ",\"" + attrName + "\"," + jsValue + ");\n";
        }
        String elemVarName = (String)nodeRef.getNodeRef();
        return "itsNatDoc.setAttribute(" + elemVarName + ",\"" + attrName + "\"," + jsValue + ");\n";
    }

    protected String removeAttributeCode(Attr attr, String attrName, Element elem, ClientDocumentStfulDelegateWebImpl clientDoc) {
        PropertyImpl prop = JSRenderPropertyImpl.getProperty(elem, attrName, clientDoc.getBrowserWeb());
        if (prop != null) {
            return this.removeAttributeWithProperty(attr, attrName, elem, prop, clientDoc);
        }
        return this.removeAttributeOnlyCode(attr, attrName, elem, clientDoc);
    }

    protected String removeAttributeOnlyCode(Attr attr, String attrName, Element elem, ClientDocumentStfulDelegateWebImpl clientDoc) {
        NodeLocationImpl nodeLoc = clientDoc.getNodeLocation(elem, true);
        return this.removeAttributeOnlyCode(attr, attrName, elem, new NodeScriptRefImpl(nodeLoc), clientDoc);
    }

    protected String removeAttributeOnlyCode(Attr attr, String attrName, Element elem, NodeScriptRefImpl nodeRef, ClientDocumentStfulDelegateWebImpl clientDoc) {
        if (nodeRef.getNodeRef() instanceof NodeLocationImpl) {
            NodeLocationImpl nodeLoc = (NodeLocationImpl)nodeRef.getNodeRef();
            return "itsNatDoc.removeAttribute2(" + nodeLoc.toScriptNodeLocation(true) + ",\"" + attrName + "\");\n";
        }
        String elemVarName = (String)nodeRef.getNodeRef();
        return "itsNatDoc.removeAttribute(" + elemVarName + ",\"" + attrName + "\");\n";
    }

    protected String removeAttributeWithProperty(Attr attr, String attrName, Element elem, PropertyImpl prop, ClientDocumentStfulDelegateWebImpl clientDoc) {
        StringBuilder code = new StringBuilder();
        code.append("var elem = " + clientDoc.getNodeReference(elem, true, true) + ";\n");
        code.append(this.removeAttributeWithProperty(attr, attrName, elem, "elem", prop, clientDoc));
        return code.toString();
    }

    protected String removeAttributeWithProperty(Attr attr, String attrName, Element elem, String elemVarName, PropertyImpl prop, ClientDocumentStfulDelegateWebImpl clientDoc) {
        StringBuilder code = new StringBuilder();
        JSRenderPropertyImpl render = prop.getJSRenderProperty();
        code.append(render.renderRemoveProperty(prop, elem, elemVarName, clientDoc));
        if (this.isRenderAttributeAlongsideProperty(attrName, elem)) {
            code.append(this.removeAttributeOnlyCode(attr, attrName, elem, new NodeScriptRefImpl(elemVarName, clientDoc), clientDoc));
        }
        return code.toString();
    }

    protected String setAttributeWithProperty(Attr attr, String attrName, String jsValue, Element elem, boolean newElem, PropertyImpl prop, ClientDocumentStfulDelegateImpl clientDoc) {
        StringBuilder code = new StringBuilder();
        code.append("var elem = " + clientDoc.getNodeReference(elem, true, true) + ";\n");
        code.append(this.setAttributeWithProperty(attr, attrName, jsValue, elem, "elem", newElem, prop, clientDoc));
        return code.toString();
    }

    protected String setAttributeWithProperty(Attr attr, String attrName, String jsValue, Element elem, String elemVarName, boolean newElem, PropertyImpl prop, ClientDocumentStfulDelegateImpl clientDoc) {
        if (this.isRenderAttributeAlongsideProperty(attrName, elem)) {
            StringBuilder code = new StringBuilder();
            code.append("var value = " + jsValue + ";\n");
            code.append(this.setAttributeAndProperty(attr, attrName, "value", elem, elemVarName, newElem, prop, clientDoc));
            return code.toString();
        }
        return this.renderSetProperty(attr, jsValue, elem, elemVarName, prop, clientDoc);
    }

    protected String setAttributeAndProperty(Attr attr, String attrName, String valueJS, Element elem, String elemVarName, boolean newElem, PropertyImpl prop, ClientDocumentStfulDelegateImpl clientDoc) {
        StringBuilder code = new StringBuilder();
        code.append(this.setAttributeOnlyCode(attr, attrName, valueJS, new NodeScriptRefImpl(elemVarName, clientDoc), newElem, clientDoc));
        code.append(this.renderSetProperty(attr, valueJS, elem, elemVarName, prop, clientDoc));
        return code.toString();
    }

    public String renderSetProperty(Attr attr, String valueJS, Element elem, String elemVarName, PropertyImpl prop, ClientDocumentStfulDelegateImpl clientDoc) {
        String value = attr.getValue();
        JSRenderPropertyImpl render = prop.getJSRenderProperty();
        return render.renderSetProperty(prop, elem, elemVarName, valueJS, value, clientDoc);
    }

    protected abstract boolean isRenderAttributeAlongsideProperty(String var1, Element var2);
}

