/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.scriptren.jsren;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.scriptren.shared.JSAndBSRenderImpl;

public abstract class JSRenderImpl {
    public static String javaToJS(Object value, boolean cacheIfPossible, ClientDocumentStfulDelegateImpl clientDoc) {
        return JSAndBSRenderImpl.javaToScript(value, cacheIfPossible, clientDoc);
    }

    public static String toLiteralStringJS(String value) {
        return JSAndBSRenderImpl.toLiteralStringScript(value);
    }

    public static String toTransportableStringLiteral(String text, Browser browser) {
        return JSRenderImpl.toTransportableStringLiteral(text, true, browser);
    }

    public static String toTransportableStringLiteral(String text, boolean addQuotation, Browser browser) {
        return JSAndBSRenderImpl.toTransportableStringLiteral(text, addQuotation, browser);
    }

    public static String getTransportableCharLiteral(char c, Browser browser) {
        return JSAndBSRenderImpl.getTransportableCharLiteral(c, browser);
    }

    public static String encodeURIComponent(char c) {
        return JSRenderImpl.encodeURIComponent(Character.toString(c));
    }

    public static String encodeURIComponent(String text) {
        return JSRenderImpl.encodeURIComponent(text, true);
    }

    public static String encodeURIComponent(String text, boolean encodeSpaces) {
        try {
            text = URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new ItsNatException(ex);
        }
        StringBuilder textBuff = new StringBuilder(text);
        for (int i = 0; i < textBuff.length(); ++i) {
            char c = textBuff.charAt(i);
            if (c != '+') continue;
            if (encodeSpaces) {
                textBuff.deleteCharAt(i);
                textBuff.insert(i, "%20");
                i += 2;
                continue;
            }
            textBuff.setCharAt(i, ' ');
        }
        return textBuff.toString();
    }

    public static String encodeURI(String text) {
        try {
            text = URLEncoder.encode(text, "UTF-8");
            for (int i = 0; i < text.length(); ++i) {
                String charCodeStr;
                char charCode;
                char c = text.charAt(i);
                if (c == '+') {
                    text = text.substring(0, i) + "%20" + text.substring(i + 1, text.length());
                    i += 2;
                    continue;
                }
                if (c != '%' || text.length() - i < 3 || (charCode = (char)Integer.parseInt(charCodeStr = text.substring(i + 1, i + 3), 16)) != '!' && charCode != '#' && charCode != '$' && ('&' > charCode || charCode > ';') && charCode != '=' && charCode != '?' && charCode != '@') continue;
                text = text.substring(0, i) + charCode + text.substring(i + 3, text.length());
            }
            return text;
        }
        catch (UnsupportedEncodingException ex) {
            throw new ItsNatException(ex);
        }
    }

    public static String getSetPropertyCode(Object object, String propertyName, Object value, boolean endSentence, boolean cacheIfPossible, ClientDocumentStfulDelegateImpl clientDoc) {
        return JSAndBSRenderImpl.getSetPropertyCode(object, propertyName, value, endSentence, cacheIfPossible, clientDoc);
    }

    public static String getGetPropertyCode(Object object, String propertyName, boolean endSentence, boolean cacheIfPossible, ClientDocumentStfulDelegateImpl clientDoc) {
        return JSAndBSRenderImpl.getGetPropertyCode(object, propertyName, endSentence, cacheIfPossible, clientDoc);
    }
}

