/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.scriptren.jsren;

import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.scriptren.jsren.JSCodeFragmentImpl;
import org.itsnat.impl.core.scriptren.jsren.JSScriptUtilImpl;
import org.itsnat.impl.core.scriptren.shared.ScriptReference;

public class JSReferenceImpl
implements ScriptReference {
    protected JSScriptUtilImpl scriptUtil;
    protected Object value;
    protected String tmpVarName;

    public JSReferenceImpl(Object value, JSScriptUtilImpl scriptUtil) {
        this.value = value;
        this.scriptUtil = scriptUtil;
    }

    @Override
    public String getCode() {
        if (this.tmpVarName != null) {
            return this.tmpVarName;
        }
        if (this.value instanceof JSCodeFragmentImpl) {
            JSCodeFragmentImpl fragment = (JSCodeFragmentImpl)this.value;
            ItsNatStfulDocumentImpl itsNatDoc = this.scriptUtil.getItsNatStfulDocument();
            this.tmpVarName = itsNatDoc.getUniqueIdGenerator().generateId("itsNatRef");
            fragment.setCode("var " + this.tmpVarName + "=" + fragment.getCode());
            return this.tmpVarName;
        }
        return this.scriptUtil.toScript(this.value);
    }

    private JSReferenceImpl addCodeToSendListeners(String code) {
        JSCodeFragmentImpl fragment = new JSCodeFragmentImpl(code);
        ItsNatStfulDocumentImpl itsNatDoc = this.scriptUtil.getItsNatStfulDocument();
        itsNatDoc.addCodeToSend(fragment);
        return new JSReferenceImpl(fragment, this.scriptUtil);
    }

    @Override
    public ScriptReference setProperty(String propName, Object newValue, boolean endSentence) {
        String code = this.scriptUtil.getSetPropertyCode(this, propName, newValue, endSentence);
        return this.addCodeToSendListeners(code);
    }

    @Override
    public ScriptReference getProperty(String propName, boolean endSentence) {
        String code = this.scriptUtil.getGetPropertyCode(this, propName, endSentence);
        return this.addCodeToSendListeners(code);
    }

    @Override
    public ScriptReference callMethod(String methodName, Object[] params, boolean endSentence) {
        String code = this.scriptUtil.getCallMethodCode(this, methodName, params, endSentence);
        return this.addCodeToSendListeners(code);
    }
}

