/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.scriptren.bsren.node;

import java.util.Iterator;
import java.util.LinkedList;
import org.itsnat.core.ItsNatDOMException;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.clientdoc.droid.ClientDocumentStfulDelegateDroidImpl;
import org.itsnat.impl.core.dompath.NodeLocationImpl;
import org.itsnat.impl.core.domutil.NamespaceUtil;
import org.itsnat.impl.core.scriptren.bsren.BSRenderImpl;
import org.itsnat.impl.core.scriptren.bsren.event.BSRenderEventImpl;
import org.itsnat.impl.core.scriptren.bsren.node.BSRenderNotAttrOrAbstractViewNodeImpl;
import org.itsnat.impl.core.scriptren.shared.node.JSAndBSRenderNodeImpl;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;

public class BSRenderNodeImpl
extends BSRenderImpl {
    public static BSRenderNodeImpl getBSRenderNode(Node node) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 2: {
                throw new ItsNatException("INTERNAL ERROR");
            }
            case -1: {
                throw new ItsNatDOMException("Unexpected window use", node);
            }
        }
        return BSRenderNotAttrOrAbstractViewNodeImpl.getBSRenderNotAttrOrAbstractViewNode(node);
    }

    public static String removeNodeFromCache(LinkedList<String> idList) {
        StringBuilder code = new StringBuilder();
        Iterator it = idList.iterator();
        while (it.hasNext()) {
            String id = BSRenderNodeImpl.toLiteralStringBS((String)it.next());
            if (code.length() > 0) {
                code.append("," + id);
                continue;
            }
            code.append(id);
        }
        return "itsNatDoc.removeNodeCache(new String[]{" + code.toString() + "});\n";
    }

    public static String shortNamespaceURI(String namespaceURI) {
        if (NamespaceUtil.isAndroidNamespace(namespaceURI)) {
            return "NSAND";
        }
        return "\"" + namespaceURI + "\"";
    }

    public static String getNodeReference(Node node, boolean cacheIfPossible, boolean errIfNull, ClientDocumentStfulDelegateImpl clientDoc) {
        if (node == null) {
            if (errIfNull) {
                throw new ItsNatException("No specified node");
            }
            return "null";
        }
        NodeLocationImpl nodeLoc = clientDoc.getNodeLocation(node, cacheIfPossible);
        return BSRenderNodeImpl.getNodeReference(nodeLoc, errIfNull);
    }

    public static String getNodeReference(NodeLocationImpl nodeLoc, boolean errIfNull) {
        String nodeRef = JSAndBSRenderNodeImpl.getNodeLocation(nodeLoc, errIfNull);
        return "itsNatDoc.getView(" + nodeRef + ")";
    }

    public static String addNodeToCache(NodeLocationImpl nodeLoc) {
        return JSAndBSRenderNodeImpl.addNodeToCache(nodeLoc);
    }

    public static String removeNodeFromCache(String id) {
        return "itsNatDoc.removeNodeCache(new String[]{" + BSRenderNodeImpl.toLiteralStringBS(id) + "});\n";
    }

    public static String getCodeDispatchEvent(EventTarget node, Event evt, String varResName, ClientDocumentStfulDelegateDroidImpl clientDoc) {
        BSRenderEventImpl evtRender = BSRenderEventImpl.getBSEventRender(evt);
        NodeLocationImpl nodeLoc = clientDoc.getNodeLocation((Node)((Object)node), true);
        return evtRender.getDispatchEvent(varResName, nodeLoc, evt, clientDoc);
    }
}

