/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.scriptren.bsren.node;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.clientdoc.droid.ClientDocumentStfulDelegateDroidImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.itsnat.impl.core.scriptren.bsren.node.BSRenderAttributeImpl;
import org.itsnat.impl.core.scriptren.bsren.node.BSRenderElementScriptImpl;
import org.itsnat.impl.core.scriptren.bsren.node.BSRenderElementViewImpl;
import org.itsnat.impl.core.scriptren.bsren.node.BSRenderHasChildrenNodeImpl;
import org.itsnat.impl.core.scriptren.shared.node.CannotInsertAsMarkupCauseImpl;
import org.itsnat.impl.core.scriptren.shared.node.InnerMarkupCodeImpl;
import org.itsnat.impl.core.scriptren.shared.node.InsertAsMarkupInfoImpl;
import org.itsnat.impl.core.scriptren.shared.node.JSAndBSRenderElementImpl;
import org.itsnat.impl.core.scriptren.shared.node.RenderElement;
import org.itsnat.impl.core.template.MarkupTemplateVersionImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class BSRenderElementImpl
extends BSRenderHasChildrenNodeImpl
implements RenderElement {
    public static boolean SUPPORT_INSERTION_AS_MARKUP = true;

    public static BSRenderElementImpl getBSRenderElement(Element elem) {
        if ("script".equals(elem.getTagName())) {
            return BSRenderElementScriptImpl.SINGLETON;
        }
        return BSRenderElementViewImpl.SINGLETON;
    }

    @Override
    public String createNodeCode(Node node, ClientDocumentStfulDelegateImpl clientDoc) {
        Element nodeElem = (Element)node;
        return this.createElement(nodeElem, clientDoc);
    }

    protected String createElement(Element nodeElem, ClientDocumentStfulDelegateImpl clientDoc) {
        String tagName = nodeElem.getTagName();
        return this.createElement(nodeElem, tagName, clientDoc);
    }

    protected abstract String createElement(Element var1, String var2, ClientDocumentStfulDelegateImpl var3);

    @Override
    public String addAttributesBeforeInsertNode(Node node, String elemVarName, ClientDocumentStfulDelegateImpl clientDoc) {
        Element elem = (Element)node;
        BSRenderAttributeImpl render = BSRenderAttributeImpl.getBSRenderAttribute();
        StringBuilder code = new StringBuilder();
        NamedNodeMap attribList = elem.getAttributes();
        if (attribList.getLength() <= 1) {
            for (int i = 0; i < attribList.getLength(); ++i) {
                Attr attr = (Attr)attribList.item(i);
                code.append(render.setAttributeCode(attr, elem, elemVarName, clientDoc));
            }
        } else {
            HashMap<String, List<Attr>> mapByNamespace = new HashMap<String, List<Attr>>();
            LinkedList<Attr> listNoNamespace = new LinkedList<Attr>();
            for (int i = 0; i < attribList.getLength(); ++i) {
                Attr attr = (Attr)attribList.item(i);
                String ns = attr.getNamespaceURI();
                if (ns != null) {
                    LinkedList<Attr> list = (LinkedList<Attr>)mapByNamespace.get(ns);
                    if (list == null) {
                        list = new LinkedList<Attr>();
                        mapByNamespace.put(ns, list);
                    }
                    list.add(attr);
                    mapByNamespace.put(ns, list);
                    continue;
                }
                listNoNamespace.add(attr);
            }
            if (!mapByNamespace.isEmpty()) {
                code.append(render.setAttributeCodeBatchNS(elem, elemVarName, mapByNamespace, clientDoc));
            }
            if (!listNoNamespace.isEmpty()) {
                code.append(render.setAttributeCodeBatch(elem, elemVarName, listNoNamespace, clientDoc));
            }
        }
        return code.toString();
    }

    @Override
    public Object appendChildNodes(Node parent, String parentVarName, boolean beforeParent, InsertAsMarkupInfoImpl insertMarkupInfo, ClientDocumentStfulDelegateImpl clientDoc) {
        if (SUPPORT_INSERTION_AS_MARKUP) {
            CannotInsertAsMarkupCauseImpl cannotInsertMarkup = this.canInsertAllChildrenAsMarkup((Element)parent, clientDoc.getItsNatStfulDocument().getItsNatStfulDocumentTemplateVersion(), insertMarkupInfo);
            if (cannotInsertMarkup == null) {
                InnerMarkupCodeImpl innerMarkup = this.appendChildrenAsMarkup(parentVarName, parent, clientDoc);
                return innerMarkup;
            }
            InsertAsMarkupInfoImpl insertMarkupInfoNextLevel = cannotInsertMarkup.createInsertAsMarkupInfoNextLevel();
            return super.appendChildNodes(parent, parentVarName, beforeParent, insertMarkupInfoNextLevel, clientDoc);
        }
        InsertAsMarkupInfoImpl insertMarkupInfoNextLevel = null;
        return super.appendChildNodes(parent, parentVarName, beforeParent, insertMarkupInfoNextLevel, clientDoc);
    }

    @Override
    public Object getInsertNewNodeCode(Node newNode, ClientDocumentStfulDelegateDroidImpl clientDoc) {
        if (SUPPORT_INSERTION_AS_MARKUP) {
            CannotInsertAsMarkupCauseImpl cannotInsertMarkup = this.canInsertSingleChildNodeAsMarkup(newNode, clientDoc);
            if (cannotInsertMarkup == null) {
                return this.appendSingleChildNodeAsMarkup(newNode, clientDoc);
            }
            InsertAsMarkupInfoImpl insertMarkupInfoNextLevel = cannotInsertMarkup.createInsertAsMarkupInfoNextLevel();
            return super.getInsertNewNodeCode(newNode, insertMarkupInfoNextLevel, clientDoc);
        }
        InsertAsMarkupInfoImpl insertMarkupInfoNextLevel = null;
        return super.getInsertNewNodeCode(newNode, insertMarkupInfoNextLevel, clientDoc);
    }

    @Override
    public boolean isAddChildNodesBeforeNode(Node parent, ClientDocumentStfulDelegateImpl clientDoc) {
        return false;
    }

    @Override
    public String getAppendChildrenCodeAsMarkupSentence(InnerMarkupCodeImpl innerMarkupRender, ClientDocumentStfulDelegateImpl clientDoc) {
        String parentNodeLocator = innerMarkupRender.getParentNodeLocator();
        String valueBS = BSRenderElementImpl.toTransportableStringLiteral(innerMarkupRender.getInnerMarkup(), clientDoc.getBrowser());
        if (innerMarkupRender.isUseNodeLocation()) {
            return "itsNatDoc.setInnerXML2(" + parentNodeLocator + "," + valueBS + ");\n";
        }
        return "itsNatDoc.setInnerXML(" + parentNodeLocator + "," + valueBS + ");\n";
    }

    private CannotInsertAsMarkupCauseImpl canInsertSingleChildNodeAsMarkup(Node newChildNode, ClientDocumentStfulDelegateDroidImpl clientDoc) {
        return JSAndBSRenderElementImpl.canInsertSingleChildNodeAsMarkup(newChildNode, clientDoc, this);
    }

    private InnerMarkupCodeImpl appendSingleChildNodeAsMarkup(Node newNode, ClientDocumentStfulDelegateDroidImpl clientDoc) {
        return JSAndBSRenderElementImpl.appendSingleChildNodeAsMarkup(newNode, clientDoc, (RenderElement)this);
    }

    private InnerMarkupCodeImpl appendChildrenAsMarkup(String parentVarName, Node parentNode, ClientDocumentStfulDelegateImpl clientDoc) {
        return JSAndBSRenderElementImpl.appendChildrenAsMarkup(parentVarName, parentNode, clientDoc, this);
    }

    @Override
    public boolean isInsertChildNodesAsMarkupCapable(Element parent, MarkupTemplateVersionImpl template) {
        return true;
    }

    @Override
    public boolean match(Node node, Object context) {
        return this.isChildNotValidInsertedAsMarkup(node, (MarkupTemplateVersionImpl)context);
    }

    public boolean isChildNotValidInsertedAsMarkup(Node childNode, MarkupTemplateVersionImpl template) {
        return false;
    }

    @Override
    public CannotInsertAsMarkupCauseImpl canInsertChildNodeAsMarkupIgnoringOther(Element parent, Node childNode, MarkupTemplateVersionImpl template) {
        return JSAndBSRenderElementImpl.canInsertChildNodeAsMarkupIgnoringOther(parent, childNode, template, this);
    }

    public boolean canInsertAllChildrenAsMarkup(Element parent, MarkupTemplateVersionImpl template) {
        CannotInsertAsMarkupCauseImpl cannotInsertMarkup = this.canInsertAllChildrenAsMarkup(parent, template, null);
        return cannotInsertMarkup == null;
    }

    public CannotInsertAsMarkupCauseImpl canInsertAllChildrenAsMarkup(Element parent, MarkupTemplateVersionImpl template, InsertAsMarkupInfoImpl insertMarkupInfo) {
        return JSAndBSRenderElementImpl.canInsertAllChildrenAsMarkup(parent, template, insertMarkupInfo, this);
    }

    @Override
    public Node getFirstChildIsNotValidInsertedAsMarkup(Element parent, MarkupTemplateVersionImpl template) {
        return DOMUtilInternal.getFirstContainedNodeMatching(parent, this, template);
    }

    @Override
    public InnerMarkupCodeImpl appendChildrenCodeAsMarkup(String parentVarName, Element parentNode, String childrenCode, ClientDocumentStfulDelegateImpl clientDoc) {
        return JSAndBSRenderElementImpl.createInnerMarkupCode(parentVarName, parentNode, childrenCode, clientDoc, this);
    }
}

