/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.scriptren.bsren.node;

import java.util.List;
import java.util.Map;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.clientdoc.droid.ClientDocumentStfulDelegateDroidImpl;
import org.itsnat.impl.core.dompath.NodeLocationImpl;
import org.itsnat.impl.core.scriptren.bsren.node.BSRenderNodeImpl;
import org.itsnat.impl.core.scriptren.shared.node.NodeScriptRefImpl;
import org.itsnat.impl.core.scriptren.shared.node.RenderAttribute;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class BSRenderAttributeImpl
extends BSRenderNodeImpl
implements RenderAttribute {
    private static final BSRenderAttributeImpl SINGLETON = new BSRenderAttributeImpl();

    public static BSRenderAttributeImpl getBSRenderAttribute() {
        return SINGLETON;
    }

    public boolean isIgnored(Attr attr, Element elem) {
        return false;
    }

    public String setAttributeCode(Attr attr, Element elem, ClientDocumentStfulDelegateDroidImpl clientDoc) {
        if (this.isIgnored(attr, elem)) {
            return "";
        }
        String attrName = attr.getName();
        String bsValue = this.toBSAttrValue(attr, elem, clientDoc);
        return this.setAttributeCode(attr, attrName, bsValue, elem, clientDoc);
    }

    protected String toBSAttrValue(Attr attr, Element elem, ClientDocumentStfulDelegateImpl clientDoc) {
        String value = attr.getValue();
        return this.toBSAttrValue(value, clientDoc);
    }

    protected String toBSAttrValue(String value, ClientDocumentStfulDelegateImpl clientDoc) {
        return BSRenderAttributeImpl.toTransportableStringLiteral(value, clientDoc.getBrowser());
    }

    public String setAttributeCode(Attr attr, Element elem, String elemVarName, ClientDocumentStfulDelegateImpl clientDoc) {
        if (this.isIgnored(attr, elem)) {
            return "";
        }
        String attrName = attr.getName();
        String bsValue = this.toBSAttrValue(attr, elem, clientDoc);
        return this.setAttributeCode(attr, attrName, bsValue, elem, elemVarName, clientDoc);
    }

    protected String setAttributeCode(Attr attr, String attrName, String bsValue, Element elem, ClientDocumentStfulDelegateDroidImpl clientDoc) {
        NodeLocationImpl nodeLoc = clientDoc.getNodeLocation(elem, true);
        return this.setAttributeCode(attr, attrName, bsValue, new NodeScriptRefImpl(nodeLoc));
    }

    protected String setAttributeCode(Attr attr, String attrName, String bsValue, Element elem, String elemVarName, ClientDocumentStfulDelegateImpl clientDoc) {
        return this.setAttributeCode(attr, attrName, bsValue, new NodeScriptRefImpl(elemVarName, clientDoc));
    }

    public String setAttributeCode(Attr attr, String attrName, String bsValue, NodeScriptRefImpl nodeRef) {
        String namespaceURI = attr.getNamespaceURI();
        if (namespaceURI != null) {
            String namespaceURIScript = BSRenderAttributeImpl.shortNamespaceURI(namespaceURI);
            attrName = attr.getLocalName();
            if (nodeRef.getNodeRef() instanceof NodeLocationImpl) {
                NodeLocationImpl nodeLoc = (NodeLocationImpl)nodeRef.getNodeRef();
                return "itsNatDoc.setAttributeNS2(" + nodeLoc.toScriptNodeLocation(true) + "," + namespaceURIScript + ",\"" + attrName + "\"," + bsValue + ");\n";
            }
            String elemVarName = (String)nodeRef.getNodeRef();
            return "itsNatDoc.setAttributeNS(" + elemVarName + "," + namespaceURIScript + ",\"" + attrName + "\"," + bsValue + ");\n";
        }
        if (nodeRef.getNodeRef() instanceof NodeLocationImpl) {
            NodeLocationImpl nodeLoc = (NodeLocationImpl)nodeRef.getNodeRef();
            return "itsNatDoc.setAttribute2(" + nodeLoc.toScriptNodeLocation(true) + ",\"" + attrName + "\"," + bsValue + ");\n";
        }
        String elemVarName = (String)nodeRef.getNodeRef();
        return "itsNatDoc.setAttribute(" + elemVarName + ",\"" + attrName + "\"," + bsValue + ");\n";
    }

    private void toArraysForBatch(Element elem, List<Attr> attrList, boolean namespaceBased, StringBuilder attrNameArr, StringBuilder attrValueArr, ClientDocumentStfulDelegateImpl clientDoc) {
        int i = 0;
        for (Attr attr : attrList) {
            String name = namespaceBased ? attr.getLocalName() : attr.getName();
            String bsValue = this.toBSAttrValue(attr, elem, clientDoc);
            attrNameArr.append("\"" + name + "\"");
            attrValueArr.append(bsValue);
            if (++i >= attrList.size()) continue;
            attrNameArr.append(',');
            attrValueArr.append(',');
        }
    }

    public String setAttributeCodeBatchNS(Element elem, String elemVarName, Map<String, List<Attr>> mapByNamespace, ClientDocumentStfulDelegateImpl clientDoc) {
        StringBuilder code = new StringBuilder();
        for (Map.Entry<String, List<Attr>> entry : mapByNamespace.entrySet()) {
            String namespaceURI = entry.getKey();
            String namespaceURIScript = BSRenderAttributeImpl.shortNamespaceURI(namespaceURI);
            List<Attr> attribList = entry.getValue();
            StringBuilder attrNameArr = new StringBuilder();
            StringBuilder attrValueArr = new StringBuilder();
            this.toArraysForBatch(elem, attribList, true, attrNameArr, attrValueArr, clientDoc);
            code.append("itsNatDoc.setAttrBatch(" + elemVarName + "," + namespaceURIScript + ",new String[]{" + attrNameArr.toString() + "},new String[]{" + attrValueArr.toString() + "});\n");
        }
        return code.toString();
    }

    public String setAttributeCodeBatch(Element elem, String elemVarName, List<Attr> attrListNoNamespace, ClientDocumentStfulDelegateImpl clientDoc) {
        StringBuilder attrNameArr = new StringBuilder();
        StringBuilder attrValueArr = new StringBuilder();
        this.toArraysForBatch(elem, attrListNoNamespace, false, attrNameArr, attrValueArr, clientDoc);
        String code = "itsNatDoc.setAttrBatch(" + elemVarName + ",null,new String[]{" + attrNameArr.toString() + "},new String[]{" + attrValueArr.toString() + "});\n";
        return code;
    }

    public String removeAttributeCode(Attr attr, Element elem, ClientDocumentStfulDelegateDroidImpl clientDoc) {
        if (this.isIgnored(attr, elem)) {
            return "";
        }
        String attrName = attr.getName();
        return this.removeAttributeCode(attr, attrName, elem, clientDoc);
    }

    protected String removeAttributeCode(Attr attr, String attrName, Element elem, ClientDocumentStfulDelegateDroidImpl clientDoc) {
        NodeLocationImpl nodeLoc = clientDoc.getNodeLocation(elem, true);
        return this.removeAttributeCode(attr, attrName, elem, new NodeScriptRefImpl(nodeLoc));
    }

    protected String removeAttributeCode(Attr attr, String attrName, Element elem, NodeScriptRefImpl nodeRef) {
        String namespaceURI = attr.getNamespaceURI();
        if (namespaceURI != null) {
            String namespaceURIScript = BSRenderAttributeImpl.shortNamespaceURI(namespaceURI);
            attrName = attr.getLocalName();
            if (nodeRef.getNodeRef() instanceof NodeLocationImpl) {
                NodeLocationImpl nodeLoc = (NodeLocationImpl)nodeRef.getNodeRef();
                return "itsNatDoc.removeAttributeNS2(" + nodeLoc.toScriptNodeLocation(true) + "," + namespaceURIScript + ",\"" + attrName + "\");\n";
            }
            String elemVarName = (String)nodeRef.getNodeRef();
            return "itsNatDoc.removeAttributeNS(" + elemVarName + "," + namespaceURIScript + ",\"" + attrName + "\");\n";
        }
        if (nodeRef.getNodeRef() instanceof NodeLocationImpl) {
            NodeLocationImpl nodeLoc = (NodeLocationImpl)nodeRef.getNodeRef();
            return "itsNatDoc.removeAttribute2(" + nodeLoc.toScriptNodeLocation(true) + ",\"" + attrName + "\");\n";
        }
        String elemVarName = (String)nodeRef.getNodeRef();
        return "itsNatDoc.removeAttribute(" + elemVarName + ",\"" + attrName + "\");\n";
    }
}

