/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.resp.shared.html;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.itsnat.impl.core.browser.web.BrowserGecko;
import org.itsnat.impl.core.browser.web.BrowserW3C;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.browser.web.opera.BrowserOperaOld;
import org.itsnat.impl.core.browser.web.webkit.BrowserWebKit;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.resp.ResponseLoadStfulDocumentValid;
import org.itsnat.impl.core.resp.shared.html.ResponseDelegateHTMLLoadDocGeckoImpl;
import org.itsnat.impl.core.resp.shared.html.ResponseDelegateHTMLLoadDocImpl;
import org.itsnat.impl.core.resp.shared.html.ResponseDelegateHTMLLoadDocOperaOldImpl;
import org.itsnat.impl.core.resp.shared.html.ResponseDelegateHTMLLoadDocW3CDefaultImpl;
import org.itsnat.impl.core.resp.shared.html.ResponseDelegateHTMLLoadDocWebKitImpl;
import org.itsnat.impl.core.scriptren.jsren.node.otherns.JSRenderOtherNSAttributeW3CImpl;
import org.itsnat.impl.core.scriptren.jsren.node.otherns.JSRenderOtherNSElementW3CImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class ResponseDelegateHTMLLoadDocW3CImpl
extends ResponseDelegateHTMLLoadDocImpl {
    private static final String NSROOTATTRNAME = "itsnatnsroot";
    private static final String NSATTRPREFIX = "itsnatns_";

    public ResponseDelegateHTMLLoadDocW3CImpl(ResponseLoadStfulDocumentValid response) {
        super(response);
    }

    public static ResponseDelegateHTMLLoadDocW3CImpl createResponseDelegateHTMLLoadDocW3C(BrowserW3C browser, ResponseLoadStfulDocumentValid responseParent) {
        if (browser instanceof BrowserGecko) {
            return ResponseDelegateHTMLLoadDocGeckoImpl.createResponseDelegateHTMLLoadDocGecko((BrowserGecko)browser, responseParent);
        }
        if (browser instanceof BrowserWebKit) {
            return ResponseDelegateHTMLLoadDocWebKitImpl.createResponseDelegateLoadHTMLDocWebKit(responseParent);
        }
        if (browser instanceof BrowserOperaOld) {
            return ResponseDelegateHTMLLoadDocOperaOldImpl.createResponseDelegateHTMLLoadDocOperaOld((BrowserOperaOld)browser, responseParent);
        }
        return new ResponseDelegateHTMLLoadDocW3CDefaultImpl(responseParent);
    }

    @Override
    protected LinkedList<Element> fixOtherNSElementsInHTMLFindRootElems() {
        ClientDocumentStfulImpl clientDoc = this.getClientDocumentStful();
        if (!clientDoc.isSendCodeEnabled()) {
            return null;
        }
        BrowserWeb browser = (BrowserWeb)clientDoc.getBrowser();
        if (!browser.canNativelyRenderOtherNSInXHTMLDoc()) {
            return null;
        }
        if (!this.getItsNatHTMLDocument().isMIME_HTML()) {
            return null;
        }
        Element rootElem = this.getItsNatHTMLDocument().getDocument().getDocumentElement();
        return this.getOtherNSRootElementsInline(rootElem);
    }

    protected static boolean hasSomeCharUpcase(String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            if (!Character.isUpperCase(value.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected LinkedList<Attr> fixOtherNSElementsInHTMLSaveValidNames(LinkedList<Element> otherNSRootElemsInHTML) {
        LinkedList<Attr> auxAttribs = new LinkedList<Attr>();
        for (Element elem : otherNSRootElemsInHTML) {
            Attr attr = elem.getOwnerDocument().createAttribute(NSROOTATTRNAME);
            attr.setValue("true");
            elem.setAttributeNode(attr);
            auxAttribs.add(attr);
            this.fixOtherNSElementsInHTMLSaveValidNames(elem, auxAttribs);
        }
        return auxAttribs;
    }

    protected void fixOtherNSElementsInHTMLSaveValidNames(Element elem, LinkedList<Attr> auxAttribs) {
        boolean elemWithOtherNS;
        if (JSRenderOtherNSAttributeW3CImpl.hasIgnoreNSAttrInMIMEHTML(elem)) {
            return;
        }
        Attr[] originalAttribs = null;
        if (elem.hasAttributes()) {
            NamedNodeMap attribs = elem.getAttributes();
            int len = attribs.getLength();
            originalAttribs = new Attr[len];
            for (int i = 0; i < len; ++i) {
                Attr attr;
                originalAttribs[i] = attr = (Attr)attribs.item(i);
            }
        }
        if (elemWithOtherNS = JSRenderOtherNSElementW3CImpl.isElementWithOtherNSTagNameInMIMEHTML(elem)) {
            this.fixOtherNSElementsInHTMLSaveValidName(elem, elem.getPrefix(), elem.getLocalName(), auxAttribs);
        }
        if (originalAttribs != null) {
            for (int i = 0; i < originalAttribs.length; ++i) {
                Attr attr = originalAttribs[i];
                if (!elemWithOtherNS && !JSRenderOtherNSAttributeW3CImpl.isAttrWithOtherNSInMIMEHTML(attr)) continue;
                String prefix = attr.getPrefix();
                String localName = prefix != null ? attr.getName().substring(prefix.length() + 1) : attr.getName();
                this.fixOtherNSElementsInHTMLSaveValidName(elem, prefix, localName, auxAttribs);
            }
        }
        if (elem.hasChildNodes()) {
            for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element)) continue;
                this.fixOtherNSElementsInHTMLSaveValidNames((Element)node, auxAttribs);
            }
        }
    }

    protected void fixOtherNSElementsInHTMLSaveValidName(Element elem, String prefix, String localName, LinkedList<Attr> auxAttribs) {
        String attrValue;
        String attrName;
        if (!ResponseDelegateHTMLLoadDocW3CImpl.hasSomeCharUpcase(prefix) && !ResponseDelegateHTMLLoadDocW3CImpl.hasSomeCharUpcase(localName)) {
            return;
        }
        if (prefix != null) {
            attrName = NSATTRPREFIX + prefix.toLowerCase() + "_" + localName.toLowerCase();
            attrValue = prefix + ":" + localName;
        } else {
            attrName = NSATTRPREFIX + localName.toLowerCase();
            attrValue = localName;
        }
        Attr attr = elem.getOwnerDocument().createAttribute(attrName);
        attr.setValue(attrValue);
        elem.setAttributeNode(attr);
        auxAttribs.add(attr);
    }

    @Override
    protected void fixOtherNSElementsInHTMLCleanAuxAttribs(LinkedList<Attr> attribs) {
        if (attribs == null) {
            return;
        }
        for (Attr attr : attribs) {
            attr.getOwnerElement().removeAttributeNode(attr);
        }
    }

    @Override
    protected void fixOtherNSElementsInHTMLGenCode(LinkedList<Element> otherNSElemsInHTML) {
        this.addScriptFileToLoad("itsnat_fix_otherns_in_html.js");
        StringBuilder code = new StringBuilder();
        HashSet<String> tagNames = new HashSet<String>();
        for (Element elem : otherNSElemsInHTML) {
            tagNames.add(elem.getTagName().toUpperCase());
        }
        code.append("new ItsNatFixOtherNSInHTML().fixTreeOtherNSInHTML([");
        Iterator it = tagNames.iterator();
        while (it.hasNext()) {
            String tagName = (String)it.next();
            code.append("\"" + tagName + "\"");
            if (!it.hasNext()) continue;
            code.append(",");
        }
        code.append("]);\n");
        code.append("obj = null;\n");
        this.addFixDOMCodeToSend(code.toString());
    }

    protected LinkedList<Element> getOtherNSRootElementsInline(Node node) {
        return this.getOtherNSRootElementsInline(node, null);
    }

    protected LinkedList<Element> getOtherNSRootElementsInline(Node node, LinkedList<Element> list) {
        if (node.getNodeType() != 1) {
            return list;
        }
        Element elem = (Element)node;
        if (this.isSVGRootElementProcessedBySVGWeb(elem)) {
            return list;
        }
        if (JSRenderOtherNSElementW3CImpl.isElementWithSomethingOtherNSInMIMEHTML(elem)) {
            if (list == null) {
                list = new LinkedList();
            }
            list.add(elem);
        } else {
            for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
                list = this.getOtherNSRootElementsInline(child, list);
            }
        }
        return list;
    }

    @Override
    public String getJavaScriptDocumentName() {
        return "W3CHTMLDocument";
    }
}

