/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.resp.shared.html;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.itsnat.impl.core.browser.web.BrowserMSIEOld;
import org.itsnat.impl.core.doc.web.ItsNatHTMLDocumentImpl;
import org.itsnat.impl.core.domutil.DOMUtilHTML;
import org.itsnat.impl.core.domutil.NamespaceUtil;
import org.itsnat.impl.core.resp.ResponseLoadStfulDocumentValid;
import org.itsnat.impl.core.resp.shared.html.ResponseDelegateHTMLLoadDocImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLBodyElement;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLHeadElement;

public class ResponseDelegateHTMLLoadDocMSIEOldImpl
extends ResponseDelegateHTMLLoadDocImpl {
    public ResponseDelegateHTMLLoadDocMSIEOldImpl(ResponseLoadStfulDocumentValid response) {
        super(response);
    }

    public static ResponseDelegateHTMLLoadDocMSIEOldImpl createResponseDelegateHTMLLoadDocMSIEOld(BrowserMSIEOld browser, ResponseLoadStfulDocumentValid responseParent) {
        return new ResponseDelegateHTMLLoadDocMSIEOldImpl(responseParent);
    }

    @Override
    protected LinkedList<Element> fixOtherNSElementsInHTMLFindRootElems() {
        return null;
    }

    @Override
    protected LinkedList<Attr> fixOtherNSElementsInHTMLSaveValidNames(LinkedList<Element> otherNSRootElemsInHTML) {
        return null;
    }

    @Override
    protected void fixOtherNSElementsInHTMLCleanAuxAttribs(LinkedList<Attr> attribs) {
    }

    @Override
    protected void fixOtherNSElementsInHTMLGenCode(LinkedList<Element> otherNSElemsInHTML) {
    }

    @Override
    public String getJavaScriptDocumentName() {
        return "MSIEOldHTMLDocument";
    }

    @Override
    public String serializeDocument() {
        ItsNatHTMLDocumentImpl itsNatDoc = this.getItsNatHTMLDocument();
        HTMLDocument doc = itsNatDoc.getHTMLDocument();
        Map<String, Attr> attrNamespaces = this.processTreeNamespaces(doc);
        String docMarkup = super.serializeDocument();
        ResponseDelegateHTMLLoadDocMSIEOldImpl.restoreHTMLElemAttrNamespaces(doc, attrNamespaces);
        return docMarkup;
    }

    protected Map<String, Attr> processTreeNamespaces(HTMLDocument doc) {
        HashMap<String, Attr> attrNamespaces = null;
        Element html = doc.getDocumentElement();
        if (html.hasAttributes()) {
            NamedNodeMap attribs = html.getAttributes();
            for (int i = 0; i < attribs.getLength(); ++i) {
                Attr attr = (Attr)attribs.item(i);
                String prefix = attr.getPrefix();
                if (prefix == null || !prefix.equals("xmlns")) continue;
                if (attrNamespaces == null) {
                    attrNamespaces = new HashMap<String, Attr>();
                }
                attrNamespaces.put(attr.getName(), attr);
            }
        }
        HTMLHeadElement head = DOMUtilHTML.getHTMLHead(doc);
        this.processTreeNamespaces(head);
        HTMLBodyElement body = (HTMLBodyElement)doc.getBody();
        this.processTreeNamespaces(body);
        return attrNamespaces;
    }

    protected void processTreeNamespaces(Node node) {
        if (node == null) {
            return;
        }
        if (node.getNodeType() != 1) {
            return;
        }
        Element elem = (Element)node;
        this.processNamespacesOfElement(elem);
        if (elem.hasChildNodes()) {
            for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.processTreeNamespaces(child);
            }
        }
    }

    protected void processNamespacesOfElement(Element elem) {
        if (elem.hasAttributes()) {
            NamedNodeMap attribs = elem.getAttributes();
            for (int i = 0; i < attribs.getLength(); ++i) {
                Attr attr = (Attr)attribs.item(i);
                String prefix = attr.getPrefix();
                if (prefix == null || !prefix.equals("xmlns") || NamespaceUtil.isItsNatNamespace(attr.getValue())) continue;
                Element html = elem.getOwnerDocument().getDocumentElement();
                html.setAttributeNS("http://www.w3.org/2000/xmlns/", attr.getName(), attr.getValue());
            }
        }
    }

    protected static void restoreHTMLElemAttrNamespaces(Document doc, Map<String, Attr> attrNamespaces) {
        Element html = doc.getDocumentElement();
        if (attrNamespaces != null) {
            for (Map.Entry<String, Attr> entry : attrNamespaces.entrySet()) {
                String name = entry.getKey();
                Attr value = entry.getValue();
                html.setAttributeNS("http://www.w3.org/2000/xmlns/", name, value.getValue());
            }
        }
        if (html.hasAttributes()) {
            NamedNodeMap attribs = html.getAttributes();
            int i = 0;
            while (i < attribs.getLength()) {
                Attr attr = (Attr)attribs.item(i);
                String prefix = attr.getPrefix();
                if (prefix != null && prefix.equals("xmlns")) {
                    if (attrNamespaces == null || !attrNamespaces.containsKey(attr.getName())) {
                        html.removeAttributeNode(attr);
                        continue;
                    }
                    ++i;
                    continue;
                }
                ++i;
            }
        }
    }
}

