/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.resp.shared.html;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.browser.web.BrowserMSIEOld;
import org.itsnat.impl.core.browser.web.BrowserW3C;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.clientdoc.web.SVGWebInfoImpl;
import org.itsnat.impl.core.doc.web.ItsNatHTMLDocumentImpl;
import org.itsnat.impl.core.domimpl.html.HTMLTextAreaElementImpl;
import org.itsnat.impl.core.domutil.DOMUtilHTML;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.itsnat.impl.core.resp.ResponseLoadStfulDocumentValid;
import org.itsnat.impl.core.resp.shared.ResponseDelegateStfulWebLoadDocImpl;
import org.itsnat.impl.core.resp.shared.html.ResponseDelegateHTMLLoadDocMSIEOldImpl;
import org.itsnat.impl.core.resp.shared.html.ResponseDelegateHTMLLoadDocW3CImpl;
import org.itsnat.impl.core.scriptren.jsren.JSRenderImpl;
import org.itsnat.impl.core.scriptren.jsren.node.JSRenderPropertyImpl;
import org.itsnat.impl.core.scriptren.jsren.node.PropertyImpl;
import org.itsnat.impl.core.template.web.html.HTMLTemplateVersionDelegateImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLBodyElement;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLHeadElement;
import org.w3c.dom.html.HTMLMetaElement;
import org.w3c.dom.html.HTMLTextAreaElement;

public abstract class ResponseDelegateHTMLLoadDocImpl
extends ResponseDelegateStfulWebLoadDocImpl {
    public ResponseDelegateHTMLLoadDocImpl(ResponseLoadStfulDocumentValid responseParent) {
        super(responseParent);
    }

    public static ResponseDelegateHTMLLoadDocImpl createResponseDelegateHTMLLoadDoc(ResponseLoadStfulDocumentValid responseParent) {
        Browser browser = responseParent.getClientDocument().getBrowser();
        if (browser instanceof BrowserMSIEOld) {
            return ResponseDelegateHTMLLoadDocMSIEOldImpl.createResponseDelegateHTMLLoadDocMSIEOld((BrowserMSIEOld)browser, responseParent);
        }
        return ResponseDelegateHTMLLoadDocW3CImpl.createResponseDelegateHTMLLoadDocW3C((BrowserW3C)browser, responseParent);
    }

    @Override
    public ClientDocumentStfulDelegateWebImpl getClientDocumentStfulDelegateWeb() {
        return (ClientDocumentStfulDelegateWebImpl)this.getClientDocumentStfulDelegate();
    }

    public ItsNatHTMLDocumentImpl getItsNatHTMLDocument() {
        ClientDocumentStfulImpl clientDoc = this.getClientDocumentStful();
        return (ItsNatHTMLDocumentImpl)clientDoc.getItsNatDocument();
    }

    @Override
    public String getJavaScriptMIME() {
        return "text/javascript";
    }

    @Override
    public void setScriptURLAttribute(Element scriptElem, String url) {
        DOMUtilInternal.setAttribute(scriptElem, "src", url);
    }

    @Override
    public void setScriptContent(Element scriptElem, String code) {
        ItsNatHTMLDocumentImpl itsNatDoc = this.getItsNatHTMLDocument();
        Document doc = scriptElem.getOwnerDocument();
        if (itsNatDoc.isMIME_HTML()) {
            scriptElem.appendChild(doc.createTextNode(code));
        } else {
            scriptElem.appendChild(doc.createCDATASection(code));
        }
    }

    @Override
    public String addMarkupToTheEndOfDoc(String docMarkup, String scriptsMarkup) {
        StringBuilder finalMarkup = new StringBuilder();
        int posHTMLEnd = docMarkup.lastIndexOf(60);
        int posBODYEnd = docMarkup.lastIndexOf(60, posHTMLEnd - 1);
        String preScript = docMarkup.substring(0, posBODYEnd);
        String posScript = docMarkup.substring(posBODYEnd);
        finalMarkup.append(preScript);
        finalMarkup.append(scriptsMarkup);
        finalMarkup.append(posScript);
        return finalMarkup.toString();
    }

    @Override
    public String getDocumentNamespace() {
        return "http://www.w3.org/1999/xhtml";
    }

    @Override
    protected void rewriteClientUIControlProperties(Element elem, boolean revertJSChanges, StringBuilder code) {
        this.rewriteClientHTMLUIControlProperties(elem, revertJSChanges, code);
    }

    @Override
    protected String serializeDocument() {
        boolean useSVGWeb = SVGWebInfoImpl.isSVGWebEnabled(this.getClientDocumentStfulDelegateWeb());
        LinkedList<Attr> otherNSElemsAttribs = null;
        LinkedList<Element> otherNSRootElemsInHTML = this.fixOtherNSElementsInHTMLFindRootElems();
        if (otherNSRootElemsInHTML != null) {
            otherNSElemsAttribs = this.fixOtherNSElementsInHTMLSaveValidNames(otherNSRootElemsInHTML);
        }
        Map<Element, Element> svgRootElems = null;
        if (useSVGWeb) {
            HTMLDocument doc = this.getItsNatHTMLDocument().getHTMLDocument();
            svgRootElems = this.processTreeSVGWebElements(doc);
        }
        String docMarkup = super.serializeDocument();
        if (useSVGWeb && svgRootElems != null && !svgRootElems.isEmpty()) {
            ResponseDelegateHTMLLoadDocImpl.restoreSVGWebElements(svgRootElems);
        }
        if (otherNSRootElemsInHTML != null) {
            this.fixOtherNSElementsInHTMLCleanAuxAttribs(otherNSElemsAttribs);
            this.fixOtherNSElementsInHTMLGenCode(otherNSRootElemsInHTML);
        }
        return docMarkup;
    }

    public void detectSVGWeb() {
        HTMLHeadElement head;
        LinkedList<Node> metaList;
        ItsNatHTMLDocumentImpl itsNatDoc = this.getItsNatHTMLDocument();
        HTMLDocument doc = itsNatDoc.getHTMLDocument();
        boolean svgWeb = false;
        boolean forceFlash = false;
        int metaDecPos = -1;
        String queryString = this.getResponseLoadDoc().getRequest().getItsNatServletRequest().getQueryStringInternal();
        if (queryString == null) {
            return;
        }
        if (queryString.contains("svg.render.forceflash=true")) {
            svgWeb = true;
            forceFlash = true;
        } else if (queryString.contains("svg.render.forceflash=false")) {
            svgWeb = true;
            forceFlash = false;
        }
        if (!svgWeb && (metaList = DOMUtilInternal.getChildElementListWithTagName(head = DOMUtilHTML.getHTMLHead(doc), "meta", true)) != null) {
            int i = 0;
            for (HTMLMetaElement hTMLMetaElement : metaList) {
                if (HTMLTemplateVersionDelegateImpl.isSVGWebMetaDeclarationStatic(hTMLMetaElement)) {
                    svgWeb = true;
                    forceFlash = hTMLMetaElement.getContent().toLowerCase().equals("true");
                    metaDecPos = i;
                    break;
                }
                ++i;
            }
        }
        if (svgWeb) {
            ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
            clientDoc.setSVGWebInfo(forceFlash, metaDecPos);
            this.addScriptFileToLoad("itsnat_svgweb.js");
        }
    }

    protected boolean isSVGRootElementProcessedBySVGWeb(Element elem) {
        ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
        return SVGWebInfoImpl.isSVGRootElementProcessedBySVGWebFlash(elem, clientDoc);
    }

    protected Map<Element, Element> processTreeSVGWebElements(HTMLDocument doc) {
        HTMLBodyElement body = (HTMLBodyElement)doc.getBody();
        HashMap<Element, Element> svgwebElems = new HashMap<Element, Element>();
        this.processTreeSVGWebElements(body, svgwebElems);
        if (svgwebElems.isEmpty()) {
            svgwebElems = null;
        }
        return svgwebElems;
    }

    protected Node processTreeSVGWebElements(Node node, Map<Element, Element> svgwebElems) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() != 1) {
            return node;
        }
        Element elem = (Element)node;
        if (this.isSVGRootElementProcessedBySVGWeb(elem)) {
            Element script = this.processSVGRootElemForSVGWeb(elem);
            svgwebElems.put(script, elem);
            return script;
        }
        if (elem.hasChildNodes()) {
            for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
                child = this.processTreeSVGWebElements(child, svgwebElems);
            }
        }
        return elem;
    }

    protected Element processSVGRootElemForSVGWeb(Element elem) {
        Document doc = elem.getOwnerDocument();
        Element script = doc.createElement("script");
        script.setAttribute("type", "image/svg+xml");
        elem.getParentNode().replaceChild(script, elem);
        script.appendChild(elem);
        return script;
    }

    protected static void restoreSVGWebElements(Map<Element, Element> svgRootElems) {
        if (svgRootElems != null) {
            for (Map.Entry<Element, Element> entry : svgRootElems.entrySet()) {
                Element script = entry.getKey();
                Element elem = entry.getValue();
                script.getParentNode().replaceChild(elem, script);
            }
        }
    }

    @Override
    protected void rewriteClientHTMLTextAreaProperties(HTMLTextAreaElement elem, StringBuilder code) {
        ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
        BrowserWeb browser = clientDoc.getBrowserWeb();
        String explicitValue = ((HTMLTextAreaElementImpl)elem).getValueProperty();
        if (explicitValue != null) {
            this.processUIControlProperty(elem, "value", code, clientDoc);
        } else {
            code.append("var elem = " + clientDoc.getNodeReference(elem, true, true) + ";\n");
            String content = DOMUtilInternal.getTextContent(elem, false);
            String valueJS = JSRenderImpl.toTransportableStringLiteral(content, browser);
            JSRenderPropertyImpl render = JSRenderPropertyImpl.getJSRenderProperty(elem, clientDoc.getBrowserWeb());
            PropertyImpl prop = render.getProperty(elem, "value");
            code.append(render.renderSetProperty(prop, elem, "elem", valueJS, content, clientDoc));
        }
    }

    protected abstract LinkedList<Element> fixOtherNSElementsInHTMLFindRootElems();

    protected abstract LinkedList<Attr> fixOtherNSElementsInHTMLSaveValidNames(LinkedList<Element> var1);

    protected abstract void fixOtherNSElementsInHTMLCleanAuxAttribs(LinkedList<Attr> var1);

    protected abstract void fixOtherNSElementsInHTMLGenCode(LinkedList<Element> var1);
}

