/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.resp.shared;

import java.util.LinkedList;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.domutil.ItsNatTreeWalker;
import org.itsnat.core.event.ParamTransport;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.browser.web.BrowserMSIEOld;
import org.itsnat.impl.core.browser.web.BrowserSVGPlugin;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.clientdoc.ClientDocumentAttachedClientImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.clientdoc.web.SVGWebInfoImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.itsnat.impl.core.listener.dom.domstd.OnLoadBackForwardListenerImpl;
import org.itsnat.impl.core.resp.ResponseLoadStfulDocumentValid;
import org.itsnat.impl.core.resp.shared.ResponseDelegateStfulLoadDocImpl;
import org.itsnat.impl.core.resp.shared.bybrow.web.ResponseDelegStfulLoadDocByWebBrowserImpl;
import org.itsnat.impl.core.scriptren.jsren.node.JSRenderPropertyImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLInputElement;
import org.w3c.dom.html.HTMLOptionElement;
import org.w3c.dom.html.HTMLSelectElement;
import org.w3c.dom.html.HTMLTextAreaElement;
import org.w3c.dom.views.DocumentView;

public abstract class ResponseDelegateStfulWebLoadDocImpl
extends ResponseDelegateStfulLoadDocImpl {
    protected static final String scriptLoadTimeStamp = Long.toString(System.currentTimeMillis());
    protected LinkedList<String> scriptFilesToLoad;

    public ResponseDelegateStfulWebLoadDocImpl(ResponseLoadStfulDocumentValid response) {
        super(response);
    }

    public ClientDocumentStfulDelegateWebImpl getClientDocumentStfulDelegateWeb() {
        return (ClientDocumentStfulDelegateWebImpl)this.getClientDocumentStfulDelegate();
    }

    public ResponseDelegStfulLoadDocByWebBrowserImpl getResponseDelegStfulLoadDocByWebBrowser() {
        return (ResponseDelegStfulLoadDocByWebBrowserImpl)this.delegByBrowser;
    }

    @Override
    public void dispatchRequestListeners() {
        ClientDocumentStfulImpl clientDoc = this.getClientDocumentStful();
        BrowserWeb browser = (BrowserWeb)clientDoc.getBrowser();
        if (browser.isCachedBackForwardExecutedScripts() && clientDoc.canReceiveALLNormalEvents()) {
            EventTarget target;
            String eventType;
            ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
            Document doc = itsNatDoc.getDocument();
            OnLoadBackForwardListenerImpl listener = new OnLoadBackForwardListenerImpl();
            ParamTransport[] extraParam = OnLoadBackForwardListenerImpl.createExtraParams();
            if (!(browser instanceof BrowserSVGPlugin)) {
                eventType = browser.isDOMContentLoadedSupported() ? "DOMContentLoaded" : "load";
                target = (EventTarget)((Object)((DocumentView)((Object)doc)).getDefaultView());
            } else {
                eventType = "SVGLoad";
                target = (EventTarget)((Object)doc.getDocumentElement());
            }
            clientDoc.addEventListener(target, eventType, listener, false, clientDoc.getCommMode(), extraParam, null, -1L, null);
        }
        super.dispatchRequestListeners();
    }

    @Override
    protected String generateFinalScriptsMarkup() {
        StringBuilder scriptsMarkup = new StringBuilder();
        LinkedList<String> list = new LinkedList<String>();
        list.add("itsnat.js");
        this.getResponseDelegStfulLoadDocByWebBrowser().fillFrameworkScriptFileNamesOfBrowser(list);
        if (this.hasScriptFilesToLoad()) {
            list.addAll(this.getScriptFilesToLoad());
        }
        StringBuilder fileNameList = new StringBuilder();
        int i = 0;
        for (String fileName : list) {
            if (i > 0) {
                fileNameList.append(',');
            }
            fileNameList.append(fileName);
            ++i;
        }
        int prevScriptsToRemove = 0;
        scriptsMarkup.append(this.generateFrameworkScriptElement(fileNameList.toString(), ++prevScriptsToRemove));
        scriptsMarkup.append(this.generateInitScriptElementCode(++prevScriptsToRemove));
        return scriptsMarkup.toString();
    }

    public String generateFrameworkScriptElement(String jsFileNameList, int loaderScriptNum) {
        Element scriptElem = this.createFrameworkScriptElement(jsFileNameList, loaderScriptNum);
        ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
        return itsNatDoc.serializeNode(scriptElem);
    }

    protected Element createFrameworkScriptElement(String jsFileNameList, int loaderScriptNum) {
        Element scriptElem = this.createScriptElement(loaderScriptNum);
        if (this.getResponseLoadStfulDocumentValid().isInlineLoadFrameworkScripts()) {
            this.loadFrameworkScriptElementInline(scriptElem, jsFileNameList);
        } else {
            this.loadFrameworkScriptElementWithURL(scriptElem, jsFileNameList);
        }
        return scriptElem;
    }

    protected void loadFrameworkScriptElementWithURL(Element scriptElem, String jsFileNameList) {
        StringBuilder jsPathFile = new StringBuilder();
        String servletPath = this.getServletPath();
        jsPathFile.append(servletPath + "?itsnat_action=" + "load_script" + "&itsnat_file=" + jsFileNameList + "&");
        jsPathFile.append("time=" + scriptLoadTimeStamp);
        this.setScriptURLAttribute(scriptElem, jsPathFile.toString());
    }

    protected void loadFrameworkScriptElementInline(Element scriptElem, String jsFileNameList) {
        String code = ResponseDelegateStfulWebLoadDocImpl.loadScriptList(jsFileNameList);
        this.setScriptContent(scriptElem, code);
    }

    protected String generateInitScriptElementCode(int prevScriptsToRemove) {
        Element scriptElem = this.createInitScriptElement(prevScriptsToRemove);
        ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
        return itsNatDoc.serializeNode(scriptElem);
    }

    protected Element createInitScriptElement(int prevScriptsToRemove) {
        ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
        StringBuilder code = new StringBuilder();
        Browser browser = this.getClientDocumentStful().getBrowser();
        code.append("(function(){\n");
        code.append(this.getInitScriptContentCode(prevScriptsToRemove) + "\n");
        code.append("})();");
        Element scriptElem = this.createScriptElement(prevScriptsToRemove);
        boolean loadScriptInline = itsNatDoc.isLoadScriptInline();
        if (loadScriptInline) {
            this.setScriptContent(scriptElem, code.toString());
        } else {
            ClientDocumentStfulImpl clientDoc = this.getClientDocumentStful();
            clientDoc.setScriptLoadCode(code.toString());
            StringBuilder url = new StringBuilder();
            url.append(this.getServletPath());
            url.append("?itsnat_action=load_script&itsnat_file=initial");
            url.append("&itsnat_client_id=" + clientDoc.getId());
            this.setScriptURLAttribute(scriptElem, url.toString());
        }
        return scriptElem;
    }

    protected Element createScriptElement(int loaderScriptNum) {
        ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
        Document doc = itsNatDoc.getDocument();
        Element script = doc.createElementNS(this.getDocumentNamespace(), "script");
        DOMUtilInternal.setAttribute(script, "type", this.getJavaScriptMIME());
        DOMUtilInternal.setAttribute(script, "id", "itsnat_load_script_" + Integer.toString(loaderScriptNum));
        return script;
    }

    @Override
    protected void rewriteClientUIControlProperties() {
        ClientDocumentStfulImpl clientDoc = this.getClientDocumentStful();
        if (!clientDoc.isScriptingEnabled()) {
            return;
        }
        boolean revertJSChanges = this.getResponseDelegStfulLoadDocByWebBrowser().getRevertJSChanges();
        String code = this.rewriteClientUIControlProperties(revertJSChanges);
        clientDoc.addCodeToSend(code);
    }

    public String rewriteClientUIControlProperties(boolean revertJSChanges) {
        ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
        Document doc = itsNatDoc.getDocument();
        StringBuilder code = new StringBuilder();
        Element elem = doc.getDocumentElement();
        do {
            this.rewriteClientUIControlProperties(elem, revertJSChanges, code);
        } while ((elem = ItsNatTreeWalker.getNextElement(elem)) != null);
        return code.toString();
    }

    protected abstract void rewriteClientUIControlProperties(Element var1, boolean var2, StringBuilder var3);

    protected boolean rewriteClientHTMLUIControlProperties(Element elem, boolean revertJSChanges, StringBuilder code) {
        ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
        if (!(elem instanceof HTMLElement)) {
            return false;
        }
        if (elem instanceof HTMLSelectElement) {
            HTMLSelectElement select = (HTMLSelectElement)elem;
            code.append("var elem = " + clientDoc.getNodeReference(elem, true, true) + ";\n");
            LinkedList<Node> options = DOMUtilInternal.getChildElementListWithTagNameNS(select, "http://www.w3.org/1999/xhtml", "option", true);
            if (options != null) {
                int i = 0;
                for (HTMLOptionElement hTMLOptionElement : options) {
                    String opref = "elem.options[" + i + "]";
                    this.processUIControlProperty(hTMLOptionElement, opref, "selected", code, clientDoc);
                    if (revertJSChanges) {
                        this.processUIControlProperty(hTMLOptionElement, opref, "value", code, clientDoc);
                    }
                    ++i;
                }
            }
        } else if (elem instanceof HTMLInputElement) {
            String type = elem.getAttribute("type");
            if (type.equals("checkbox") || type.equals("radio")) {
                this.processUIControlProperty(elem, "checked", code, clientDoc);
                if (revertJSChanges) {
                    this.processUIControlProperty(elem, "value", code, clientDoc);
                }
            } else if (type.equals("text") || type.equals("password")) {
                this.processUIControlProperty(elem, "value", code, clientDoc);
            } else if (revertJSChanges) {
                this.processUIControlProperty(elem, "value", code, clientDoc);
            }
        } else if (elem instanceof HTMLTextAreaElement) {
            this.rewriteClientHTMLTextAreaProperties((HTMLTextAreaElement)elem, code);
        }
        return true;
    }

    protected void processUIControlProperty(Element elem, String attrName, StringBuilder code, ClientDocumentStfulDelegateWebImpl clientDoc) {
        code.append("var elem = " + clientDoc.getNodeReference(elem, true, true) + ";\n");
        code.append(JSRenderPropertyImpl.renderUIControlProperty(elem, "elem", attrName, clientDoc));
    }

    protected void processUIControlProperty(Element elem, String elemVarName, String attrName, StringBuilder code, ClientDocumentStfulDelegateWebImpl clientDoc) {
        code.append(JSRenderPropertyImpl.renderUIControlProperty(elem, elemVarName, attrName, clientDoc));
    }

    protected String getWindowReference() {
        return "window";
    }

    @Override
    protected String getInitDocumentScriptCode(int prevScriptsToRemove) {
        boolean msie;
        boolean svgweb;
        ClientDocumentStfulDelegateWebImpl clientDocDelegate = this.getClientDocumentStfulDelegateWeb();
        ClientDocumentStfulImpl clientDoc = this.getClientDocumentStful();
        ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
        BrowserWeb browser = clientDocDelegate.getBrowserWeb();
        int browserType = browser.getTypeCode();
        int browserSubType = browser.getSubTypeCode();
        ItsNatSessionImpl itsNatSession = clientDoc.getItsNatSessionImpl();
        String token = itsNatSession.getToken();
        String sessionId = itsNatSession.getId();
        String clientId = clientDoc.getId();
        String servletPath = this.delegByBrowser.getServletPathForEvents();
        int errorMode = itsNatDoc.getClientErrorMode();
        StringBuilder code = new StringBuilder();
        String attachType = null;
        if (clientDoc instanceof ClientDocumentAttachedClientImpl) {
            attachType = ((ClientDocumentAttachedClientImpl)clientDoc).getAttachType();
        }
        code.append("\n");
        code.append("var win = " + this.getWindowReference() + ";\n");
        SVGWebInfoImpl svgWeb = clientDocDelegate.getSVGWebInfo();
        boolean bl = svgweb = svgWeb != null;
        if (svgweb) {
            msie = browser instanceof BrowserMSIEOld;
            int metaPos = -1;
            if (msie) {
                if (!svgWeb.hasMetaForceFlash()) {
                    throw new ItsNatException("Element <meta name='svg.render.forceflash' ..> is required when SVGWeb is used in MSIE");
                }
                metaPos = svgWeb.getMetaForceFlashPos();
            }
            code.append("itsnat_fix_svgweb(win," + msie + "," + metaPos + ");\n");
        }
        code.append("var itsnat = " + this.getResponseDelegStfulLoadDocByWebBrowser().getJSMethodInitName() + "(win);\n");
        if (svgweb) {
            msie = browser instanceof BrowserMSIEOld;
            code.append("itsnat_init_svgweb(win,itsnat," + msie + ");\n");
        }
        code.append("var itsNatDoc = new itsnat." + this.getJavaScriptDocumentName() + "();\n");
        code.append("itsNatDoc.init(document,win," + browserType + "," + browserSubType + ",\"" + token + "\",\"" + sessionId + "\",\"" + clientId + "\",\"" + servletPath + "\",\"" + attachType + "\"," + errorMode + "," + prevScriptsToRemove + ");\n");
        if (svgweb) {
            code.append("itsnat_extend_doc_svgweb(itsNatDoc);\n");
        }
        return code.toString();
    }

    public void addScriptFileToLoad(String code) {
        this.getScriptFilesToLoad().add(code);
    }

    public boolean hasScriptFilesToLoad() {
        return this.scriptFilesToLoad != null;
    }

    public LinkedList<String> getScriptFilesToLoad() {
        if (this.scriptFilesToLoad == null) {
            this.scriptFilesToLoad = new LinkedList();
        }
        return this.scriptFilesToLoad;
    }

    protected abstract void rewriteClientHTMLTextAreaProperties(HTMLTextAreaElement var1, StringBuilder var2);

    protected abstract void setScriptURLAttribute(Element var1, String var2);

    protected abstract String getJavaScriptMIME();

    protected abstract void setScriptContent(Element var1, String var2);

    protected abstract String getDocumentNamespace();

    protected abstract String getJavaScriptDocumentName();
}

