/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.resp.shared;

import java.io.InputStream;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.browser.droid.BrowserDroid;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.doc.droid.ItsNatStfulDroidDocumentImpl;
import org.itsnat.impl.core.doc.web.ItsNatHTMLDocumentImpl;
import org.itsnat.impl.core.doc.web.ItsNatOtherNSDocumentImpl;
import org.itsnat.impl.core.mut.doc.DocMutationEventListenerImpl;
import org.itsnat.impl.core.resp.ResponseLoadDocImpl;
import org.itsnat.impl.core.resp.ResponseLoadStfulDocumentValid;
import org.itsnat.impl.core.resp.shared.ResponseDelegateStfulDroidLoadDocImpl;
import org.itsnat.impl.core.resp.shared.ResponseDelegateStfulImpl;
import org.itsnat.impl.core.resp.shared.bybrow.web.ResponseDelegStfulLoadDocByBrowserImpl;
import org.itsnat.impl.core.resp.shared.html.ResponseDelegateHTMLLoadDocImpl;
import org.itsnat.impl.core.resp.shared.otherns.ResponseDelegateOtherNSLoadDocImpl;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;
import org.itsnat.impl.core.util.IOUtil;
import org.itsnat.impl.res.core.js.LoadScriptImpl;

public abstract class ResponseDelegateStfulLoadDocImpl
extends ResponseDelegateStfulImpl {
    protected StringBuilder fixDOMCode;
    protected ResponseDelegStfulLoadDocByBrowserImpl delegByBrowser = ResponseDelegStfulLoadDocByBrowserImpl.createResponseDelegStfulLoadDocByBrowser(this);

    public ResponseDelegateStfulLoadDocImpl(ResponseLoadStfulDocumentValid response) {
        super(response);
    }

    public static ResponseDelegateStfulLoadDocImpl createResponseDelegateStfulLoadDoc(ResponseLoadStfulDocumentValid responseParent) {
        Browser browser = responseParent.getClientDocument().getBrowser();
        ItsNatStfulDocumentImpl itsNatDoc = responseParent.getItsNatStfulDocument();
        if (itsNatDoc instanceof ItsNatStfulDroidDocumentImpl) {
            if (!(browser instanceof BrowserDroid)) {
                throw new ItsNatException("An Android layout only can be loaded by the ItsNat Droid Browser");
            }
            return new ResponseDelegateStfulDroidLoadDocImpl(responseParent);
        }
        if (!(browser instanceof BrowserWeb)) {
            throw new ItsNatException("A web layout cannot be loaded by the ItsNat Droid Browser");
        }
        if (itsNatDoc instanceof ItsNatHTMLDocumentImpl) {
            return ResponseDelegateHTMLLoadDocImpl.createResponseDelegateHTMLLoadDoc(responseParent);
        }
        if (itsNatDoc instanceof ItsNatOtherNSDocumentImpl) {
            return ResponseDelegateOtherNSLoadDocImpl.createResponseDelegateOtherNSLoadDoc(responseParent);
        }
        return null;
    }

    public ResponseLoadStfulDocumentValid getResponseLoadStfulDocumentValid() {
        return (ResponseLoadStfulDocumentValid)this.responseParent;
    }

    public ResponseLoadDocImpl getResponseLoadDoc() {
        return (ResponseLoadDocImpl)((Object)this.responseParent);
    }

    public void addFixDOMCodeToSend(String code) {
        this.getFixDOMCodeToSend().append(code);
    }

    public boolean hasFixDOMCodeToSend() {
        return this.fixDOMCode != null;
    }

    public StringBuilder getFixDOMCodeToSend() {
        if (this.fixDOMCode == null) {
            this.fixDOMCode = new StringBuilder();
        }
        return this.fixDOMCode;
    }

    public ItsNatStfulDocumentImpl getItsNatStfulDocument() {
        return this.responseParent.getItsNatStfulDocument();
    }

    public ClientDocumentStfulImpl getClientDocumentStful() {
        return this.getResponseLoadStfulDocumentValid().getClientDocumentStful();
    }

    public ClientDocumentStfulDelegateImpl getClientDocumentStfulDelegate() {
        return this.getClientDocumentStful().getClientDocumentStfulDelegate();
    }

    public boolean isSerializeBeforeDispatching() {
        return this.getResponseLoadStfulDocumentValid().isSerializeBeforeDispatching();
    }

    protected abstract void rewriteClientUIControlProperties();

    public String getServletPath() {
        ResponseLoadDocImpl parent = this.getResponseLoadDoc();
        boolean useAbsoluteURL = false;
        if (this.getClientDocumentStful().getBrowser().isNeededAbsoluteURL()) {
            useAbsoluteURL = true;
        } else if (this.getResponseLoadStfulDocumentValid().isNeededAbsoluteURL()) {
            useAbsoluteURL = true;
        }
        ItsNatServletRequestImpl itsNatRequest = parent.getRequestLoadDoc().getItsNatServletRequest();
        return itsNatRequest.getServletPath(useAbsoluteURL, true);
    }

    public void processResponse() {
        ItsNatStfulDocumentImpl itsNatDoc = this.getItsNatStfulDocument();
        DocMutationEventListenerImpl mutListener = itsNatDoc.getDocMutationEventListener();
        String docMarkup = null;
        boolean serializeBefore = this.isSerializeBeforeDispatching();
        if (serializeBefore) {
            mutListener.setEnabled(false);
            this.preSerializeDocument();
            docMarkup = this.serializeDocument();
            mutListener.setEnabled(true);
            this.rewriteClientUIControlProperties();
        }
        this.dispatchRequestListeners();
        if (!serializeBefore) {
            this.rewriteClientUIControlProperties();
            mutListener.setEnabled(false);
            this.preSerializeDocument();
            docMarkup = this.serializeDocument();
            mutListener.setEnabled(true);
        }
        docMarkup = this.addRequiredMarkupToTheEndOfDoc(docMarkup);
        ClientDocumentStfulImpl clientDoc = this.getClientDocumentStful();
        if (clientDoc.isScriptingEnabled()) {
            String scriptsMarkup = this.generateFinalScriptsMarkup();
            docMarkup = this.getResponseLoadStfulDocumentValid().isOnlyReturnMarkupOfFinalScripts() ? scriptsMarkup : this.addMarkupToTheEndOfDoc(docMarkup, scriptsMarkup);
        }
        this.getResponseLoadDoc().sendMarkupToClient(docMarkup);
    }

    protected String addRequiredMarkupToTheEndOfDoc(String docMarkup) {
        return docMarkup;
    }

    public void dispatchRequestListeners() {
        this.getResponseLoadDoc().dispatchRequestListeners();
    }

    protected String serializeDocument() {
        return this.getResponseLoadDoc().serializeDocument();
    }

    protected void preSerializeDocument() {
        this.getResponseLoadStfulDocumentValid().preSerializeDocumentStful();
    }

    protected String getLoadCodeUsingDocument() {
        return this.getResponseLoadDoc().getCodeToSendAndReset();
    }

    protected abstract String generateFinalScriptsMarkup();

    protected String getInitScriptContentCode(int prevScriptsToRemove) {
        StringBuilder code = new StringBuilder();
        code.append(this.getPreInitDocumentScriptCode());
        code.append(this.getInitDocumentAndLoadScriptCode(prevScriptsToRemove));
        return code.toString();
    }

    protected String getPreInitDocumentScriptCode() {
        String byBrowserCode;
        StringBuilder code = new StringBuilder();
        if (this.hasFixDOMCodeToSend()) {
            code.append((CharSequence)this.getFixDOMCodeToSend());
        }
        if ((byBrowserCode = this.delegByBrowser.getOnInitScriptContentCodeFixDOMCode()) != null) {
            code.append(byBrowserCode);
        }
        return code.toString();
    }

    protected String getInitDocumentAndLoadScriptCode(int prevScriptsToRemove) {
        StringBuilder code = new StringBuilder();
        code.append(this.getInitDocumentScriptCode(prevScriptsToRemove));
        code.append(this.getLoadCodeUsingDocument());
        return code.toString();
    }

    protected abstract String getInitDocumentScriptCode(int var1);

    public static String loadScriptList(String scriptNameList) {
        StringBuilder code = new StringBuilder();
        String[] scriptNameArray = scriptNameList.split(",");
        for (int i = 0; i < scriptNameArray.length; ++i) {
            String scriptName = scriptNameArray[i];
            ResponseDelegateStfulLoadDocImpl.loadScript(scriptName, code);
        }
        return code.toString();
    }

    public static void loadScript(String scriptName, StringBuilder code) {
        LoadScriptImpl.checkFileName(scriptName);
        InputStream input = LoadScriptImpl.class.getResourceAsStream(scriptName);
        IOUtil.readTextStream(input, "UTF-8", code);
    }

    protected abstract String addMarkupToTheEndOfDoc(String var1, String var2);
}

