/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.resp.attachsrv;

import javax.servlet.ServletResponse;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.browser.web.BrowserMSIEOld;
import org.itsnat.impl.core.clientdoc.ClientDocumentAttachedServerImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.req.attachsrv.RequestAttachedServerLoadDocImpl;
import org.itsnat.impl.core.req.norm.RequestNormalLoadDocAttachedServerImpl;
import org.itsnat.impl.core.resp.ResponseScript;
import org.itsnat.impl.core.resp.attachsrv.ResponseAttachedServerImpl;
import org.itsnat.impl.core.scriptren.jsren.JSRenderImpl;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;
import org.itsnat.impl.core.servlet.ItsNatServletResponseImpl;
import org.itsnat.impl.core.servlet.ServletResponseAttachedServer;
import org.itsnat.impl.core.template.ItsNatStfulDocumentTemplateAttachedServerImpl;
import org.itsnat.impl.core.template.MarkupTemplateVersionImpl;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public abstract class ResponseAttachedServerLoadDocImpl
extends ResponseAttachedServerImpl
implements ResponseScript {
    public ResponseAttachedServerLoadDocImpl(RequestAttachedServerLoadDocImpl request) {
        super(request);
    }

    public RequestAttachedServerLoadDocImpl getRequestAttachedServerLoadDoc() {
        return (RequestAttachedServerLoadDocImpl)this.request;
    }

    public ClientDocumentAttachedServerImpl getClientDocumentAttachedServer() {
        return this.getRequestAttachedServerLoadDoc().getClientDocumentAttachedServer();
    }

    @Override
    public void processResponse() {
        ClientDocumentAttachedServerImpl clientDocAS = this.getClientDocumentAttachedServer();
        ItsNatStfulDocumentTemplateAttachedServerImpl template = clientDocAS.getItsNatStfulDocumentTemplateAttachedServer();
        ItsNatServletResponseImpl itsNatResponse = this.getItsNatServletResponse();
        ItsNatServletRequestImpl itsNatRequest = itsNatResponse.getItsNatServletRequestImpl();
        ServletResponse responseOriginal = itsNatResponse.getServletResponse();
        ServletResponseAttachedServer servResWrapper = itsNatResponse.createServletResponseAttachedServer();
        itsNatResponse.setServletResponse(servResWrapper);
        RequestNormalLoadDocAttachedServerImpl delegRequest = new RequestNormalLoadDocAttachedServerImpl(template, this.getRequestAttachedServerLoadDoc(), itsNatRequest);
        itsNatRequest.setRequest(delegRequest);
        delegRequest.process(null);
        ClientDocumentStfulImpl clientDocNormal = delegRequest.getClientDocumentStful();
        Browser browser = clientDocNormal.getBrowser();
        itsNatResponse.setServletResponse(responseOriginal);
        String resultMarkup = servResWrapper.getString(delegRequest.getResponse().getEncoding());
        StringBuilder code = new StringBuilder();
        code.append("itsnat.clean();\n");
        code.append("try{ delete window.itsnat; }catch(ex){}\n");
        boolean useOnLoad = clientDocAS.isOnLoadHanderUsed();
        if (template.isMIME_HTML() && !useOnLoad) {
            String resultMarkupStringLiteral = JSRenderImpl.toTransportableStringLiteral(resultMarkup, true, browser);
            code.append("document.write(" + resultMarkupStringLiteral + ");\n");
        } else {
            ItsNatStfulDocumentImpl itsNatDoc = clientDocNormal.getItsNatStfulDocument();
            DocumentFragment docFrag = itsNatDoc.toDOM(resultMarkup);
            if (template.isMIME_XHTML() || template.isMIME_HTML() && useOnLoad) {
                code.append("var root = document.body;\n");
                code.append("if (!root) root = document.getElementsByTagName(\"body\")[0];\n");
            } else {
                code.append("var root = document.documentElement;\n");
            }
            for (Element script = (Element)docFrag.getFirstChild(); script != null; script = (Element)script.getNextSibling()) {
                CharacterData text = (CharacterData)script.getFirstChild();
                String scriptCode = text.getData();
                String prefix = "<![CDATA[";
                String suffix = "]]>";
                if (scriptCode.startsWith(prefix)) {
                    scriptCode = MarkupTemplateVersionImpl.removePrefixSuffix(scriptCode, prefix, suffix);
                }
                String scriptCodeLiteral = JSRenderImpl.toTransportableStringLiteral(scriptCode, true, browser);
                if (template.isMIME_HTML() && useOnLoad) {
                    code.append("var script = document.createElement(\"script\");\n");
                    code.append("script.setAttribute(\"id\",\"" + script.getAttribute("id") + "\");\n");
                    if (clientDocAS.getBrowser() instanceof BrowserMSIEOld) {
                        code.append("root.appendChild(script);");
                        code.append("eval(" + scriptCodeLiteral + ");\n");
                        continue;
                    }
                    code.append("script.appendChild(document.createTextNode(" + scriptCodeLiteral + "));");
                    code.append("root.appendChild(script);");
                    continue;
                }
                if (template.isMIME_XHTML() || template.isMIME_HTML() && useOnLoad) {
                    code.append("var script = document.createElement(\"script\");");
                    code.append("script.setAttribute(\"id\",\"" + script.getAttribute("id") + "\");");
                    code.append("script.appendChild(document.createCDATASection(" + scriptCodeLiteral + "));");
                    code.append("root.appendChild(script);");
                    continue;
                }
                if (template.isMIME_SVG()) {
                    code.append("var script = document.createElementNS(root.namespaceURI,\"script\");");
                    code.append("script.setAttribute(\"type\",\"application/ecmascript\");");
                    code.append("script.setAttribute(\"id\",\"" + script.getAttribute("id") + "\");");
                    code.append("script.appendChild(document.createCDATASection(" + scriptCodeLiteral + "));");
                    code.append("root.appendChild(script);");
                    continue;
                }
                if (template.isMIME_XUL()) {
                    code.append("var script = document.createElementNS(\"http://www.w3.org/1999/xhtml\",\"script\");");
                    code.append("script.setAttribute(\"id\",\"" + script.getAttribute("id") + "\");");
                    code.append("script.appendChild(document.createCDATASection(" + scriptCodeLiteral + "));");
                    code.append("root.appendChild(script);");
                    continue;
                }
                throw new ItsNatException("Unsupported MIME: " + template.getMIME());
            }
        }
        this.writeResponse(code.toString());
    }

    @Override
    public boolean isLoadByScriptElement() {
        return true;
    }
}

