/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.resp;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import javax.servlet.ServletResponse;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.UseGZip;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.browser.droid.BrowserDroid;
import org.itsnat.impl.core.browser.web.BrowserMSIEOld;
import org.itsnat.impl.core.clientdoc.ClientDocumentImpl;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.req.RequestImpl;
import org.itsnat.impl.core.resp.ResponseScript;
import org.itsnat.impl.core.servlet.ItsNatServletResponseImpl;

public abstract class ResponseImpl {
    protected RequestImpl request;
    protected ItsNatServletResponseImpl itsNatResponse;
    protected Writer writer;
    protected LinkedList<Object> codeToSend = new LinkedList();

    public ResponseImpl(RequestImpl request) {
        this.request = request;
        this.itsNatResponse = request.getItsNatServletRequest().getItsNatServletResponseImpl();
        request.setResponse(this);
        this.itsNatResponse.setResponse(this);
    }

    public RequestImpl getRequest() {
        return this.request;
    }

    public ItsNatServletResponseImpl getItsNatServletResponse() {
        return this.itsNatResponse;
    }

    public ItsNatDocumentImpl getItsNatDocument() {
        return this.request.getItsNatDocument();
    }

    public ClientDocumentImpl getClientDocument() {
        return this.request.getClientDocument();
    }

    private void addCodeFromClientDocAndReset() {
        ClientDocumentImpl listener = this.getClientDocument();
        if (listener == null) {
            return;
        }
        String code = listener.getCodeToSendAndReset();
        if (code == null || code.equals("")) {
            return;
        }
        this.codeToSend.add(code);
    }

    public String getCodeToSendAndReset() {
        this.itsNatResponse.getItsNatSessionImpl().endOfRequestBeforeSendCode();
        this.addCodeFromClientDocAndReset();
        StringBuilder code = new StringBuilder();
        if (!this.codeToSend.isEmpty()) {
            Iterator it = this.codeToSend.iterator();
            while (it.hasNext()) {
                Object codeFragment = it.next();
                it.remove();
                code.append(codeFragment.toString());
            }
            this.codeToSend.clear();
        }
        return code.toString();
    }

    public void addCodeToSend(Object newCode) {
        this.addCodeFromClientDocAndReset();
        this.codeToSend.add(newCode);
    }

    public void writeResponse(String text) {
        try {
            if (this.writer != null) {
                this.writer.write(text);
            }
        }
        catch (IOException ex) {
            throw new ItsNatException(ex);
        }
    }

    public void process() {
        this.preProcess();
        this.prepareResponse();
        try {
            this.writer = this.initWriter();
            this.processResponse();
            if (this.writer != null) {
                this.writer.close();
            }
            this.writer = null;
        }
        catch (IOException ex) {
            throw new ItsNatException(ex, (Object)this.itsNatResponse);
        }
        this.postProcess();
    }

    public Browser getBrowser() {
        ClientDocumentImpl clientDoc = this.getClientDocument();
        if (clientDoc != null) {
            return clientDoc.getBrowser();
        }
        return this.getItsNatServletResponse().getItsNatSessionImpl().getBrowser();
    }

    public void preProcess() {
    }

    public void postProcess() {
    }

    protected void prepareResponse() {
        this.itsNatResponse.prepareResponse();
        this.setResponseContentType();
    }

    protected void setResponseContentType() {
        ItsNatDocumentImpl itsNatDoc;
        Browser browser;
        String mime = this instanceof ResponseScript ? ((browser = this.getBrowser()) instanceof BrowserDroid ? "text/beanshell" : "text/javascript") : ((itsNatDoc = this.getItsNatDocument()) != null ? itsNatDoc.getMIME() : "text/html");
        String encoding = this.getEncoding();
        ServletResponse response = this.itsNatResponse.getServletResponse();
        response.setContentType(mime + ";charset=" + encoding);
    }

    public String getEncoding() {
        ItsNatDocumentImpl itsNatDoc = this.getItsNatDocument();
        if (itsNatDoc != null) {
            return itsNatDoc.getEncoding();
        }
        return this.getItsNatServletResponse().getItsNatServletImpl().getItsNatServletConfigImpl().getDefaultEncoding();
    }

    protected Writer initWriter() throws IOException {
        int useGZipConfig;
        boolean useGZip = false;
        ItsNatDocumentImpl itsNatDoc = this.getItsNatDocument();
        if (itsNatDoc != null && (useGZipConfig = itsNatDoc.getUseGZip()) != 0) {
            if (this instanceof ResponseScript) {
                if (UseGZip.isScriptUsingGZip(useGZipConfig)) {
                    useGZip = true;
                    if (((ResponseScript)((Object)this)).isLoadByScriptElement() && this.getClientDocument().getBrowser() instanceof BrowserMSIEOld) {
                        useGZip = false;
                    }
                }
            } else {
                useGZip = UseGZip.isMarkupUsingGZip(useGZipConfig);
            }
        }
        if (useGZip) {
            return this.itsNatResponse.getWriterGZip();
        }
        return this.itsNatResponse.getWriter();
    }

    protected abstract void processResponse();
}

