/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.resp;

import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.browser.web.BrowserMSIEOld;
import org.itsnat.impl.core.browser.web.webkit.BrowserWebKit;
import org.itsnat.impl.core.clientdoc.ClientDocumentImpl;
import org.itsnat.impl.core.resp.ResponseEventDelegateImpl;
import org.itsnat.impl.core.resp.ResponseImpl;
import org.itsnat.impl.core.scriptren.jsren.JSRenderImpl;

public class ResponseEventDelegateWebImpl
extends ResponseEventDelegateImpl {
    public ResponseEventDelegateWebImpl(ResponseImpl response) {
        super(response);
    }

    @Override
    public void sendPendingCode(String code, boolean error) {
        ClientDocumentImpl clientDoc;
        Browser browser;
        if (this.isScriptOrScriptHoldMode()) {
            Browser browser2 = this.response.getClientDocument().getBrowser();
            StringBuilder codeBuff = new StringBuilder();
            codeBuff.append("var elem = document.getElementById(\"" + this.scriptId + "\");\n");
            codeBuff.append("if (elem != null)");
            codeBuff.append("{\n");
            codeBuff.append("  elem.executed = true;\n");
            if (error) {
                codeBuff.append("  elem.error = true;\n");
                codeBuff.append("  elem.code = " + JSRenderImpl.toTransportableStringLiteral(code, browser2) + ";\n");
            } else if (browser2 instanceof BrowserMSIEOld) {
                codeBuff.append("  elem.code = " + JSRenderImpl.toTransportableStringLiteral(code, browser2) + ";\n");
            } else {
                codeBuff.append("  elem.code = function (event,itsNatDoc)\n");
                codeBuff.append("   {\n");
                codeBuff.append(code);
                codeBuff.append("   };\n");
            }
            codeBuff.append("}\n");
            code = codeBuff.toString();
        }
        if (code.length() == 0 && (browser = (clientDoc = this.response.getClientDocument()).getBrowser()) instanceof BrowserWebKit && ((BrowserWebKit)browser).isAJAXEmptyResponseFails()) {
            code = "          ";
        }
        this.response.writeResponse(code);
    }
}

