/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.resp;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletRequest;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.browser.droid.BrowserDroid;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.resp.ResponseEventDelegateDroidImpl;
import org.itsnat.impl.core.resp.ResponseEventDelegateWebImpl;
import org.itsnat.impl.core.resp.ResponseImpl;

public abstract class ResponseEventDelegateImpl {
    protected ResponseImpl response;
    protected String scriptId = null;

    public ResponseEventDelegateImpl(ResponseImpl response) {
        this.response = response;
        ServletRequest servRequest = response.getRequest().getItsNatServletRequest().getServletRequest();
        this.scriptId = servRequest.getParameter("itsnat_script_evt_id");
    }

    public static ResponseEventDelegateImpl createResponseEventDelegate(ResponseImpl response) {
        Browser browser = response.getClientDocument().getBrowser();
        if (browser instanceof BrowserWeb) {
            return new ResponseEventDelegateWebImpl(response);
        }
        if (browser instanceof BrowserDroid) {
            return new ResponseEventDelegateDroidImpl(response);
        }
        return null;
    }

    protected void processResponseOnException(RuntimeException ex) {
        if (!this.isScriptOrScriptHoldMode()) {
            throw ex;
        }
        ex.printStackTrace();
        StringWriter writer = new StringWriter();
        PrintWriter str = new PrintWriter(writer);
        ex.printStackTrace(str);
        str.flush();
        this.sendPendingCode(writer.toString(), true);
    }

    public void sendPendingCode() {
        String code = this.response.getCodeToSendAndReset();
        this.sendPendingCode(code, false);
    }

    public boolean isScriptOrScriptHoldMode() {
        return this.scriptId != null;
    }

    public abstract void sendPendingCode(String var1, boolean var2);

    public boolean isLoadByScriptElement() {
        return this.isScriptOrScriptHoldMode();
    }
}

