/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.req.norm;

import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.req.ContainsItsNatStfulDocumentReferrer;
import org.itsnat.impl.core.req.RequestLoadDocImpl;
import org.itsnat.impl.core.req.norm.RequestNormal;
import org.itsnat.impl.core.req.norm.RequestNormalLoadDocDefaultImpl;
import org.itsnat.impl.core.req.norm.RequestNormalLoadDocNotFoundImpl;
import org.itsnat.impl.core.resp.norm.ResponseNormal;
import org.itsnat.impl.core.resp.norm.ResponseNormalLoadDocBaseImpl;
import org.itsnat.impl.core.servlet.ItsNatServletImpl;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;
import org.itsnat.impl.core.template.ItsNatDocumentTemplateImpl;
import org.itsnat.impl.core.template.ItsNatStfulDocumentTemplateAttachedServerImpl;

public abstract class RequestNormalLoadDocBaseImpl
extends RequestLoadDocImpl
implements RequestNormal,
ContainsItsNatStfulDocumentReferrer {
    protected ItsNatStfulDocumentImpl itsNatDocReferrer;
    protected boolean stateless;

    public RequestNormalLoadDocBaseImpl(ItsNatServletRequestImpl itsNatRequest, boolean stateless) {
        super(itsNatRequest);
        this.stateless = stateless;
    }

    public static RequestNormalLoadDocBaseImpl createRequestNormalLoadDocBase(String docName, ItsNatServletRequestImpl itsNatRequest, boolean stateless) {
        ItsNatServletImpl itsNatServlet = itsNatRequest.getItsNatServletImpl();
        ItsNatDocumentTemplateImpl docTemplate = itsNatServlet.getItsNatDocumentTemplateImpl(docName);
        if (docTemplate == null) {
            return new RequestNormalLoadDocNotFoundImpl(docName, itsNatRequest, stateless);
        }
        if (docTemplate instanceof ItsNatStfulDocumentTemplateAttachedServerImpl) {
            throw new ItsNatException("Document/page " + docName + " is of type attached server, not valid in this context", (Object)itsNatRequest);
        }
        return new RequestNormalLoadDocDefaultImpl(docTemplate, itsNatRequest, stateless);
    }

    public boolean isStateless() {
        return this.stateless;
    }

    @Override
    public ItsNatStfulDocumentImpl getItsNatStfulDocumentReferrer() {
        return this.itsNatDocReferrer;
    }

    @Override
    public void setItsNatStfulDocumentReferrer(ItsNatStfulDocumentImpl itsNatDocReferrer) {
        this.itsNatDocReferrer = itsNatDocReferrer;
    }

    @Override
    public ResponseNormal getResponseNormal() {
        return (ResponseNormal)((Object)this.response);
    }

    public ResponseNormalLoadDocBaseImpl getResponseNormalLoadDocBase() {
        return (ResponseNormalLoadDocBaseImpl)this.response;
    }

    @Override
    protected boolean isMustNotifyEndOfRequestToSession() {
        return !this.isStateless();
    }
}

