/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.req.norm;

import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentWithoutDocumentDefaultImpl;
import org.itsnat.impl.core.doc.ItsNatDocSynchronizerImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.req.RequestEventStfulImpl;
import org.itsnat.impl.core.req.norm.RequestDOMEventStatelessImpl;
import org.itsnat.impl.core.req.norm.RequestDOMExtEventOtherImpl;
import org.itsnat.impl.core.req.norm.RequestDOMStdEventImpl;
import org.itsnat.impl.core.req.norm.RequestDroidEventImpl;
import org.itsnat.impl.core.req.norm.RequestGenericTaskEventImpl;
import org.itsnat.impl.core.req.norm.RequestNormal;
import org.itsnat.impl.core.resp.ResponseEventDoNothingImpl;
import org.itsnat.impl.core.resp.norm.ResponseNormal;
import org.itsnat.impl.core.resp.norm.ResponseNormalEventErrorLostClientDocImpl;
import org.itsnat.impl.core.resp.norm.ResponseNormalEventErrorLostSessionImpl;
import org.itsnat.impl.core.resp.norm.ResponseNormalEventImpl;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionImpl;

public abstract class RequestNormalEventImpl
extends RequestEventStfulImpl
implements RequestNormal {
    protected int evtType;

    public RequestNormalEventImpl(int evtType, ItsNatServletRequestImpl itsNatRequest) {
        super(itsNatRequest);
        this.evtType = evtType;
    }

    public static RequestNormalEventImpl createRequestNormalEvent(int evtType, ItsNatServletRequestImpl itsNatRequest) {
        switch (evtType) {
            case 1: {
                return new RequestDOMStdEventImpl(evtType, itsNatRequest);
            }
            case 11: {
                return new RequestDroidEventImpl(evtType, itsNatRequest);
            }
            case 2: 
            case 5: 
            case 6: {
                return new RequestDOMExtEventOtherImpl(evtType, itsNatRequest);
            }
            case 10: {
                return new RequestDOMEventStatelessImpl(evtType, itsNatRequest);
            }
            case 3: 
            case 4: {
                return new RequestGenericTaskEventImpl(evtType, itsNatRequest);
            }
        }
        throw new ItsNatException("Malformed URL/request, bad itsnat_eventType: " + evtType);
    }

    @Override
    public ResponseNormal getResponseNormal() {
        return (ResponseNormal)((Object)this.response);
    }

    public ResponseNormalEventImpl getResponseNormalEvent() {
        return (ResponseNormalEventImpl)this.response;
    }

    @Override
    public ClientDocumentStfulImpl getClientDocumentStfulById(String clientId) {
        ItsNatSessionImpl session = this.getItsNatSession();
        return session.getClientDocumentStfulById(clientId);
    }

    @Override
    public void processClientDocument(ClientDocumentStfulImpl clientDoc) {
        this.checkCanReceiveSOMENormalEvents(clientDoc);
        String listenerId = this.getEventListenerId();
        this.processClientDocument2(listenerId, clientDoc);
    }

    public void checkCanReceiveSOMENormalEvents(ClientDocumentStfulImpl clientDoc) {
        if (!clientDoc.canReceiveSOMENormalEvents()) {
            throw new ItsNatException("Security violation attempt");
        }
    }

    public String getEventListenerId() {
        return this.getAttrOrParamExist("itsnat_listener_id");
    }

    protected void processClientDocument2(final String listenerId, final ClientDocumentStfulImpl clientDoc) {
        ItsNatStfulDocumentImpl itsNatDoc = clientDoc.getItsNatStfulDocument();
        ItsNatDocSynchronizerImpl syncTask = new ItsNatDocSynchronizerImpl(){

            @Override
            protected void syncMethod() {
                RequestNormalEventImpl.this.processClientDocumentThreadSync(listenerId, clientDoc);
            }
        };
        syncTask.exec(itsNatDoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processClientDocumentThreadSync(String listenerId, ClientDocumentStfulImpl clientDoc) {
        this.bindClientToRequest(clientDoc);
        try {
            this.response = this.createResponseNormalEvent(listenerId, clientDoc);
            if (this.response != null) {
                this.response.process();
            }
        }
        finally {
            this.unbindRequestFromDocument();
        }
    }

    public abstract ResponseNormalEventImpl createResponseNormalEvent(String var1, ClientDocumentStfulImpl var2);

    @Override
    public void processLostSessionOrClientUnloading() {
        ItsNatSessionImpl session = this.getItsNatSession();
        ClientDocumentWithoutDocumentDefaultImpl clientDoc = new ClientDocumentWithoutDocumentDefaultImpl(session);
        this.bindClientToRequest(clientDoc, false);
        this.response = new ResponseEventDoNothingImpl(this);
        this.response.process();
    }

    @Override
    public void processClientDocumentNotFoundError(String clientId) {
        ItsNatSessionImpl session = this.getItsNatSession();
        ClientDocumentWithoutDocumentDefaultImpl clientDoc = new ClientDocumentWithoutDocumentDefaultImpl(session);
        this.bindClientToRequest(clientDoc, false);
        this.response = new ResponseNormalEventErrorLostClientDocImpl(this, clientId);
        this.response.process();
    }

    @Override
    public void processLostSessionError(String sessionId, String sessionToken) {
        ItsNatSessionImpl session = this.getItsNatSession();
        ClientDocumentWithoutDocumentDefaultImpl clientDoc = new ClientDocumentWithoutDocumentDefaultImpl(session);
        this.bindClientToRequest(clientDoc, false);
        this.response = new ResponseNormalEventErrorLostSessionImpl(this);
        this.response.process();
    }

    public abstract boolean isLoadEvent();
}

