/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.req.attachcli;

import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.clientdoc.ClientDocumentAttachedClientCometImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentAttachedClientErrorImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentAttachedClientImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentAttachedClientNotRefreshImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentAttachedClientTimerImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.doc.BoundElementDocContainerImpl;
import org.itsnat.impl.core.doc.ItsNatDocSynchronizerImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.event.client.ItsNatAttachedClientEventCometImpl;
import org.itsnat.impl.core.event.client.ItsNatAttachedClientEventImpl;
import org.itsnat.impl.core.event.client.ItsNatAttachedClientEventNotRefreshImpl;
import org.itsnat.impl.core.event.client.ItsNatAttachedClientEventTimerImpl;
import org.itsnat.impl.core.listener.attachcli.ItsNatAttachedClientEventListenerUtil;
import org.itsnat.impl.core.req.RequestLoadDocImpl;
import org.itsnat.impl.core.req.attachcli.RequestAttachedClient;
import org.itsnat.impl.core.req.shared.RequestDelegateLoadDocImpl;
import org.itsnat.impl.core.resp.attachcli.ResponseAttachedClient;
import org.itsnat.impl.core.resp.attachcli.ResponseAttachedClientLoadDocErrorNotDocImpl;
import org.itsnat.impl.core.resp.attachcli.ResponseAttachedClientLoadDocErrorNotDocInContainerImpl;
import org.itsnat.impl.core.resp.attachcli.ResponseAttachedClientLoadDocErrorNotSessionImpl;
import org.itsnat.impl.core.resp.attachcli.ResponseAttachedClientLoadDocErrorParentElementNotFoundImpl;
import org.itsnat.impl.core.resp.attachcli.ResponseAttachedClientLoadDocImpl;
import org.itsnat.impl.core.servlet.ItsNatServletContextImpl;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionImpl;
import org.itsnat.impl.core.util.MiscUtil;

public class RequestAttachedClientLoadDocImpl
extends RequestLoadDocImpl
implements RequestAttachedClient {
    protected RequestDelegateLoadDocImpl delegate = new RequestDelegateLoadDocImpl(this);

    public RequestAttachedClientLoadDocImpl(ItsNatServletRequestImpl itsNatRequest) {
        super(itsNatRequest);
    }

    public static RequestAttachedClientLoadDocImpl createRequestAttachedClientLoadDoc(ItsNatServletRequestImpl itsNatRequest) {
        return new RequestAttachedClientLoadDocImpl(itsNatRequest);
    }

    @Override
    public ItsNatStfulDocumentImpl getItsNatStfulDocumentReferrer() {
        return null;
    }

    @Override
    public ItsNatStfulDocumentImpl getItsNatStfulDocument() {
        return (ItsNatStfulDocumentImpl)this.getItsNatDocument();
    }

    @Override
    public ResponseAttachedClient getResponseAttachedClient() {
        return (ResponseAttachedClient)((Object)this.response);
    }

    public ResponseAttachedClientLoadDocImpl getResponseAttachedClientLoadDoc() {
        return (ResponseAttachedClientLoadDocImpl)this.response;
    }

    public ClientDocumentAttachedClientImpl getParentClientDocumentAttachedClient() {
        ItsNatSessionImpl sessionParent = this.delegate.getBoundParentItsNatSession();
        if (sessionParent == null) {
            return null;
        }
        String clientParentId = this.getAttrOrParam("itsnat_client_parent_id");
        if (clientParentId == null) {
            return null;
        }
        return sessionParent.getClientDocumentAttachedClientById(clientParentId);
    }

    @Override
    public void processRequest(ClientDocumentStfulImpl clientDocStateless) {
        ClientDocumentAttachedClientImpl clientDoc;
        ItsNatStfulDocumentImpl itsNatDoc = null;
        ClientDocumentAttachedClientImpl parentClientDoc = this.getParentClientDocumentAttachedClient();
        if (parentClientDoc != null) {
            ItsNatStfulDocumentImpl parentItsNatDoc = parentClientDoc.getItsNatStfulDocument();
            BoundElementDocContainerImpl bindInfo = this.delegate.getBoundElementDocContainer(parentItsNatDoc);
            if (bindInfo == null) {
                this.processParentElementNotFound();
                return;
            }
            itsNatDoc = (ItsNatStfulDocumentImpl)bindInfo.getContentItsNatDocument();
            long timeout = parentClientDoc.getWaitDocTimeout();
            if (itsNatDoc == null && timeout > 0L) {
                long lapse = 0L;
                long t = timeout / 1275L;
                if (t == 0L) {
                    t = 1L;
                }
                for (int i = 1; i <= 50; ++i) {
                    try {
                        Thread.sleep(t);
                    }
                    catch (Exception ex) {
                        throw new ItsNatException(ex);
                    }
                    itsNatDoc = (ItsNatStfulDocumentImpl)bindInfo.getContentItsNatDocument();
                    if (itsNatDoc != null || (lapse += t) >= timeout) break;
                    t = (long)(i + 1) * timeout / 1275L;
                    if (t != 0L) continue;
                    t = 1L;
                }
            }
            if (itsNatDoc == null || itsNatDoc.isInvalid()) {
                this.processChildDocInDocContainerNotFound();
                return;
            }
            String refreshMethod = parentClientDoc.getRefreshMethod();
            int refreshInterval = -1;
            if (parentClientDoc instanceof ClientDocumentAttachedClientTimerImpl) {
                refreshInterval = ((ClientDocumentAttachedClientTimerImpl)parentClientDoc).getRefreshInterval();
            }
            int commMode = parentClientDoc.getCommModeDeclared();
            long eventTimeout = parentClientDoc.getEventTimeout();
            long waitDocTimeout = parentClientDoc.getWaitDocTimeout();
            boolean readOnly = parentClientDoc.isReadOnly();
            clientDoc = this.requestAuthorization(itsNatDoc, refreshMethod, refreshInterval, commMode, eventTimeout, waitDocTimeout, readOnly);
        } else {
            String targetSessionId = this.getAttrOrParamExist("itsnat_session_id");
            ItsNatServletContextImpl context = this.itsNatRequest.getItsNatServletContext();
            ItsNatSessionImpl targetSession = context.findItsNatSessionByItsNatId(targetSessionId);
            if (targetSession == null) {
                this.processTargetSessionNotFound(targetSessionId);
                return;
            }
            String targetDocId = this.getAttrOrParamExist("itsnat_doc_id");
            itsNatDoc = targetSession.getItsNatStfulDocumentById(targetDocId);
            if (itsNatDoc == null || itsNatDoc.isInvalid()) {
                this.processTargetDocumentNotFound(targetSessionId, targetDocId);
                return;
            }
            clientDoc = this.requestAuthorization(itsNatDoc);
        }
        if (clientDoc == null) {
            return;
        }
        ItsNatDocSynchronizerImpl syncTask = new ItsNatDocSynchronizerImpl(){

            @Override
            protected void syncMethod() {
                RequestAttachedClientLoadDocImpl.this.processThreadSync(clientDoc);
            }
        };
        syncTask.exec(itsNatDoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processThreadSync(ClientDocumentAttachedClientImpl clientDoc) {
        ItsNatStfulDocumentImpl itsNatDoc = clientDoc.getItsNatStfulDocument();
        if (itsNatDoc.isInvalid()) {
            String targetSessionId = itsNatDoc.getClientDocumentOwnerImpl().getItsNatSessionImpl().getId();
            String targetDocId = itsNatDoc.getId();
            this.processTargetDocumentNotFound(targetSessionId, targetDocId);
            return;
        }
        try {
            this.bindClientToRequest(clientDoc);
            clientDoc.setPhase(2);
            try {
                this.response = ResponseAttachedClientLoadDocImpl.createResponseAttachedClientLoadDoc(this);
                this.response.process();
                if (clientDoc.isInvalid()) {
                    clientDoc.setPhase(4);
                    clientDoc.invalidateAndUnregister();
                } else {
                    clientDoc.setPhase(3);
                }
            }
            catch (RuntimeException ex) {
                clientDoc.invalidateAndUnregister();
                throw ex;
            }
        }
        finally {
            this.unbindRequestFromDocument();
        }
    }

    public ClientDocumentAttachedClientImpl requestAuthorization(ItsNatStfulDocumentImpl itsNatDoc) {
        boolean readOnly;
        String commModeStr = this.getAttrOrParam("itsnat_comm_mode");
        int commMode = commModeStr != null ? Integer.parseInt(commModeStr) : itsNatDoc.getCommMode();
        String eventTimeoutStr = this.getAttrOrParam("itsnat_event_timeout");
        long eventTimeout = eventTimeoutStr != null ? Long.parseLong(eventTimeoutStr) : itsNatDoc.getEventTimeout();
        String waitDocTimeoutStr = this.getAttrOrParam("itsnat_wait_doc_timeout");
        long waitDocTimeout = waitDocTimeoutStr != null ? Long.parseLong(waitDocTimeoutStr) : 0L;
        String readOnlyStr = this.getAttrOrParam("itsnat_read_only");
        if (readOnlyStr != null) {
            try {
                readOnly = MiscUtil.getBoolean(readOnlyStr);
            }
            catch (Exception ex) {
                throw new ItsNatException(ex);
            }
        } else {
            readOnly = true;
        }
        String refreshMethod = this.getAttrOrParam("itsnat_refresh_method");
        if (refreshMethod == null) {
            refreshMethod = "none";
        }
        int refreshInterval = -1;
        if (refreshMethod.equals("timer")) {
            refreshInterval = Integer.parseInt(this.getAttrOrParamExist("itsnat_refresh_interval"));
        }
        return this.requestAuthorization(itsNatDoc, refreshMethod, refreshInterval, commMode, eventTimeout, waitDocTimeout, readOnly);
    }

    public ClientDocumentAttachedClientImpl requestAuthorization(ItsNatStfulDocumentImpl itsNatDoc, String refreshMethod, int refreshInterval, int commMode, long eventTimeout, long waitDocTimeout, boolean readOnly) {
        Browser browser = itsNatDoc.getItsNatStfulDocumentTemplateVersion().getBrowser(this.itsNatRequest);
        ItsNatSessionImpl itsNatSession = this.itsNatRequest.getItsNatSessionImpl();
        ClientDocumentAttachedClientImpl clientDoc = null;
        if (refreshMethod.equals("timer")) {
            clientDoc = new ClientDocumentAttachedClientTimerImpl(readOnly, refreshInterval, commMode, eventTimeout, waitDocTimeout, browser, itsNatSession, itsNatDoc);
        } else if (refreshMethod.equals("comet")) {
            clientDoc = new ClientDocumentAttachedClientCometImpl(readOnly, commMode, eventTimeout, waitDocTimeout, browser, itsNatSession, itsNatDoc);
        } else if (refreshMethod.equals("none")) {
            clientDoc = new ClientDocumentAttachedClientNotRefreshImpl(readOnly, commMode, eventTimeout, waitDocTimeout, browser, itsNatSession, itsNatDoc);
        } else {
            throw new ItsNatException("Unrecognized refresh method: \"" + refreshMethod + "\"", (Object)this.itsNatRequest);
        }
        this.bindClientToRequest(clientDoc, false);
        ItsNatAttachedClientEventImpl requestEvent = this.createItsNatAttachedClientEvent(clientDoc);
        boolean wasProcessed = ItsNatAttachedClientEventListenerUtil.handleEventIncludingGlobalListeners(requestEvent);
        if (!requestEvent.isAccepted()) {
            if (wasProcessed) {
                return null;
            }
            throw new ItsNatException("Request to remote control the document/page \"" + itsNatDoc.getItsNatDocumentTemplateImpl().getName() + "\" is not accepted", (Object)this.itsNatRequest);
        }
        commMode = clientDoc.getCommModeDeclared();
        if (!clientDoc.isReadOnly() && clientDoc instanceof ClientDocumentAttachedClientCometImpl && (commMode == 3 || commMode == 1 || commMode == 5)) {
            throw new ItsNatException("Sync modes ASYNC_HOLD and SYNC and SCRIPT_HOLD are not valid in full remote control and Comet");
        }
        return clientDoc;
    }

    public void processTargetSessionNotFound(String targetSessionId) {
        this.prepareErrorResponse();
        this.response = new ResponseAttachedClientLoadDocErrorNotSessionImpl(targetSessionId, this);
        this.response.process();
    }

    public void processTargetDocumentNotFound(String targetSessionId, String targetDocId) {
        this.prepareErrorResponse();
        this.response = new ResponseAttachedClientLoadDocErrorNotDocImpl(targetSessionId, targetDocId, this);
        this.response.process();
    }

    public void processChildDocInDocContainerNotFound() {
        this.prepareErrorResponse();
        this.response = new ResponseAttachedClientLoadDocErrorNotDocInContainerImpl(this);
        this.response.process();
    }

    public void processParentElementNotFound() {
        this.prepareErrorResponse();
        this.response = new ResponseAttachedClientLoadDocErrorParentElementNotFoundImpl(this);
        this.response.process();
    }

    public void prepareErrorResponse() {
        ItsNatSessionImpl session = this.getItsNatSession();
        ClientDocumentAttachedClientErrorImpl clientDoc = new ClientDocumentAttachedClientErrorImpl(session);
        clientDoc.setPhase(1);
        this.bindClientToRequest(clientDoc, false);
    }

    public ItsNatAttachedClientEventImpl createItsNatAttachedClientEvent(ClientDocumentAttachedClientImpl clientDoc) {
        if (clientDoc instanceof ClientDocumentAttachedClientTimerImpl) {
            return new ItsNatAttachedClientEventTimerImpl(this);
        }
        if (clientDoc instanceof ClientDocumentAttachedClientCometImpl) {
            return new ItsNatAttachedClientEventCometImpl(this);
        }
        if (clientDoc instanceof ClientDocumentAttachedClientNotRefreshImpl) {
            return new ItsNatAttachedClientEventNotRefreshImpl(this);
        }
        return null;
    }

    @Override
    protected boolean isMustNotifyEndOfRequestToSession() {
        return true;
    }
}

