/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.req.attachcli;

import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.clientdoc.ClientDocumentAttachedClientErrorImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentAttachedClientImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.doc.ItsNatDocSynchronizerImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.req.RequestEventStfulImpl;
import org.itsnat.impl.core.req.attachcli.RequestAttachedClient;
import org.itsnat.impl.core.req.attachcli.RequestAttachedClientEventCometImpl;
import org.itsnat.impl.core.req.attachcli.RequestAttachedClientEventNotRefreshImpl;
import org.itsnat.impl.core.req.attachcli.RequestAttachedClientEventTimerImpl;
import org.itsnat.impl.core.resp.ResponseEventDoNothingImpl;
import org.itsnat.impl.core.resp.attachcli.ResponseAttachedClient;
import org.itsnat.impl.core.resp.attachcli.ResponseAttachedClientErrorEventLostClientDocImpl;
import org.itsnat.impl.core.resp.attachcli.ResponseAttachedClientErrorEventLostSessionImpl;
import org.itsnat.impl.core.resp.attachcli.ResponseAttachedClientEventImpl;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionImpl;

public abstract class RequestAttachedClientEventImpl
extends RequestEventStfulImpl
implements RequestAttachedClient {
    public RequestAttachedClientEventImpl(ItsNatServletRequestImpl itsNatRequest) {
        super(itsNatRequest);
    }

    public static RequestAttachedClientEventImpl createRequestAttachedClientEvent(int evtType, ItsNatServletRequestImpl itsNatRequest) {
        switch (evtType) {
            case 7: {
                return new RequestAttachedClientEventTimerImpl(itsNatRequest);
            }
            case 8: {
                return new RequestAttachedClientEventCometImpl(itsNatRequest);
            }
            case 9: {
                return new RequestAttachedClientEventNotRefreshImpl(itsNatRequest);
            }
        }
        throw new ItsNatException("Malformed URL/request");
    }

    @Override
    public ResponseAttachedClient getResponseAttachedClient() {
        return (ResponseAttachedClient)((Object)this.response);
    }

    public ResponseAttachedClientEventImpl getResponseAttachedClientEvent() {
        return (ResponseAttachedClientEventImpl)this.response;
    }

    @Override
    public boolean isUnloadEvent() {
        String unloadParam = this.getAttrOrParam("itsnat_unload");
        return unloadParam != null && unloadParam.equals("true");
    }

    @Override
    public ClientDocumentStfulImpl getClientDocumentStfulById(String clientId) {
        ItsNatSessionImpl session = this.getItsNatSession();
        return session.getClientDocumentAttachedClientById(clientId);
    }

    @Override
    public void processClientDocument(ClientDocumentStfulImpl clientDoc) {
        this.processClientDocumentAttachedClient((ClientDocumentAttachedClientImpl)clientDoc);
    }

    public void processClientDocumentAttachedClient(final ClientDocumentAttachedClientImpl clientDoc) {
        ItsNatStfulDocumentImpl itsNatDoc = clientDoc.getItsNatStfulDocument();
        ItsNatDocSynchronizerImpl syncTask = new ItsNatDocSynchronizerImpl(){

            @Override
            protected void syncMethod() {
                RequestAttachedClientEventImpl.this.processClientDocumentAttachedClientThreadSync(clientDoc);
            }
        };
        syncTask.exec(itsNatDoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processClientDocumentAttachedClientThreadSync(ClientDocumentAttachedClientImpl clientDoc) {
        this.bindClientToRequest(clientDoc);
        try {
            if (this.isUnloadEvent()) {
                clientDoc.setPhase(4);
                this.response = this.createResponseAttachedClientEventUnload(clientDoc);
            } else if (clientDoc.getPhase() == 4) {
                this.response = new ResponseEventDoNothingImpl(this);
            } else {
                clientDoc.setPhase(3);
                this.response = this.createResponseAttachedClientEventRefresh(clientDoc);
            }
            if (this.response != null) {
                this.response.process();
            }
        }
        finally {
            if (clientDoc.isInvalid() || clientDoc.getPhase() == 4) {
                clientDoc.invalidateAndUnregister();
            }
            this.unbindRequestFromDocument();
        }
    }

    public abstract ResponseAttachedClientEventImpl createResponseAttachedClientEventUnload(ClientDocumentAttachedClientImpl var1);

    public abstract ResponseAttachedClientEventImpl createResponseAttachedClientEventRefresh(ClientDocumentAttachedClientImpl var1);

    @Override
    public void processLostSessionOrClientUnloading() {
        ItsNatSessionImpl session = this.getItsNatSession();
        ClientDocumentAttachedClientErrorImpl clientDoc = new ClientDocumentAttachedClientErrorImpl(session);
        this.bindClientToRequest(clientDoc, false);
        this.response = new ResponseEventDoNothingImpl(this);
        this.response.process();
    }

    @Override
    public void processLostSessionError(String sessionId, String sessionToken) {
        ItsNatSessionImpl session = this.getItsNatSession();
        ClientDocumentAttachedClientErrorImpl clientDoc = new ClientDocumentAttachedClientErrorImpl(session);
        clientDoc.setPhase(3);
        this.bindClientToRequest(clientDoc, false);
        this.response = new ResponseAttachedClientErrorEventLostSessionImpl(sessionId, sessionToken, this);
        this.response.process();
    }

    @Override
    public void processClientDocumentNotFoundError(String clientId) {
        ItsNatSessionImpl session = this.getItsNatSession();
        ClientDocumentAttachedClientErrorImpl clientDoc = new ClientDocumentAttachedClientErrorImpl(session);
        clientDoc.setPhase(3);
        this.bindClientToRequest(clientDoc, false);
        this.response = new ResponseAttachedClientErrorEventLostClientDocImpl(this, clientId);
        this.response.process();
    }
}

