/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.req;

import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.clientdoc.ClientDocumentImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.req.RequestCustomImpl;
import org.itsnat.impl.core.req.RequestEventStatelessImpl;
import org.itsnat.impl.core.req.RequestEventStfulImpl;
import org.itsnat.impl.core.req.RequestItsNatInfoImpl;
import org.itsnat.impl.core.req.attachcli.RequestAttachedClientLoadDocImpl;
import org.itsnat.impl.core.req.attachsrv.RequestAttachedServerImpl;
import org.itsnat.impl.core.req.norm.RequestIFrameFileUploadImpl;
import org.itsnat.impl.core.req.norm.RequestNormalLoadDocBaseImpl;
import org.itsnat.impl.core.req.script.RequestLoadScriptImpl;
import org.itsnat.impl.core.resp.ResponseImpl;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionImpl;

public abstract class RequestImpl {
    public static final String ITSNAT_ACTION_EVENT = "event";
    public static final String ITSNAT_ACTION_LOAD_SCRIPT = "load_script";
    public static final String ITSNAT_ACTION_IFRAME_FILE_UPLOAD = "iframe_file_upload";
    public static final String ITSNAT_ACTION_ATTACH_CLIENT = "attach_client";
    public static final String ITSNAT_ACTION_ATTACH_SERVER = "attach_server";
    public static final String ITSNAT_ACTION_ITSNAT_INFO = "itsnat_info";
    public static final String ITSNAT_ACTION_EVENT_STATELESS = "event_stateless";
    public static final String ITSNAT_ACTION_EVENT_STATELESS_PHASE_LOAD_DOC = "event_stateless_phase_load_doc";
    protected ItsNatServletRequestImpl itsNatRequest;
    protected ResponseImpl response;
    protected ClientDocumentImpl clientDoc;

    public RequestImpl(ItsNatServletRequestImpl itsNatRequest) {
        this.itsNatRequest = itsNatRequest;
    }

    public static RequestImpl createRequest(String action, ItsNatServletRequestImpl itsNatRequest) {
        if (action != null) {
            if (action.equals(ITSNAT_ACTION_EVENT)) {
                return RequestEventStfulImpl.createRequestEventStful(itsNatRequest);
            }
            if (action.equals(ITSNAT_ACTION_LOAD_SCRIPT)) {
                return RequestLoadScriptImpl.createRequestLoadScript(itsNatRequest);
            }
            if (action.equals(ITSNAT_ACTION_IFRAME_FILE_UPLOAD)) {
                return RequestIFrameFileUploadImpl.createRequestIFrameFileUpload(itsNatRequest);
            }
            if (action.equals(ITSNAT_ACTION_ATTACH_CLIENT)) {
                return RequestAttachedClientLoadDocImpl.createRequestAttachedClientLoadDoc(itsNatRequest);
            }
            if (action.equals(ITSNAT_ACTION_ATTACH_SERVER)) {
                return RequestAttachedServerImpl.createRequestAttachedServer(itsNatRequest);
            }
            if (action.equals(ITSNAT_ACTION_ITSNAT_INFO)) {
                return RequestItsNatInfoImpl.createRequestItsNatInfo(itsNatRequest);
            }
            if (action.equals(ITSNAT_ACTION_EVENT_STATELESS)) {
                return RequestEventStatelessImpl.createRequestEventStateless(itsNatRequest);
            }
            if (action.equals(ITSNAT_ACTION_EVENT_STATELESS_PHASE_LOAD_DOC)) {
                String docName = itsNatRequest.getAttrOrParam("itsnat_doc_name");
                if (docName != null) {
                    return RequestNormalLoadDocBaseImpl.createRequestNormalLoadDocBase(docName, itsNatRequest, true);
                }
                throw new ItsNatException("INTERNAL ERROR");
            }
            throw new ItsNatException("Unrecognized itsnat_action: \"" + action + "\"");
        }
        String docName = itsNatRequest.getAttrOrParam("itsnat_doc_name");
        if (docName != null) {
            return RequestNormalLoadDocBaseImpl.createRequestNormalLoadDocBase(docName, itsNatRequest, false);
        }
        return RequestCustomImpl.createRequestCustom(itsNatRequest);
    }

    public ItsNatSessionImpl getItsNatSession() {
        return this.itsNatRequest.getItsNatSessionImpl();
    }

    public ItsNatServletRequestImpl getItsNatServletRequest() {
        return this.itsNatRequest;
    }

    public ResponseImpl getResponse() {
        return this.response;
    }

    public void setResponse(ResponseImpl response) {
        this.response = response;
    }

    public abstract ItsNatStfulDocumentImpl getItsNatStfulDocumentReferrer();

    public String getAttrOrParam(String name) {
        return this.itsNatRequest.getAttrOrParam(name);
    }

    public String getAttrOrParamExist(String name) {
        return this.itsNatRequest.getAttrOrParamExist(name);
    }

    public ItsNatDocumentImpl getItsNatDocument() {
        if (this.clientDoc != null) {
            return this.clientDoc.getItsNatDocumentImpl();
        }
        return null;
    }

    public ClientDocumentImpl getClientDocument() {
        return this.clientDoc;
    }

    public void bindClientToRequest(ClientDocumentImpl clientDoc) {
        this.bindClientToRequest(clientDoc, true);
    }

    public void bindClientToRequest(ClientDocumentImpl clientDoc, boolean bindReqToDoc) {
        this.clientDoc = clientDoc;
        if (bindReqToDoc) {
            this.itsNatRequest.bindRequestToDocument(clientDoc.getItsNatDocumentImpl());
        }
    }

    public void unbindRequestFromDocument() {
        this.itsNatRequest.unbindRequestFromDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ClientDocumentStfulImpl clientDocStateless) {
        try {
            this.processRequest(clientDocStateless);
        }
        finally {
            this.notifyEndOfRequestToSession();
            ItsNatSessionImpl itsNatSession = this.itsNatRequest.getItsNatSessionImpl();
            itsNatSession.invalidateLostResources();
        }
    }

    protected abstract boolean isMustNotifyEndOfRequestToSession();

    private void notifyEndOfRequestToSession() {
        if (this.isMustNotifyEndOfRequestToSession()) {
            ItsNatSessionImpl itsNatSession = this.itsNatRequest.getItsNatSessionImpl();
            itsNatSession.endOfRequest();
        }
    }

    public abstract void processRequest(ClientDocumentStfulImpl var1);
}

