/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.req;

import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.req.RequestAlreadyLoadedDocImpl;
import org.itsnat.impl.core.req.attachcli.RequestAttachedClientEventImpl;
import org.itsnat.impl.core.req.norm.RequestNormalEventImpl;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;

public abstract class RequestEventStfulImpl
extends RequestAlreadyLoadedDocImpl {
    public static final int EVENT_TYPE_DOMSTD = 1;
    public static final int EVENT_TYPE_TIMER = 2;
    public static final int EVENT_TYPE_ASYNC_RET = 3;
    public static final int EVENT_TYPE_COMET_RET = 4;
    public static final int EVENT_TYPE_CONTINUE = 5;
    public static final int EVENT_TYPE_USER = 6;
    public static final int EVENT_TYPE_ATTACH_TIMER = 7;
    public static final int EVENT_TYPE_ATTACH_COMET = 8;
    public static final int EVENT_TYPE_ATTACH_NOT_REFRESH = 9;
    public static final int EVENT_TYPE_STATELESS = 10;
    public static final int EVENT_TYPE_DROID = 11;

    public RequestEventStfulImpl(ItsNatServletRequestImpl itsNatRequest) {
        super(itsNatRequest);
    }

    public static RequestEventStfulImpl createRequestEventStful(ItsNatServletRequestImpl itsNatRequest) {
        String eventTypeStr = itsNatRequest.getAttrOrParamExist("itsnat_eventType");
        int evtType = RequestEventStfulImpl.getEventTypeCode(eventTypeStr);
        switch (evtType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                return RequestNormalEventImpl.createRequestNormalEvent(evtType, itsNatRequest);
            }
            case 7: 
            case 8: 
            case 9: {
                return RequestAttachedClientEventImpl.createRequestAttachedClientEvent(evtType, itsNatRequest);
            }
        }
        throw new ItsNatException("Malformed URL/request, bad itsnat_eventType: " + evtType);
    }

    public static int getEventTypeCode(String value) {
        if ("domstd".equals(value)) {
            return 1;
        }
        if ("droid".equals(value)) {
            return 11;
        }
        if ("timer".equals(value)) {
            return 2;
        }
        if ("asyncret".equals(value)) {
            return 3;
        }
        if ("cometret".equals(value)) {
            return 4;
        }
        if ("continue".equals(value)) {
            return 5;
        }
        if ("user".equals(value)) {
            return 6;
        }
        if ("attach_timer".equals(value)) {
            return 7;
        }
        if ("attach_comet".equals(value)) {
            return 8;
        }
        if ("attach_none".equals(value)) {
            return 9;
        }
        if ("stateless".equals(value)) {
            return 10;
        }
        throw new ItsNatException("Unknown itsnat_eventType value:\"" + value + "\"");
    }

    public abstract boolean isUnloadEvent();

    public abstract void processLostSessionError(String var1, String var2);

    public abstract void processClientDocumentNotFoundError(String var1);

    public abstract void processLostSessionOrClientUnloading();

    @Override
    public void processClientDocumentNotFound(String clientId) {
        if (this.isUnloadEvent()) {
            this.processLostSessionOrClientUnloading();
        } else {
            this.processClientDocumentNotFoundError(clientId);
        }
    }

    @Override
    public void processLostSession(String sessionId, String sessionToken) {
        if (this.isUnloadEvent()) {
            this.processLostSessionOrClientUnloading();
        } else {
            this.processLostSessionError(sessionId, sessionToken);
        }
    }
}

