/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.req;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.itsnat.impl.core.clientdoc.ClientDocumentImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentWithoutDocumentDefaultImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.req.RequestImpl;
import org.itsnat.impl.core.resp.ResponseEventStatelessCustomAndDocTemplateNotFoundImpl;
import org.itsnat.impl.core.servlet.ItsNatServletImpl;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;
import org.itsnat.impl.core.servlet.ItsNatServletResponseImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionImpl;

public class RequestEventStatelessImpl
extends RequestImpl {
    public RequestEventStatelessImpl(ItsNatServletRequestImpl itsNatRequest) {
        super(itsNatRequest);
    }

    public static RequestEventStatelessImpl createRequestEventStateless(ItsNatServletRequestImpl itsNatRequest) {
        return new RequestEventStatelessImpl(itsNatRequest);
    }

    @Override
    public ItsNatStfulDocumentImpl getItsNatStfulDocumentReferrer() {
        return null;
    }

    @Override
    public void processRequest(ClientDocumentStfulImpl clientDocStateless) {
        ItsNatServletRequestImpl itsNatRequest = this.getItsNatServletRequest();
        String docName = itsNatRequest.getAttrOrParam("itsnat_doc_name");
        if (docName != null) {
            this.processDocumentTemplateSpecified();
        } else {
            ItsNatServletImpl itsNatServlet = itsNatRequest.getItsNatServletImpl();
            itsNatServlet.dispatchItsNatServletRequestListeners(itsNatRequest);
            docName = itsNatRequest.getAttrOrParam("itsnat_doc_name");
            if (docName != null) {
                this.processDocumentTemplateSpecified();
            } else {
                this.processCustom();
            }
        }
    }

    protected void processDocumentTemplateSpecified() {
        ItsNatServletImpl itsNatServlet = this.itsNatRequest.getItsNatServletImpl();
        ItsNatServletResponseImpl itsNatResponse = this.itsNatRequest.getItsNatServletResponseImpl();
        ServletRequest request = this.itsNatRequest.getServletRequest();
        ServletResponse response = itsNatResponse.getServletResponse();
        request.setAttribute("itsnat_action", (Object)"event_stateless_phase_load_doc");
        ItsNatServletRequestImpl itsNatRequestLoadPhase = itsNatServlet.processRequestInternal(request, response, null);
        ClientDocumentImpl clientDoc = itsNatRequestLoadPhase.getClientDocumentImpl();
        if (clientDoc instanceof ClientDocumentStfulImpl) {
            request.setAttribute("itsnat_action", (Object)"event");
            request.setAttribute("itsnat_eventType", (Object)"stateless");
            ItsNatServletRequestImpl itsNatRequestEventPhase = itsNatServlet.processRequestInternal(request, response, (ClientDocumentStfulImpl)clientDoc);
        } else {
            this.processDocumentTemplateNotFound(clientDoc);
        }
    }

    protected void processCustom() {
        ItsNatSessionImpl session = this.getItsNatSession();
        ClientDocumentWithoutDocumentDefaultImpl clientDoc = new ClientDocumentWithoutDocumentDefaultImpl(session);
        this.bindClientToRequest(clientDoc, false);
        this.response = new ResponseEventStatelessCustomAndDocTemplateNotFoundImpl(this);
        this.response.process();
    }

    public void processDocumentTemplateNotFound(ClientDocumentImpl clientDoc) {
        this.bindClientToRequest(clientDoc, false);
        this.response = new ResponseEventStatelessCustomAndDocTemplateNotFoundImpl(this);
        this.response.process();
    }

    @Override
    protected boolean isMustNotifyEndOfRequestToSession() {
        return false;
    }

    public int getCommMode() {
        return RequestEventStatelessImpl.getCommMode(this.getItsNatServletRequest());
    }

    public int getEventTimeout() {
        return RequestEventStatelessImpl.getEventTimeout(this.getItsNatServletRequest());
    }

    public static int getCommMode(ItsNatServletRequestImpl itsNatRequest) {
        return Integer.parseInt(itsNatRequest.getAttrOrParamExist("itsnat_commMode"));
    }

    public static int getEventTimeout(ItsNatServletRequestImpl itsNatRequest) {
        return Integer.parseInt(itsNatRequest.getAttrOrParamExist("itsnat_eventTimeout"));
    }
}

