/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.req;

import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.req.RequestImpl;
import org.itsnat.impl.core.req.RequestStfulDocument;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionImpl;

public abstract class RequestAlreadyLoadedDocImpl
extends RequestImpl
implements RequestStfulDocument {
    public RequestAlreadyLoadedDocImpl(ItsNatServletRequestImpl itsNatRequest) {
        super(itsNatRequest);
    }

    public abstract void processClientDocument(ClientDocumentStfulImpl var1);

    public abstract void processClientDocumentNotFound(String var1);

    public abstract void processLostSession(String var1, String var2);

    public abstract ClientDocumentStfulImpl getClientDocumentStfulById(String var1);

    @Override
    public ItsNatStfulDocumentImpl getItsNatStfulDocument() {
        return (ItsNatStfulDocumentImpl)this.getItsNatDocument();
    }

    @Override
    public ItsNatStfulDocumentImpl getItsNatStfulDocumentReferrer() {
        return null;
    }

    @Override
    protected boolean isMustNotifyEndOfRequestToSession() {
        return true;
    }

    @Override
    public void processRequest(ClientDocumentStfulImpl clientDocStateless) {
        ClientDocumentStfulImpl clientDoc;
        if (!this.checkValidClientSession()) {
            return;
        }
        if (clientDocStateless != null) {
            clientDoc = clientDocStateless;
        } else {
            String clientId = this.itsNatRequest.getAttrOrParamExist("itsnat_client_id");
            clientDoc = this.getClientDocumentStfulById(clientId);
            if (clientDoc == null) {
                this.processClientDocumentNotFound(clientId);
                return;
            }
        }
        this.processClientDocument(clientDoc);
    }

    public String getRequestedSessionId() {
        ItsNatServletRequestImpl itsNatReq = this.getItsNatServletRequest();
        return itsNatReq.getAttrOrParamExist("itsnat_session_id");
    }

    public String getRequestedSessionToken() {
        ItsNatServletRequestImpl itsNatReq = this.getItsNatServletRequest();
        return itsNatReq.getAttrOrParamExist("itsnat_session_token");
    }

    private boolean checkValidClientSession() {
        String sessionToken;
        String sessionId = this.getRequestedSessionId();
        if (!this.isValidClientSession(sessionId, sessionToken = this.getRequestedSessionToken())) {
            this.processLostSession(sessionId, sessionToken);
            return false;
        }
        return true;
    }

    public boolean isValidClientSession(String sessionId, String sessionToken) {
        ItsNatServletRequestImpl itsNatReq = this.getItsNatServletRequest();
        if (!itsNatReq.isValidClientStandardSessionId()) {
            return false;
        }
        ItsNatSessionImpl itsNatSession = itsNatReq.getItsNatSessionImpl();
        return itsNatSession.getId().equals(sessionId) && itsNatSession.getToken().equals(sessionToken);
    }
}

