/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.registry;

import java.util.LinkedList;
import java.util.Map;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.clientdoc.ClientDocumentAttachedClientImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.clientdoc.droid.ClientDocumentStfulDelegateDroidImpl;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.clientdoc.web.SVGWebInfoImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.listener.EventListenerSerializableInternal;
import org.itsnat.impl.core.listener.ItsNatNormalEventListenerWrapperImpl;
import org.itsnat.impl.core.registry.EventListenerRegistryImpl;
import org.itsnat.impl.core.util.MapUniqueId;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

public abstract class ItsNatNormalEventListenerRegistryImpl
extends EventListenerRegistryImpl {
    protected ItsNatStfulDocumentImpl itsNatDoc;
    protected ClientDocumentStfulImpl clientDocTarget;
    protected int capturingCount;
    protected MapUniqueId<ItsNatNormalEventListenerWrapperImpl> eventListenersById;

    public ItsNatNormalEventListenerRegistryImpl(ItsNatStfulDocumentImpl itsNatDoc, ClientDocumentStfulImpl clientDoc) {
        this.itsNatDoc = itsNatDoc;
        this.clientDocTarget = clientDoc;
        this.eventListenersById = new MapUniqueId(itsNatDoc.getUniqueIdGenerator());
    }

    public ItsNatStfulDocumentImpl getItsNatStfulDocumentImpl() {
        return this.itsNatDoc;
    }

    public ClientDocumentStfulImpl getClientDocumentStfulTarget() {
        return this.clientDocTarget;
    }

    public ClientDocumentStfulDelegateImpl getClientDocumentStfulDelegateFromDocument() {
        return ((ClientDocumentStfulImpl)this.itsNatDoc.getClientDocumentOwnerImpl()).getClientDocumentStfulDelegate();
    }

    public ClientDocumentStfulDelegateImpl getClientDocumentStfulDelegateTarget() {
        return this.clientDocTarget != null ? this.clientDocTarget.getClientDocumentStfulDelegate() : null;
    }

    public boolean isEmpty() {
        return this.eventListenersById.isEmpty();
    }

    public void checkValidEventTarget(EventTarget target, String type) {
        this.isValidEventTarget(target, type, true);
    }

    public boolean isValidEventTarget(EventTarget target, String type, boolean throwErr) {
        if (target == null) {
            return true;
        }
        Node node = (Node)((Object)target);
        short nodeType = node.getNodeType();
        if (nodeType == 3) {
            if (throwErr) {
                throw new ItsNatException("Text node is not allowed", (Object)target);
            }
            return false;
        }
        return true;
    }

    public int getCapturingCount() {
        return this.capturingCount;
    }

    public boolean canAddItsNatNormalEventListener(EventTarget target, String type, EventListener listener) {
        if (!ItsNatNormalEventListenerWrapperImpl.canAddItsNatNormalEventListenerWrapper(listener, this.itsNatDoc, this.clientDocTarget)) {
            return false;
        }
        this.checkValidEventTarget(target, type);
        return true;
    }

    protected void addItsNatNormalEventListener(ItsNatNormalEventListenerWrapperImpl listenerWrapper) {
        this.eventListenersById.put(listenerWrapper);
        ItsNatNormalEventListenerRegistryImpl.addItsNatEventListenerCode(listenerWrapper, this.getClientDocumentStfulDelegateTarget());
        if (listenerWrapper.getUseCapture()) {
            ++this.capturingCount;
        }
    }

    public void removeItsNatNormalEventListener(ItsNatNormalEventListenerWrapperImpl listener, boolean updateClient, boolean expunged) {
        ItsNatNormalEventListenerWrapperImpl listenerRes = this.removeItsNatNormalEventListenerByIdPrivate(listener.getId(), updateClient);
        if (listenerRes == null) {
            return;
        }
        if (listenerRes != listener) {
            throw new ItsNatException("INTERNAL ERROR");
        }
    }

    private ItsNatNormalEventListenerWrapperImpl removeItsNatNormalEventListenerByIdPrivate(String id, boolean updateClient) {
        ItsNatNormalEventListenerWrapperImpl listenerWrapper = this.eventListenersById.removeById(id);
        if (listenerWrapper == null) {
            return null;
        }
        if (updateClient) {
            ItsNatNormalEventListenerRegistryImpl.removeItsNatEventListenerCode(listenerWrapper, this.getClientDocumentStfulDelegateTarget());
        }
        if (listenerWrapper.getUseCapture()) {
            --this.capturingCount;
        }
        return listenerWrapper;
    }

    protected ItsNatNormalEventListenerWrapperImpl removeItsNatNormalEventListenerById(String id, boolean updateClient) {
        return this.removeItsNatNormalEventListenerByIdPrivate(id, updateClient);
    }

    public ItsNatNormalEventListenerWrapperImpl getItsNatNormalEventListenerById(String listenerId) {
        return this.eventListenersById.get(listenerId);
    }

    public abstract EventListener[] getEventListenersArrayCopy(EventTarget var1, String var2, boolean var3);

    public void renderItsNatNormalEventListeners(final ClientDocumentAttachedClientImpl clientDoc) {
        if (clientDoc == null || this.getClientDocumentStfulTarget() != null) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        if (this.eventListenersById.isEmpty()) {
            return;
        }
        LinkedList<ItsNatNormalEventListenerWrapperImpl> svgWebNodes = null;
        for (Map.Entry<String, ItsNatNormalEventListenerWrapperImpl> entry : this.eventListenersById.entrySet()) {
            ItsNatNormalEventListenerWrapperImpl listenerWrapper = entry.getValue();
            if (!clientDoc.canReceiveNormalEvents(listenerWrapper)) continue;
            ClientDocumentStfulDelegateImpl clientDocDeleg = clientDoc.getClientDocumentStfulDelegate();
            if (clientDocDeleg instanceof ClientDocumentStfulDelegateWebImpl) {
                EventTarget currTarget = listenerWrapper.getCurrentTarget();
                if (SVGWebInfoImpl.isSVGNodeProcessedBySVGWebFlash((Node)((Object)currTarget), (ClientDocumentStfulDelegateWebImpl)clientDocDeleg)) {
                    if (svgWebNodes == null) {
                        svgWebNodes = new LinkedList<ItsNatNormalEventListenerWrapperImpl>();
                    }
                    svgWebNodes.add(listenerWrapper);
                    continue;
                }
                ItsNatNormalEventListenerRegistryImpl.addItsNatEventListenerCode(listenerWrapper, clientDocDeleg);
                continue;
            }
            if (!(clientDocDeleg instanceof ClientDocumentStfulDelegateDroidImpl)) continue;
            ItsNatNormalEventListenerRegistryImpl.addItsNatEventListenerCode(listenerWrapper, clientDocDeleg);
        }
        if (svgWebNodes != null) {
            final LinkedList<ItsNatNormalEventListenerWrapperImpl> svgWebNodes2 = svgWebNodes;
            EventListenerSerializableInternal listener = new EventListenerSerializableInternal(){

                @Override
                public void handleEvent(Event evt) {
                    for (ItsNatNormalEventListenerWrapperImpl listenerWrapper : svgWebNodes2) {
                        if (!ItsNatNormalEventListenerRegistryImpl.this.eventListenersById.containsKey(listenerWrapper)) continue;
                        ClientDocumentStfulDelegateImpl clientDocDeleg = clientDoc.getClientDocumentStfulDelegate();
                        EventListenerRegistryImpl.addItsNatEventListenerCode(listenerWrapper, clientDocDeleg);
                    }
                }
            };
            AbstractView view = ((DocumentView)((Object)this.itsNatDoc.getDocument())).getDefaultView();
            clientDoc.addEventListener((EventTarget)((Object)view), "SVGLoad", listener, false);
        }
    }

    public void removeAllItsNatNormalEventListeners(boolean updateClient) {
        if (this.eventListenersById.isEmpty()) {
            return;
        }
        ItsNatNormalEventListenerWrapperImpl[] listenerList = (ItsNatNormalEventListenerWrapperImpl[])this.eventListenersById.toArray(new ItsNatNormalEventListenerWrapperImpl[this.eventListenersById.size()]);
        for (int i = 0; i < listenerList.length; ++i) {
            ItsNatNormalEventListenerWrapperImpl listener = listenerList[i];
            this.removeItsNatNormalEventListener(listener, updateClient, false);
        }
    }
}

