/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.registry;

import com.innowhere.relproxy.jproxy.JProxyScriptEngine;
import java.io.Serializable;
import java.util.LinkedList;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.event.ItsNatEventListenerChainImpl;
import org.itsnat.impl.core.listener.EventListenerInternal;
import org.itsnat.impl.core.listener.ItsNatNormalEventListenerWrapperImpl;
import org.itsnat.impl.core.util.MapListImpl;
import org.w3c.dom.events.EventListener;

public class ItsNatNormalEventListenerListSameTarget
implements Serializable {
    protected ItsNatDocumentImpl itsNatDoc;
    protected MapListImpl<String, Pair> listeners = new MapListImpl();

    public ItsNatNormalEventListenerListSameTarget(ItsNatDocumentImpl itsNatDoc) {
        this.itsNatDoc = itsNatDoc;
    }

    public ItsNatDocumentImpl getItsNatDocumentImpl() {
        return this.itsNatDoc;
    }

    public static String getKey(String type, boolean useCapture) {
        return useCapture + "_" + type;
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public boolean containsItsNatNormalEventListener(String type, boolean useCapture, EventListener listener) {
        String key = ItsNatNormalEventListenerListSameTarget.getKey(type, useCapture);
        Pair value = new Pair(listener, this.getItsNatDocumentImpl());
        return this.listeners.contains(key, value);
    }

    public void addItsNatNormalEventListener(String type, boolean useCapture, EventListener listener) {
        this.addItsNatNormalEventListener(type, useCapture, listener, null);
    }

    public void addItsNatNormalEventListener(String type, boolean useCapture, ItsNatNormalEventListenerWrapperImpl listenerWrapper) {
        this.addItsNatNormalEventListener(type, useCapture, null, listenerWrapper);
    }

    private void addItsNatNormalEventListener(String type, boolean useCapture, EventListener listener, ItsNatNormalEventListenerWrapperImpl listenerWrapper) {
        String key = ItsNatNormalEventListenerListSameTarget.getKey(type, useCapture);
        Pair value = new Pair(listener, listenerWrapper, this.getItsNatDocumentImpl());
        this.listeners.add(key, value);
    }

    public ItsNatNormalEventListenerWrapperImpl removeItsNatNormalEventListener(String type, boolean useCapture, EventListener listener) {
        String key = ItsNatNormalEventListenerListSameTarget.getKey(type, useCapture);
        Pair removed = this.listeners.remove(key, new Pair(listener, null, this.getItsNatDocumentImpl()));
        if (removed == null) {
            return null;
        }
        return removed.getListenerWrapper();
    }

    public boolean removeItsNatNormalEventListener(ItsNatNormalEventListenerWrapperImpl listenerWrapper) {
        ItsNatNormalEventListenerWrapperImpl listenerRes = this.removeItsNatNormalEventListener(listenerWrapper.getType(), listenerWrapper.getUseCapture(), listenerWrapper.getEventListenerOrProxy());
        if (listenerRes == null) {
            return false;
        }
        if (listenerWrapper != listenerRes) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        return true;
    }

    public void removeAllItsNatNormalEventListeners() {
        this.listeners.clear();
    }

    public LinkedList<Pair> getAllItsNatNormalEventListenersCopy() {
        return this.listeners.getAllValuesCopy();
    }

    public boolean hasItsNatNormalEventListeners(String type, boolean useCapture) {
        LinkedList<Pair> listeners = this.getItsNatNormalEventListeners(type, useCapture);
        return listeners != null && !listeners.isEmpty();
    }

    public LinkedList<Pair> getItsNatNormalEventListeners(String type, boolean useCapture) {
        String key = ItsNatNormalEventListenerListSameTarget.getKey(type, useCapture);
        return this.listeners.get(key);
    }

    public boolean getItsNatNormalEventListenerList(String type, boolean useCapture, ItsNatEventListenerChainImpl<EventListener> chain) {
        LinkedList<Pair> list = this.getItsNatNormalEventListeners(type, useCapture);
        if (list == null) {
            return false;
        }
        LinkedList<EventListener> evtListeners = new LinkedList<EventListener>();
        for (Pair currPair : list) {
            evtListeners.add(currPair.getEventListenerOrProxy());
        }
        chain.addFirstListenerList(evtListeners);
        return true;
    }

    public EventListener[] getEventListenersArrayCopy(String type, boolean useCapture) {
        LinkedList<Pair> list = this.getItsNatNormalEventListeners(type, useCapture);
        if (list == null) {
            return null;
        }
        EventListener[] listeners = new EventListener[list.size()];
        int i = 0;
        for (Pair currPair : list) {
            listeners[i] = currPair.getEventListenerOrProxy();
            ++i;
        }
        return listeners;
    }

    public static class Pair
    implements Serializable {
        private final EventListener listener;
        private final ItsNatNormalEventListenerWrapperImpl listenerWrapper;

        private Pair(ItsNatNormalEventListenerWrapperImpl listenerWrapper, ItsNatDocumentImpl itsNatDoc) {
            this(null, listenerWrapper, itsNatDoc);
        }

        private Pair(EventListener listener, ItsNatDocumentImpl itsNatDoc) {
            this(listener, null, itsNatDoc);
        }

        private Pair(EventListener listener, ItsNatNormalEventListenerWrapperImpl listenerWrapper, ItsNatDocumentImpl itsNatDoc) {
            if (listenerWrapper == null) {
                JProxyScriptEngine jProxy;
                if (listener == null) {
                    throw new ItsNatException("INTERNAL ERROR");
                }
                if (!(listener instanceof EventListenerInternal) && (jProxy = itsNatDoc.getItsNatServlet().getItsNatImpl().getJProxyScriptEngineIfConfigured()) != null) {
                    listener = (EventListener)jProxy.create((Object)listener, EventListener.class);
                }
                this.listener = listener;
                this.listenerWrapper = null;
            } else {
                this.listener = null;
                this.listenerWrapper = listenerWrapper;
            }
        }

        public EventListener getEventListenerOrProxy() {
            if (this.listenerWrapper != null) {
                return this.listenerWrapper.getEventListenerOrProxy();
            }
            return this.listener;
        }

        public ItsNatNormalEventListenerWrapperImpl getListenerWrapper() {
            return this.listenerWrapper;
        }

        public boolean equals(Object other) {
            boolean res = super.equals(other);
            if (res) {
                return true;
            }
            if (other == null) {
                return false;
            }
            return this.getEventListenerOrProxy().equals(((Pair)other).getEventListenerOrProxy());
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }
}

