/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.registry;

import org.itsnat.core.ItsNatException;
import org.itsnat.core.event.ParamTransport;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulDelegateImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.comet.CometNotifierImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.listener.CometTaskEventListenerWrapper;
import org.itsnat.impl.core.listener.CometTaskImpl;
import org.itsnat.impl.core.listener.ItsNatEventListenerWrapperImpl;
import org.itsnat.impl.core.registry.EventListenerRegistryImpl;
import org.itsnat.impl.core.util.MapUniqueId;

public abstract class CometTaskRegistryImpl
extends EventListenerRegistryImpl {
    protected MapUniqueId<ItsNatEventListenerWrapperImpl> tasks;
    protected ClientDocumentStfulImpl clientDoc;

    public CometTaskRegistryImpl(ClientDocumentStfulImpl clientDoc) {
        this.clientDoc = clientDoc;
        this.tasks = new MapUniqueId(clientDoc.getUniqueIdGenerator());
    }

    public ItsNatStfulDocumentImpl getItsNatStfulDocument() {
        return this.clientDoc.getItsNatStfulDocument();
    }

    public abstract CometTaskEventListenerWrapper createCometTaskEventListenerWrapper(CometTaskImpl var1, ParamTransport[] var2, String var3);

    public abstract boolean canAddItsNatEventListener(CometNotifierImpl var1);

    public void addCometTask(CometNotifierImpl notifier, ParamTransport[] extraParams, String preSendCode) {
        if (!this.canAddItsNatEventListener(notifier)) {
            return;
        }
        CometTaskImpl taskContainer = new CometTaskImpl(notifier);
        ItsNatEventListenerWrapperImpl listener = (ItsNatEventListenerWrapperImpl)((Object)this.createCometTaskEventListenerWrapper(taskContainer, extraParams, preSendCode));
        this.tasks.put(listener);
        ClientDocumentStfulDelegateImpl clientDocDeleg = this.clientDoc.getClientDocumentStfulDelegate();
        CometTaskRegistryImpl.addItsNatEventListenerCode(listener, clientDocDeleg);
    }

    public CometTaskEventListenerWrapper removeCometTask(String id) {
        CometTaskEventListenerWrapper listener = (CometTaskEventListenerWrapper)((Object)this.tasks.removeById(id));
        if (listener == null) {
            throw new ItsNatException("Comet Task with id " + id + " does not exist");
        }
        return listener;
    }
}

